/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.SocketFactory;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.data.gemfire.AbstractBasicCacheFactoryBean;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.client.support.DefaultableDelegatingPoolAdapter;
import org.springframework.data.gemfire.client.support.DelegatingPoolAdapter;
import org.springframework.data.gemfire.client.support.PoolManagerPoolResolver;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.support.ConnectionEndpoint;
import org.springframework.data.gemfire.support.ConnectionEndpointList;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.DistributedSystemUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean
implements ApplicationListener<ContextRefreshedEvent> {
    protected static final PoolResolver DEFAULT_POOL_RESOLVER = new PoolManagerPoolResolver();
    private Boolean keepAlive = false;
    private Boolean multiUserAuthentication;
    private Boolean prSingleHopEnabled;
    private Boolean readyForEvents;
    private Boolean subscriptionEnabled;
    private Boolean threadLocalConnections;
    private final ConnectionEndpointList locators = new ConnectionEndpointList();
    private final ConnectionEndpointList servers = new ConnectionEndpointList();
    private Integer durableClientTimeout;
    private Integer freeConnectionTimeout;
    private Integer loadConditioningInterval;
    private Integer maxConnections;
    private Integer minConnections;
    private Integer readTimeout;
    private Integer retryAttempts;
    private Integer serverConnectionTimeout;
    private Integer socketBufferSize;
    private Integer socketConnectTimeout;
    private Integer statisticsInterval;
    private Integer subscriptionAckInterval;
    private Integer subscriptionMessageTrackingTimeout;
    private Integer subscriptionRedundancy;
    private List<ClientCacheConfigurer> clientCacheConfigurers = Collections.emptyList();
    private Long idleTimeout;
    private Long pingInterval;
    private Pool pool;
    private PoolResolver poolResolver = DEFAULT_POOL_RESOLVER;
    private SocketFactory socketFactory;
    private String durableClientId;
    private String poolName;
    private String serverGroup;
    private final ClientCacheConfigurer compositeClientCacheConfigurer = (beanName, bean) -> CollectionUtils.nullSafeCollection(this.clientCacheConfigurers).forEach(clientCacheConfigurer -> clientCacheConfigurer.configure(beanName, bean));

    @Override
    protected void applyCacheConfigurers() {
        this.applyClientCacheConfigurers(this.getCompositeClientCacheConfigurer());
    }

    protected void applyClientCacheConfigurers(ClientCacheConfigurer ... clientCacheConfigurers) {
        this.applyClientCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(clientCacheConfigurers, ClientCacheConfigurer.class)));
    }

    protected void applyClientCacheConfigurers(Iterable<ClientCacheConfigurer> clientCacheConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(clientCacheConfigurers).spliterator(), false).forEach(clientCacheConfigurer -> clientCacheConfigurer.configure(this.getBeanName(), this));
    }

    @Override
    protected <T extends GemFireCache> T doFetchCache() {
        return (T)ClientCacheFactory.getAnyInstance();
    }

    @Override
    protected Class<? extends GemFireCache> doGetObjectType() {
        return ClientCache.class;
    }

    @Override
    @NonNull
    protected Properties resolveProperties() {
        return this.resolveProperties(DistributedSystemUtils::getDistributedSystem);
    }

    @NonNull
    Properties resolveProperties(@NonNull Supplier<DistributedSystem> distributedSystemSupplier) {
        Properties gemfireProperties = super.resolveProperties();
        DistributedSystem distributedSystem = distributedSystemSupplier.get();
        if (GemfireUtils.isConnected(distributedSystem)) {
            Properties distributedSystemProperties = (Properties)distributedSystem.getProperties().clone();
            distributedSystemProperties.putAll((Map<?, ?>)gemfireProperties);
            gemfireProperties = distributedSystemProperties;
        }
        GemfireUtils.configureDurableClient(gemfireProperties, this.getDurableClientId(), this.getDurableClientTimeout());
        return gemfireProperties;
    }

    @Override
    @NonNull
    protected Object createFactory(@NonNull Properties gemfireProperties) {
        return new ClientCacheFactory(gemfireProperties);
    }

    @Override
    @NonNull
    protected Object configureFactory(@NonNull Object factory) {
        return this.configurePool(this.configurePdx((ClientCacheFactory)factory));
    }

    @NonNull
    protected ClientCacheFactory configurePdx(@NonNull ClientCacheFactory clientCacheFactory) {
        ClientCacheFactoryToPdxConfigurerAdapter pdxConfigurer = ClientCacheFactoryToPdxConfigurerAdapter.from(clientCacheFactory);
        return this.configurePdx(pdxConfigurer);
    }

    @NonNull
    protected ClientCacheFactory configurePool(@NonNull ClientCacheFactory clientCacheFactory) {
        boolean hasServers;
        DefaultableDelegatingPoolAdapter pool = DefaultableDelegatingPoolAdapter.from(DelegatingPoolAdapter.from(this.resolvePool())).preferDefault();
        clientCacheFactory.setPoolFreeConnectionTimeout(pool.getFreeConnectionTimeout(this.getFreeConnectionTimeout()));
        clientCacheFactory.setPoolIdleTimeout(pool.getIdleTimeout(this.getIdleTimeout()));
        clientCacheFactory.setPoolLoadConditioningInterval(pool.getLoadConditioningInterval(this.getLoadConditioningInterval()));
        clientCacheFactory.setPoolMaxConnections(pool.getMaxConnections(this.getMaxConnections()));
        clientCacheFactory.setPoolMinConnections(pool.getMinConnections(this.getMinConnections()));
        clientCacheFactory.setPoolMultiuserAuthentication(pool.getMultiuserAuthentication(this.getMultiUserAuthentication()));
        clientCacheFactory.setPoolPingInterval(pool.getPingInterval(this.getPingInterval()));
        clientCacheFactory.setPoolPRSingleHopEnabled(pool.getPRSingleHopEnabled(this.getPrSingleHopEnabled()));
        clientCacheFactory.setPoolReadTimeout(pool.getReadTimeout(this.getReadTimeout()));
        clientCacheFactory.setPoolRetryAttempts(pool.getRetryAttempts(this.getRetryAttempts()));
        clientCacheFactory.setPoolServerConnectionTimeout(pool.getServerConnectionTimeout(this.getServerConnectionTimeout()));
        clientCacheFactory.setPoolServerGroup(pool.getServerGroup(this.getServerGroup()));
        clientCacheFactory.setPoolSocketBufferSize(pool.getSocketBufferSize(this.getSocketBufferSize()));
        clientCacheFactory.setPoolSocketConnectTimeout(pool.getSocketConnectTimeout(this.getSocketConnectTimeout()));
        clientCacheFactory.setPoolSocketFactory(pool.getSocketFactory(this.getSocketFactory()));
        clientCacheFactory.setPoolStatisticInterval(pool.getStatisticInterval(this.getStatisticsInterval()));
        clientCacheFactory.setPoolSubscriptionAckInterval(pool.getSubscriptionAckInterval(this.getSubscriptionAckInterval()));
        clientCacheFactory.setPoolSubscriptionEnabled(pool.getSubscriptionEnabled(this.getSubscriptionEnabled()));
        clientCacheFactory.setPoolSubscriptionMessageTrackingTimeout(pool.getSubscriptionMessageTrackingTimeout(this.getSubscriptionMessageTrackingTimeout()));
        clientCacheFactory.setPoolSubscriptionRedundancy(pool.getSubscriptionRedundancy(this.getSubscriptionRedundancy()));
        clientCacheFactory.setPoolThreadLocalConnections(pool.getThreadLocalConnections(this.getThreadLocalConnections()));
        AtomicBoolean noServers = new AtomicBoolean(this.getServers().isEmpty());
        boolean noLocators = this.getLocators().isEmpty();
        boolean hasLocators = !noLocators;
        boolean bl = hasServers = !noServers.get();
        if (hasServers || noLocators) {
            List<InetSocketAddress> servers = pool.getServers(this.getServers().toInetSocketAddresses());
            StreamSupport.stream(servers.spliterator(), false).forEach(server -> {
                clientCacheFactory.addPoolServer(server.getHostName(), server.getPort());
                noServers.set(false);
            });
        }
        if (hasLocators || noServers.get()) {
            List<InetSocketAddress> locators = pool.getLocators(this.getLocators().toInetSocketAddresses());
            StreamSupport.stream(locators.spliterator(), false).forEach(locator -> clientCacheFactory.addPoolLocator(locator.getHostName(), locator.getPort()));
        }
        return clientCacheFactory;
    }

    @Nullable
    protected Pool resolvePool() {
        String poolName;
        Pool pool = this.getPool();
        if (pool == null && (pool = this.findPool(poolName = this.resolvePoolName())) == null && this.isPoolNameResolvable(poolName)) {
            String dereferencedPoolName = SpringUtils.dereferenceBean(poolName);
            PoolFactoryBean poolFactoryBean = (PoolFactoryBean)this.getBeanFactory().getBean(dereferencedPoolName, PoolFactoryBean.class);
            return poolFactoryBean.getPool();
        }
        return pool;
    }

    private boolean isPoolNameResolvable(@Nullable String poolName) {
        return Optional.ofNullable(poolName).filter(StringUtils::hasText).filter(arg_0 -> ((BeanFactory)this.getBeanFactory()).containsBean(arg_0)).isPresent();
    }

    @NonNull
    String resolvePoolName() {
        return Optional.ofNullable(this.getPoolName()).filter(StringUtils::hasText).orElseGet(this::getDefaultPoolName);
    }

    @NonNull
    String getDefaultPoolName() {
        return "gemfirePool";
    }

    Pool findPool(String name) {
        return this.getPoolResolver().resolve(name);
    }

    @Override
    @NonNull
    protected <T extends GemFireCache> T createCache(@NonNull Object factory) {
        return (T)((ClientCacheFactory)factory).create();
    }

    public void onApplicationEvent(@NonNull ContextRefreshedEvent event) {
        if (this.isReadyForEvents()) {
            try {
                ((ClientCache)this.fetchCache()).readyForEvents();
            }
            catch (IllegalStateException | CacheClosedException throwable) {
                // empty catch block
            }
        }
    }

    @Override
    protected void close(@NonNull GemFireCache cache) {
        ((ClientCache)cache).close(this.isKeepAlive());
    }

    public void addLocators(ConnectionEndpoint ... locators) {
        this.locators.add(locators);
    }

    public void addLocators(Iterable<ConnectionEndpoint> locators) {
        this.locators.add(locators);
    }

    public void addServers(ConnectionEndpoint ... servers) {
        this.servers.add(servers);
    }

    public void addServers(Iterable<ConnectionEndpoint> servers) {
        this.servers.add(servers);
    }

    public void setClientCacheConfigurers(ClientCacheConfigurer ... clientCacheConfigurers) {
        this.setClientCacheConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(clientCacheConfigurers, ClientCacheConfigurer.class)));
    }

    public void setClientCacheConfigurers(List<ClientCacheConfigurer> clientCacheConfigurers) {
        this.clientCacheConfigurers = clientCacheConfigurers != null ? clientCacheConfigurers : Collections.emptyList();
    }

    @NonNull
    public ClientCacheConfigurer getCompositeClientCacheConfigurer() {
        return this.compositeClientCacheConfigurer;
    }

    public void setDurableClientId(String durableClientId) {
        this.durableClientId = durableClientId;
    }

    public String getDurableClientId() {
        return this.durableClientId;
    }

    public void setDurableClientTimeout(Integer durableClientTimeout) {
        this.durableClientTimeout = durableClientTimeout;
    }

    public Integer getDurableClientTimeout() {
        return this.durableClientTimeout;
    }

    @Override
    public final void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        throw new UnsupportedOperationException("Auto-reconnect does not apply to clients");
    }

    @Override
    public final Boolean getEnableAutoReconnect() {
        return Boolean.FALSE;
    }

    public void setFreeConnectionTimeout(Integer freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public Integer getFreeConnectionTimeout() {
        return this.freeConnectionTimeout;
    }

    public void setIdleTimeout(Long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public boolean isKeepAlive() {
        return Boolean.TRUE.equals(this.getKeepAlive());
    }

    public void setLoadConditioningInterval(Integer loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public Integer getLoadConditioningInterval() {
        return this.loadConditioningInterval;
    }

    public void setLocators(ConnectionEndpoint[] locators) {
        this.setLocators(ConnectionEndpointList.from(locators));
    }

    public void setLocators(Iterable<ConnectionEndpoint> locators) {
        this.getLocators().clear();
        this.addLocators(locators);
    }

    protected ConnectionEndpointList getLocators() {
        return this.locators;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMinConnections(Integer minConnections) {
        this.minConnections = minConnections;
    }

    public Integer getMinConnections() {
        return this.minConnections;
    }

    public void setMultiUserAuthentication(Boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public Boolean getMultiUserAuthentication() {
        return this.multiUserAuthentication;
    }

    public void setPool(@Nullable Pool pool) {
        this.pool = pool;
    }

    @Nullable
    public Pool getPool() {
        return this.pool;
    }

    public void setPoolName(@Nullable String poolName) {
        this.poolName = poolName;
    }

    @Nullable
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolResolver(@Nullable PoolResolver poolResolver) {
        this.poolResolver = poolResolver;
    }

    @NonNull
    public PoolResolver getPoolResolver() {
        PoolResolver poolResolver = this.poolResolver;
        return poolResolver != null ? poolResolver : DEFAULT_POOL_RESOLVER;
    }

    public void setPingInterval(Long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public Long getPingInterval() {
        return this.pingInterval;
    }

    public void setPrSingleHopEnabled(Boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public Boolean getPrSingleHopEnabled() {
        return this.prSingleHopEnabled;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadyForEvents(Boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    public Boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    public boolean isReadyForEvents() {
        Boolean readyForEvents = this.getReadyForEvents();
        return readyForEvents != null ? Boolean.TRUE.equals(readyForEvents) : SpringUtils.safeGetValue(() -> GemfireUtils.isDurable((ClientCache)this.fetchCache()), false).booleanValue();
    }

    public void setRetryAttempts(Integer retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public Integer getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setServerConnectionTimeout(Integer serverConnectionTimeout) {
        this.serverConnectionTimeout = serverConnectionTimeout;
    }

    public Integer getServerConnectionTimeout() {
        return this.serverConnectionTimeout;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public void setServers(ConnectionEndpoint[] servers) {
        this.setServers(ConnectionEndpointList.from(servers));
    }

    public void setServers(Iterable<ConnectionEndpoint> servers) {
        this.getServers().clear();
        this.addServers(servers);
    }

    protected ConnectionEndpointList getServers() {
        return this.servers;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketConnectTimeout(Integer socketConnectTimeout) {
        this.socketConnectTimeout = socketConnectTimeout;
    }

    public Integer getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    public void setSocketFactory(@Nullable SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    @NonNull
    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setStatisticsInterval(Integer statisticsInterval) {
        this.statisticsInterval = statisticsInterval;
    }

    public Integer getStatisticsInterval() {
        return this.statisticsInterval;
    }

    public void setSubscriptionAckInterval(Integer subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public Integer getSubscriptionAckInterval() {
        return this.subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(Boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public Boolean getSubscriptionEnabled() {
        return this.subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(Integer subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public Integer getSubscriptionMessageTrackingTimeout() {
        return this.subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(Integer subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public Integer getSubscriptionRedundancy() {
        return this.subscriptionRedundancy;
    }

    public void setThreadLocalConnections(Boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public Boolean getThreadLocalConnections() {
        return this.threadLocalConnections;
    }

    @Override
    public final void setUseClusterConfiguration(Boolean useClusterConfiguration) {
        throw new UnsupportedOperationException("Cluster-based Configuration does not apply to clients");
    }

    @Override
    public final Boolean getUseClusterConfiguration() {
        return Boolean.FALSE;
    }

    public static class ClientCacheFactoryToPdxConfigurerAdapter
    implements AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> {
        private final ClientCacheFactory cacheFactory;

        public static ClientCacheFactoryToPdxConfigurerAdapter from(@NonNull ClientCacheFactory clientCacheFactory) {
            return new ClientCacheFactoryToPdxConfigurerAdapter(clientCacheFactory);
        }

        protected ClientCacheFactoryToPdxConfigurerAdapter(@NonNull ClientCacheFactory cacheFactory) {
            Assert.notNull((Object)cacheFactory, (String)"ClientCacheFactory must not be null");
            this.cacheFactory = cacheFactory;
        }

        @Override
        @NonNull
        public ClientCacheFactory getTarget() {
            return this.cacheFactory;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> setDiskStoreName(String diskStoreName) {
            this.getTarget().setPdxDiskStore(diskStoreName);
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> setIgnoreUnreadFields(Boolean ignoreUnreadFields) {
            this.getTarget().setPdxIgnoreUnreadFields(ignoreUnreadFields.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> setPersistent(Boolean persistent) {
            this.getTarget().setPdxPersistent(persistent.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> setReadSerialized(Boolean readSerialized) {
            this.getTarget().setPdxReadSerialized(readSerialized.booleanValue());
            return this;
        }

        @Override
        @NonNull
        public AbstractBasicCacheFactoryBean.PdxConfigurer<ClientCacheFactory> setSerializer(PdxSerializer pdxSerializer) {
            this.getTarget().setPdxSerializer(pdxSerializer);
            return this;
        }
    }
}

