/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.transaction.event;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.StringUtils;

public class TransactionApplicationEvent
extends ApplicationEvent {
    protected static final String TIMESTAMP_PATTERN = "yyyy-MM-dd-hh:mm:ss.S";
    private String details;

    public static TransactionApplicationEvent of(Object source) {
        return new TransactionApplicationEvent(source);
    }

    public TransactionApplicationEvent(Object source) {
        this(source, null);
    }

    public TransactionApplicationEvent(Object source, String details) {
        super(source);
        this.details = details;
    }

    public Optional<String> getDetails() {
        return Optional.ofNullable(this.details).filter(StringUtils::hasText);
    }

    public LocalDateTime getTimestampAsLocalDateTime() {
        return LocalDateTime.from(Instant.ofEpochMilli(this.getTimestamp()));
    }

    public String getTimestampAsString() {
        return this.getTimestampAsString(TIMESTAMP_PATTERN);
    }

    public String getTimestampAsString(String pattern) {
        return this.getTimestampAsLocalDateTime().format(DateTimeFormatter.ofPattern(pattern));
    }

    public String toString() {
        return this.getDetails().map(details -> String.format("%s - %s", this.getTimestampAsString(), details)).orElse(String.format("%s[%s]", ((Object)((Object)this)).getClass().getSimpleName(), this.getTimestampAsString()));
    }

    public TransactionApplicationEvent with(String details) {
        this.details = details;
        return this;
    }
}

