/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GemfireBeanFactoryLocator
implements BeanFactoryAware,
BeanNameAware,
DisposableBean,
InitializingBean {
    protected static final ConcurrentMap<String, BeanFactory> BEAN_FACTORIES = new ConcurrentHashMap<String, BeanFactory>();
    private BeanFactory beanFactory;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<String> associatedBeanNameWithAliases = Collections.emptySet();
    private String associatedBeanName;

    public static void clear() {
        BEAN_FACTORIES.clear();
    }

    public static GemfireBeanFactoryLocator newBeanFactoryLocator() {
        GemfireBeanFactoryLocator beanFactoryLocator = new GemfireBeanFactoryLocator();
        beanFactoryLocator.afterPropertiesSet();
        return beanFactoryLocator;
    }

    public static GemfireBeanFactoryLocator newBeanFactoryLocator(BeanFactory beanFactory, String associatedBeanName) {
        Assert.isTrue((beanFactory == null || StringUtils.hasText((String)associatedBeanName) ? 1 : 0) != 0, (String)"associatedBeanName must be specified when BeanFactory is not null");
        GemfireBeanFactoryLocator beanFactoryLocator = new GemfireBeanFactoryLocator();
        beanFactoryLocator.setBeanFactory(beanFactory);
        beanFactoryLocator.setBeanName(associatedBeanName);
        beanFactoryLocator.afterPropertiesSet();
        return beanFactoryLocator;
    }

    protected static BeanFactory resolveBeanFactory(String beanFactoryKey) {
        BeanFactory beanFactory = (BeanFactory)BEAN_FACTORIES.get(beanFactoryKey);
        Assert.isTrue((BEAN_FACTORIES.isEmpty() || beanFactory != null ? 1 : 0) != 0, (String)String.format("BeanFactory for key [%s] was not found", beanFactoryKey));
        return beanFactory;
    }

    protected static synchronized BeanFactory resolveSingleBeanFactory() {
        if (!BEAN_FACTORIES.isEmpty()) {
            BeanFactory beanFactory;
            boolean allTheSameBeanFactory = true;
            BeanFactory currentBeanFactory = null;
            Iterator iterator = BEAN_FACTORIES.values().iterator();
            while (iterator.hasNext() && (allTheSameBeanFactory &= SpringUtils.nullOrEquals(currentBeanFactory = (beanFactory = (BeanFactory)iterator.next()), beanFactory))) {
            }
            Assert.state((boolean)allTheSameBeanFactory, (String)String.format("BeanFactory key must be specified when more than one BeanFactory %s is registered", new TreeSet(BEAN_FACTORIES.keySet()).toString()));
            return (BeanFactory)BEAN_FACTORIES.values().iterator().next();
        }
        return null;
    }

    protected static synchronized void registerAliases(Set<String> names, BeanFactory beanFactory) {
        Set<String> safeNames = CollectionUtils.nullSafeSet(names);
        Assert.isTrue((safeNames.isEmpty() || beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must not be null when aliases are specified");
        for (String name : safeNames) {
            BeanFactory existingBeanFactory = BEAN_FACTORIES.putIfAbsent(name, beanFactory);
            Assert.isTrue((boolean)SpringUtils.nullOrEquals(existingBeanFactory, beanFactory), (String)String.format("BeanFactory reference already exists for key [%s]", name));
        }
    }

    protected static synchronized boolean unregisterAliases(Set<String> names) {
        return BEAN_FACTORIES.keySet().removeAll(names);
    }

    public void afterPropertiesSet() {
        BeanFactory beanFactory = this.getBeanFactory();
        GemfireBeanFactoryLocator.registerAliases(this.resolveAndInitializeBeanNamesWithAliases(beanFactory), beanFactory);
    }

    Set<String> resolveAndInitializeBeanNamesWithAliases(BeanFactory beanFactory) {
        String associatedBeanName = this.getAssociatedBeanName();
        if (beanFactory != null && StringUtils.hasText((String)associatedBeanName)) {
            String[] beanAliases = beanFactory.getAliases(associatedBeanName);
            this.associatedBeanNameWithAliases = new TreeSet<String>();
            this.associatedBeanNameWithAliases.add(associatedBeanName);
            Collections.addAll(this.associatedBeanNameWithAliases, beanAliases);
        }
        return this.associatedBeanNameWithAliases;
    }

    public void destroy() {
        GemfireBeanFactoryLocator.unregisterAliases(this.getAssociatedBeanNameWithAliases());
    }

    public BeanFactory useBeanFactory() {
        return this.useBeanFactory(this.getAssociatedBeanName());
    }

    public BeanFactory useBeanFactory(String beanFactoryKey) {
        return BeanFactoryReference.newBeanFactoryReference(StringUtils.hasText((String)beanFactoryKey) ? GemfireBeanFactoryLocator.resolveBeanFactory(beanFactoryKey) : GemfireBeanFactoryLocator.resolveSingleBeanFactory()).get();
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanName(String name) {
        this.associatedBeanName = name;
    }

    protected String getAssociatedBeanName() {
        return this.associatedBeanName;
    }

    protected Set<String> getAssociatedBeanNameWithAliases() {
        return Collections.unmodifiableSet(CollectionUtils.nullSafeSet(this.associatedBeanNameWithAliases));
    }

    public GemfireBeanFactoryLocator withBeanName(String beanName) {
        this.setBeanName(beanName);
        return this;
    }

    protected static class BeanFactoryReference {
        protected static final String UNINITIALIZED_BEAN_FACTORY_REFERENCE_MESSAGE = "A BeanFactory was not initialized; Please verify the useBeanFactoryLocator property was properly set";
        private final AtomicReference<BeanFactory> beanFactory = new AtomicReference<Object>(null);

        protected static BeanFactoryReference newBeanFactoryReference(BeanFactory beanFactory) {
            return new BeanFactoryReference(beanFactory);
        }

        protected BeanFactoryReference(BeanFactory beanFactory) {
            this.beanFactory.set(beanFactory);
        }

        public BeanFactory get() {
            BeanFactory beanFactory = this.beanFactory.get();
            Assert.state((beanFactory != null ? 1 : 0) != 0, (String)UNINITIALIZED_BEAN_FACTORY_REFERENCE_MESSAGE);
            return beanFactory;
        }

        public void release() {
            this.beanFactory.set(null);
        }
    }
}

