/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.Sort;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.repository.query.GemfireQueryCreator;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.GemfireRepositoryQuery;
import org.springframework.data.gemfire.repository.query.QueryString;
import org.springframework.data.gemfire.repository.query.StringBasedGemfireRepositoryQuery;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class PartTreeGemfireRepositoryQuery
extends GemfireRepositoryQuery {
    private final GemfireTemplate template;
    private final PartTree tree;

    public PartTreeGemfireRepositoryQuery(GemfireQueryMethod queryMethod, GemfireTemplate template) {
        super(queryMethod);
        Assert.notNull((Object)template, (String)"GemfireTemplate must not be null");
        this.template = template;
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @NonNull
    protected PartTree getPartTree() {
        return this.tree;
    }

    @NonNull
    protected GemfireTemplate getTemplate() {
        return this.template;
    }

    public Object execute(Object[] arguments) {
        GemfireQueryMethod queryMethod = this.getGemfireQueryMethod();
        QueryString query = this.newQueryString(queryMethod, this.getPartTree(), arguments);
        GemfireRepositoryQuery repositoryQuery = this.newRepositoryQuery(queryMethod, query, this.getTemplate());
        return repositoryQuery.execute(this.prepareStringParameters(arguments));
    }

    private QueryString newQueryString(GemfireQueryMethod queryMethod, PartTree tree, Object[] arguments) {
        ParametersParameterAccessor parameterAccessor = new ParametersParameterAccessor(queryMethod.getParameters(), arguments);
        GemfireQueryCreator queryCreator = new GemfireQueryCreator(tree, queryMethod.getPersistentEntity());
        return queryCreator.createQuery(parameterAccessor.getSort());
    }

    private GemfireRepositoryQuery newRepositoryQuery(GemfireQueryMethod queryMethod, QueryString query, GemfireTemplate template) {
        StringBasedGemfireRepositoryQuery repositoryQuery = new StringBasedGemfireRepositoryQuery(query.toString(), queryMethod, template);
        repositoryQuery.register(this.getQueryPostProcessor());
        repositoryQuery.asDerivedQuery();
        return repositoryQuery;
    }

    private Object[] prepareStringParameters(Object[] parameters) {
        Iterator partsIterator = this.getPartTree().getParts().iterator();
        ArrayList<Object> stringParameters = new ArrayList<Object>(parameters.length);
        block5: for (Object parameter : parameters) {
            if (parameter == null || parameter instanceof Sort) {
                stringParameters.add(parameter);
                continue;
            }
            switch (((Part)partsIterator.next()).getType()) {
                case CONTAINING: {
                    stringParameters.add(String.format("%%%s%%", parameter.toString()));
                    continue block5;
                }
                case STARTING_WITH: {
                    stringParameters.add(String.format("%s%%", parameter.toString()));
                    continue block5;
                }
                case ENDING_WITH: {
                    stringParameters.add(String.format("%%%s", parameter.toString()));
                    continue block5;
                }
                default: {
                    stringParameters.add(parameter);
                }
            }
        }
        return stringParameters.toArray();
    }
}

