/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionService;
import org.springframework.data.gemfire.CacheResolver;
import org.springframework.data.gemfire.support.AbstractCachingRegionResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RegionServiceRegionResolver<T extends RegionService>
extends AbstractCachingRegionResolver {
    private final RegionServiceResolver<T> resolver;

    @NonNull
    public static <S extends GemFireCache> RegionServiceRegionResolver<S> from(@NonNull CacheResolver<S> cacheResolver) {
        Assert.notNull(cacheResolver, (String)"CacheResolver must not be null");
        return new RegionServiceRegionResolver(() -> Optional.ofNullable(cacheResolver.resolve()));
    }

    @NonNull
    public static RegionServiceRegionResolver<RegionService> from(@Nullable RegionService regionService) {
        return new RegionServiceRegionResolver<RegionService>(() -> Optional.ofNullable(regionService));
    }

    public RegionServiceRegionResolver(RegionServiceResolver<T> resolver) {
        Assert.notNull(resolver, (String)"RegionServiceResolver must not be null");
        this.resolver = resolver;
    }

    protected RegionServiceResolver<T> getRegionServiceResolver() {
        return this.resolver;
    }

    @Override
    @Nullable
    protected <K, V> Region<K, V> doResolve(@Nullable String regionName) {
        return this.getRegionServiceResolver().resolve().map(regionService -> regionService.getRegion(regionName)).orElse(null);
    }

    @FunctionalInterface
    protected static interface RegionServiceResolver<T extends RegionService> {
        public Optional<T> resolve();
    }
}

