/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.gemfire.util.Filter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    protected static final String JAVA_PACKAGE_NAME = "java";
    protected static final String COM_GEMSTONE_GEMFIRE_PACKAGE_NAME = "com.gemstone.gemfire";
    protected static final String ORG_APACHE_GEODE_PACKAGE_NAME = "org.apache.geode";
    protected static final String ORG_SPRINGFRAMEWORK_PACKAGE_NAME = "org.springframework";
    private final ConversionService conversionService;
    private EntityInstantiators entityInstantiators;
    private final GemfireMappingContext mappingContext;
    private final List<PdxSerializerResolver> pdxSerializerResolvers = new CopyOnWriteArrayList<PdxSerializerResolver>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<Object, PdxSerializer> customPdxSerializers = new ConcurrentHashMap<Object, PdxSerializer>();
    private Predicate<Class<?>> excludeTypeFilters = TypeFilters.EXCLUDE_NULL_TYPES.and(TypeFilters.EXCLUDE_JAVA_TYPES).and(TypeFilters.EXCLUDE_COM_GEMSTONE_GEMFIRE_TYPES).and(TypeFilters.EXCLUDE_ORG_APACHE_GEODE_TYPES).and(TypeFilters.EXCLUDE_ORG_SPRINGFRAMEWORK_TYPES);
    private Predicate<Class<?>> includeTypeFilters = TypeFilters.EXCLUDE_ALL_TYPES;
    private SpELContext spelContext;

    public static MappingPdxSerializer newMappingPdxSerializer() {
        return MappingPdxSerializer.create(MappingPdxSerializer.newMappingContext(), MappingPdxSerializer.newConversionService());
    }

    public static MappingPdxSerializer create(@Nullable ConversionService conversionService) {
        return MappingPdxSerializer.create(MappingPdxSerializer.newMappingContext(), conversionService);
    }

    public static MappingPdxSerializer create(@Nullable GemfireMappingContext mappingContext) {
        return MappingPdxSerializer.create(mappingContext, MappingPdxSerializer.newConversionService());
    }

    public static MappingPdxSerializer create(@Nullable GemfireMappingContext mappingContext, @Nullable ConversionService conversionService) {
        return new MappingPdxSerializer(MappingPdxSerializer.resolveMappingContext(mappingContext), MappingPdxSerializer.resolveConversionService(conversionService));
    }

    private static ConversionService newConversionService() {
        return new DefaultConversionService();
    }

    private static ConversionService resolveConversionService(ConversionService conversionService) {
        return conversionService != null ? conversionService : MappingPdxSerializer.newConversionService();
    }

    private static GemfireMappingContext newMappingContext() {
        return new GemfireMappingContext();
    }

    private static GemfireMappingContext resolveMappingContext(GemfireMappingContext mappingContext) {
        return mappingContext != null ? mappingContext : MappingPdxSerializer.newMappingContext();
    }

    public MappingPdxSerializer() {
        this(MappingPdxSerializer.newMappingContext(), MappingPdxSerializer.newConversionService());
    }

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext), (String)"MappingContext must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.entityInstantiators = new EntityInstantiators();
        this.pdxSerializerResolvers.addAll(Arrays.asList(PdxSerializerResolvers.PROPERTY, PdxSerializerResolvers.PROPERTY_NAME, PdxSerializerResolvers.PROPERTY_TYPE));
        this.spelContext = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.spelContext = new SpELContext(this.spelContext, (BeanFactory)applicationContext);
    }

    @NonNull
    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomPdxSerializers(Map<?, PdxSerializer> customPdxSerializers) {
        Optional.ofNullable(customPdxSerializers).ifPresent(this.customPdxSerializers::putAll);
    }

    @NonNull
    protected Map<?, PdxSerializer> getCustomPdxSerializers() {
        return Collections.unmodifiableMap(this.customPdxSerializers);
    }

    public void setEntityInstantiators(@NonNull EntityInstantiators entityInstantiators) {
        Assert.notNull((Object)entityInstantiators, (String)"EntityInstantiators must not be null");
        this.entityInstantiators = entityInstantiators;
    }

    public void setEntityInstantiators(@NonNull Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        this.setEntityInstantiators(new EntityInstantiators(gemfireInstantiators));
    }

    protected EntityInstantiators getEntityInstantiators() {
        return this.entityInstantiators;
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    @NonNull
    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(@NonNull Object entity) {
        return this.getPersistentEntity(entity.getClass());
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(@NonNull Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }

    public void setExcludeTypeFilters(@Nullable Predicate<Class<?>> excludeTypeFilters) {
        this.excludeTypeFilters = excludeTypeFilters != null ? this.excludeTypeFilters.and(excludeTypeFilters) : this.excludeTypeFilters;
    }

    public void setIncludeTypeFilters(@Nullable Predicate<Class<?>> includeTypeFilters) {
        this.includeTypeFilters = includeTypeFilters != null ? this.includeTypeFilters.or(includeTypeFilters) : this.includeTypeFilters;
    }

    protected Predicate<Class<?>> getTypeFilters() {
        return this.excludeTypeFilters.or(TypeFilters.EXCLUDE_NULL_TYPES.and(this.includeTypeFilters));
    }

    public void register(PdxSerializerResolver pdxSerializerResolver) {
        Optional.ofNullable(pdxSerializerResolver).ifPresent(it -> this.pdxSerializerResolvers.add(0, (PdxSerializerResolver)it));
    }

    public Object fromData(Class<?> type, PdxReader reader) {
        return this.getTypeFilters().test(type) ? this.doFromData(type, reader) : null;
    }

    Object doFromData(Class<?> type, PdxReader reader) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        Object instance = this.resolveEntityInstantiator((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        entity.doWithProperties(arg_0 -> this.lambda$doFromData$1(entity, instance, type, reader, (PersistentPropertyAccessor)propertyAccessor, arg_0));
        return propertyAccessor.getBean();
    }

    boolean isWritable(GemfirePersistentEntity<?> entity, GemfirePersistentProperty persistentProperty) {
        return !entity.isConstructorArgument((PersistentProperty)persistentProperty) && persistentProperty.isWritable() && !persistentProperty.isTransient();
    }

    public boolean toData(Object value, PdxWriter writer) {
        return this.getTypeFilters().test(this.resolveType(value)) && this.doToData(value, writer);
    }

    boolean doToData(Object value, PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value);
        if (entity != null) {
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(value), this.getConversionService());
            entity.doWithProperties(arg_0 -> this.lambda$doToData$2((PersistentPropertyAccessor)propertyAccessor, entity, writer, arg_0));
            GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
            if (idProperty != null) {
                writer.markIdentityField(idProperty.getName());
            }
            return true;
        }
        return false;
    }

    boolean isReadable(GemfirePersistentProperty persistentProperty) {
        return !persistentProperty.isTransient();
    }

    @Nullable
    protected PdxSerializer resolveCustomPdxSerializer(@NonNull PersistentProperty<?> property) {
        Map<?, PdxSerializer> customPdxSerializers = this.getCustomPdxSerializers();
        return this.pdxSerializerResolvers.stream().map(it -> it.resolve(customPdxSerializers, property)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    protected EntityInstantiator resolveEntityInstantiator(PersistentEntity entity) {
        return this.getEntityInstantiators().getInstantiatorFor(entity);
    }

    @Nullable
    Class<?> resolveType(@Nullable Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    private /* synthetic */ void lambda$doToData$2(PersistentPropertyAccessor propertyAccessor, GemfirePersistentEntity entity, PdxWriter writer, GemfirePersistentProperty persistentProperty) {
        if (this.isReadable(persistentProperty)) {
            PdxSerializer customPdxSerializer = this.resolveCustomPdxSerializer((PersistentProperty<?>)persistentProperty);
            Object propertyValue = null;
            try {
                propertyValue = propertyAccessor.getProperty((PersistentProperty)persistentProperty);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customPdxSerializer != null ? String.format(" using custom PdxSerializer [%s]", customPdxSerializer) : ""));
                }
                if (customPdxSerializer != null) {
                    customPdxSerializer.toData(propertyValue, writer);
                } else {
                    writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                }
            }
            catch (Exception cause) {
                throw new MappingException(String.format("While serializing entity [%1$s] property [%2$s] value [%3$s] of type [%4$s] to PDX%5$s", entity.getType().getName(), persistentProperty.getName(), propertyValue, ObjectUtils.nullSafeClassName((Object)propertyValue), customPdxSerializer != null ? String.format(" using custom PdxSerializer [%1$s].", customPdxSerializer.getClass().getName()) : ""), (Throwable)cause);
            }
        }
    }

    private /* synthetic */ void lambda$doFromData$1(GemfirePersistentEntity entity, Object instance, Class type, PdxReader reader, PersistentPropertyAccessor propertyAccessor, GemfirePersistentProperty persistentProperty) {
        if (this.isWritable(entity, persistentProperty)) {
            PdxSerializer customPdxSerializer = this.resolveCustomPdxSerializer((PersistentProperty<?>)persistentProperty);
            boolean isCustomPdxSerializerPresent = customPdxSerializer != null;
            Object value = null;
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Setting property [%1$s] for entity [%2$s] of type [%3$s] from PDX%4$s", persistentProperty.getName(), instance, type, customPdxSerializer != null ? String.format(" using custom PdxSerializer [%s]", customPdxSerializer) : ""));
                }
                Object object = value = isCustomPdxSerializerPresent ? customPdxSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("... with value [%s]", value));
                }
                propertyAccessor.setProperty((PersistentProperty)persistentProperty, value);
            }
            catch (Exception cause) {
                String MAPPING_ERROR_MESSAGE = "While setting value [%1$s] of property [%2$s] for entity of type [%3$s] from PDX%4$s";
                String CUSTOM_PDX_SERIALIZER_MESSAGE = isCustomPdxSerializerPresent ? String.format(" using custom PdxSerializer [%s]", customPdxSerializer) : "";
                throw new MappingException(String.format(MAPPING_ERROR_MESSAGE, value, persistentProperty.getName(), type, CUSTOM_PDX_SERIALIZER_MESSAGE), (Throwable)cause);
            }
        }
    }

    public static enum TypeFilters implements Filter<Class<?>>
    {
        EXCLUDE_ALL_TYPES{

            @Override
            public boolean accept(@Nullable Class<?> type) {
                return false;
            }
        }
        ,
        EXCLUDE_JAVA_TYPES{

            @Override
            public boolean accept(@Nullable Class<?> type) {
                return Optional.ofNullable(type).filter(it -> !it.getPackage().getName().startsWith(MappingPdxSerializer.JAVA_PACKAGE_NAME)).isPresent();
            }
        }
        ,
        EXCLUDE_NULL_TYPES{

            @Override
            public boolean accept(@Nullable Class<?> type) {
                return type != null;
            }
        }
        ,
        EXCLUDE_COM_GEMSTONE_GEMFIRE_TYPES{

            @Override
            public boolean accept(@Nullable Class<?> type) {
                return Optional.ofNullable(type).filter(it -> !it.getPackage().getName().startsWith(MappingPdxSerializer.COM_GEMSTONE_GEMFIRE_PACKAGE_NAME)).isPresent();
            }
        }
        ,
        EXCLUDE_ORG_APACHE_GEODE_TYPES{

            @Override
            public boolean accept(Class<?> type) {
                return Optional.ofNullable(type).filter(it -> !it.getPackage().getName().startsWith(MappingPdxSerializer.ORG_APACHE_GEODE_PACKAGE_NAME)).isPresent();
            }
        }
        ,
        EXCLUDE_ORG_SPRINGFRAMEWORK_TYPES{

            @Override
            public boolean accept(@Nullable Class<?> type) {
                return Optional.ofNullable(type).filter(it -> !it.getPackage().getName().startsWith(MappingPdxSerializer.ORG_SPRINGFRAMEWORK_PACKAGE_NAME)).isPresent();
            }
        };

    }

    public static enum PdxSerializerResolvers implements PdxSerializerResolver
    {
        PROPERTY{

            @Override
            public PdxSerializer resolve(Map<?, PdxSerializer> customPdxSerializers, PersistentProperty<?> property) {
                return customPdxSerializers.get(property);
            }
        }
        ,
        PROPERTY_NAME{

            @Override
            public PdxSerializer resolve(Map<?, PdxSerializer> customPdxSerializers, PersistentProperty<?> property) {
                return customPdxSerializers.get(2.toFullyQualifiedPropertyName(property));
            }
        }
        ,
        PROPERTY_TYPE{

            @Override
            public PdxSerializer resolve(Map<?, PdxSerializer> customPdxSerializers, PersistentProperty<?> property) {
                return customPdxSerializers.get(property.getType());
            }
        };


        @NonNull
        static String toFullyQualifiedPropertyName(@NonNull PersistentProperty<?> property) {
            return property.getOwner().getType().getName().concat(".").concat(property.getName());
        }
    }

    @FunctionalInterface
    public static interface PdxSerializerResolver {
        @Nullable
        public PdxSerializer resolve(@NonNull Map<?, PdxSerializer> var1, @NonNull PersistentProperty<?> var2);
    }
}

