/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.serialization.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.internal.ResultsBag;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.util.CollectionUtils;

@Aspect
public class JSONRegionAdvice {
    private boolean convertReturnedCollections = true;
    private boolean prettyPrint = false;
    private List<String> includedRegions = new ArrayList<String>();
    protected final Logger logger = LoggerFactory.getLogger(JSONRegionAdvice.class);

    public void setConvertReturnedCollections(boolean convertReturnedCollections) {
        this.convertReturnedCollections = convertReturnedCollections;
    }

    public void setIncludedRegions(List<Region<?, ?>> regions) {
        org.springframework.data.gemfire.util.CollectionUtils.nullSafeList(regions).forEach(region -> this.includedRegions.add(RegionUtils.toRegionName(region)));
    }

    public void setIncludedRegionNames(List<String> regionNames) {
        this.includedRegions = org.springframework.data.gemfire.util.CollectionUtils.nullSafeList(regionNames);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.get(..)) || execution(* org.apache.geode.cache.Region.remove(..)) || execution(* org.apache.geode.cache.Region.selectValue(..))")
    public Object get(ProceedingJoinPoint pjp) {
        Object returnValue = null;
        try {
            if (this.isIncludedJsonRegion(pjp.getTarget())) {
                returnValue = pjp.proceed();
                this.logger.debug("converting {} to JSON string", returnValue);
                returnValue = this.convertToJson(returnValue);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable cause) {
            this.handleThrowable(cause);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.getAll(..))")
    public Map<Object, Object> getAll(ProceedingJoinPoint pjp) {
        Map<Object, Object> result = null;
        try {
            Map<Object, Object> returnValue = (Map<Object, Object>)pjp.proceed();
            result = !this.convertReturnedCollections || CollectionUtils.isEmpty((Map)returnValue) || !this.isIncludedJsonRegion(pjp.getTarget()) ? returnValue : returnValue.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.convertToJson(entry.getValue())));
        }
        catch (Throwable t) {
            this.handleThrowable(t);
        }
        return result;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.create(..)) || execution(* org.apache.geode.cache.Region.put(..)) || execution(* org.apache.geode.cache.Region.putIfAbsent(..)) || execution(* org.apache.geode.cache.Region.replace(..))")
    public Object put(ProceedingJoinPoint pjp) {
        Object returnValue = null;
        try {
            if (this.isIncludedJsonRegion(pjp.getTarget())) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Object val = newArgs[1];
                newArgs[1] = this.convertToPdx(val);
                returnValue = pjp.proceed(newArgs);
                this.logger.debug("Converting [{}] to JSON", returnValue);
                returnValue = this.convertToJson(returnValue);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable cause) {
            this.handleThrowable(cause);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.putAll(..))")
    public Object putAll(ProceedingJoinPoint pjp) {
        Object returnValue = null;
        try {
            if (this.isIncludedJsonRegion(pjp.getTarget())) {
                Object[] newArgs = Arrays.copyOf(pjp.getArgs(), pjp.getArgs().length);
                Map map = (Map)newArgs[0];
                HashMap newArg = new HashMap();
                for (Map.Entry entry : map.entrySet()) {
                    newArg.put(entry.getKey(), this.convertToPdx(entry.getValue()));
                }
                newArgs[0] = newArg;
                returnValue = pjp.proceed(newArgs);
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable cause) {
            this.handleThrowable(cause);
        }
        return returnValue;
    }

    @Around(value="execution(* org.apache.geode.cache.Region.values(..))")
    public Collection<Object> values(ProceedingJoinPoint pjp) {
        Collection result = null;
        try {
            Collection returnValue = (Collection)pjp.proceed();
            result = !this.convertReturnedCollections || CollectionUtils.isEmpty((Collection)returnValue) || !this.isIncludedJsonRegion(pjp.getTarget()) ? returnValue : (Collection)returnValue.stream().map(this::convertToPdx).collect(Collectors.toList());
        }
        catch (Throwable cause) {
            this.handleThrowable(cause);
        }
        return result;
    }

    @Around(value="execution(* org.springframework.data.gemfire.GemfireOperations.find(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.findUnique(..)) || execution(* org.springframework.data.gemfire.GemfireOperations.query(..))")
    public Object templateQuery(ProceedingJoinPoint pjp) {
        GemfireTemplate template = (GemfireTemplate)pjp.getTarget();
        boolean jsonRegion = this.isIncludedJsonRegion(template.getRegion());
        Object returnValue = null;
        try {
            if (jsonRegion) {
                returnValue = pjp.proceed();
                if (returnValue instanceof SelectResults && this.convertReturnedCollections) {
                    ResultsBag resultsBag = new ResultsBag();
                    for (Object obj : (SelectResults)returnValue) {
                        resultsBag.add(this.convertToJson(obj));
                    }
                    returnValue = resultsBag;
                } else {
                    returnValue = this.convertToJson(returnValue);
                }
            } else {
                returnValue = pjp.proceed();
            }
        }
        catch (Throwable cause) {
            this.handleThrowable(cause);
        }
        return returnValue;
    }

    private boolean isIncludedJsonRegion(Object target) {
        return target instanceof Region && this.isIncludedJsonRegion((Region)target);
    }

    private boolean isIncludedJsonRegion(Region region) {
        boolean result = false;
        if (this.isIncludedJsonRegion(RegionUtils.toRegionName(region), RegionUtils.toRegionPath(region))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Region [{}] is included for JSON conversion", (Object)region.getName());
            }
            result = true;
        }
        return result;
    }

    private boolean isIncludedJsonRegion(String ... regionReferences) {
        List<String> regionReferencesList = Arrays.asList(ArrayUtils.nullSafeArray(regionReferences, String.class));
        return CollectionUtils.isEmpty(this.includedRegions) || this.includedRegions.stream().anyMatch(includeRegion -> regionReferencesList.contains(includeRegion));
    }

    private Object convertToJson(Object returnValue) {
        Object result = returnValue;
        if (returnValue instanceof PdxInstance) {
            result = JSONFormatter.toJSON((PdxInstance)((PdxInstance)returnValue));
            if (!this.prettyPrint) {
                result = this.flattenString(result);
            }
        }
        return result;
    }

    private PdxInstance convertToPdx(Object value) {
        PdxInstance pdx = null;
        if (value instanceof PdxInstance) {
            pdx = (PdxInstance)value;
        } else if (value instanceof String) {
            pdx = JSONFormatter.fromJSON((String)((String)value));
        } else {
            ObjectMapper mapper = new ObjectMapper();
            try {
                String json = mapper.writeValueAsString(value);
                pdx = JSONFormatter.fromJSON((String)json);
            }
            catch (Throwable cause) {
                this.handleThrowable(cause);
            }
        }
        return pdx;
    }

    private Object flattenString(Object result) {
        return result instanceof String ? ((String)result).replaceAll("\\s*", "") : result;
    }

    private void handleThrowable(Throwable cause) {
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new RuntimeException(cause);
    }
}

