/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.management.internal.cli.domain.RegionInformation;
import org.apache.geode.management.internal.cli.functions.GetRegionsFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.client.function.ListRegionsOnServerFunction;
import org.springframework.data.gemfire.function.execution.GemfireOnServersFunctionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class GemfireDataSourcePostProcessor
implements BeanFactoryPostProcessor {
    private static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    private final ClientCache clientCache;
    private ClientRegionShortcut clientRegionShortcut = DEFAULT_CLIENT_REGION_SHORTCUT;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public GemfireDataSourcePostProcessor(ClientCache clientCache) {
        Assert.notNull((Object)clientCache, (String)"ClientCache must not be null");
        this.clientCache = clientCache;
    }

    protected ClientCache getClientCache() {
        return this.clientCache;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    public Optional<ClientRegionShortcut> getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.createClientProxyRegions(beanFactory, this.regionNames());
    }

    Iterable<String> regionNames() {
        try {
            return (Iterable)this.execute(new ListRegionsOnServerFunction(), new Object[0]);
        }
        catch (Exception ignore) {
            try {
                Object results = this.execute((Function)new GetRegionsFunction(), new Object[0]);
                List<String> regionNames = Collections.emptyList();
                if (this.containsRegionInformation(results)) {
                    Object[] resultsArray = (Object[])results;
                    regionNames = new ArrayList<String>(resultsArray.length);
                    for (Object result : resultsArray) {
                        regionNames.add(((RegionInformation)result).getName());
                    }
                }
                return regionNames;
            }
            catch (Exception cause) {
                this.logDebug("Failed to determine the Regions available on the Server: %n%1$s", cause);
                return Collections.emptyList();
            }
        }
    }

    <T> T execute(Function gemfireFunction, Object ... arguments) {
        return (T)new GemfireOnServersFunctionTemplate((RegionService)this.getClientCache()).executeAndExtract(gemfireFunction, arguments);
    }

    boolean containsRegionInformation(Object results) {
        return results instanceof Object[] && ((Object[])results).length > 0 && ((Object[])results)[0] instanceof RegionInformation;
    }

    void createClientProxyRegions(ConfigurableListableBeanFactory beanFactory, Iterable<String> regionNames) {
        if (regionNames.iterator().hasNext()) {
            ClientRegionShortcut resolvedClientRegionShortcut = this.getClientRegionShortcut().orElse(DEFAULT_CLIENT_REGION_SHORTCUT);
            ClientRegionFactory clientRegionFactory = this.clientCache.createClientRegionFactory(resolvedClientRegionShortcut);
            for (String regionName : regionNames) {
                if (beanFactory.containsBean(regionName)) {
                    Object bean = beanFactory.getBean(regionName);
                    this.logWarn("Cannot create a client {} Region bean named {}; A bean with name {} having type {} already exists", resolvedClientRegionShortcut.name(), regionName, regionName, ObjectUtils.nullSafeClassName((Object)bean));
                    continue;
                }
                this.logInfo("Creating Region bean with name {}...", regionName);
                beanFactory.registerSingleton(regionName, (Object)clientRegionFactory.create(regionName));
            }
        }
    }

    void logDebug(String message, Object ... arguments) {
        Logger logger = this.getLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(message, arguments));
        }
    }

    void logInfo(String message, Object ... arguments) {
        Logger logger = this.getLogger();
        if (logger.isInfoEnabled()) {
            logger.info(message, arguments);
        }
    }

    void logWarn(String message, Object ... arguments) {
        Logger logger = this.getLogger();
        if (logger.isWarnEnabled()) {
            logger.warn(message, arguments);
        }
    }

    public GemfireDataSourcePostProcessor using(ClientRegionShortcut clientRegionShortcut) {
        this.setClientRegionShortcut(clientRegionShortcut);
        return this;
    }
}

