/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableSecurity;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class GeodeIntegratedSecurityConfiguration
extends EmbeddedServiceConfigurationSupport {
    protected static final String SECURITY_CLIENT_AUTH_INIT = "security-client-auth-init";
    protected static final String SECURITY_MANAGER = "security-manager";
    protected static final String SECURITY_PEER_AUTH_INIT = "security-peer-auth-init";
    protected static final String SECURITY_POST_PROCESSOR = "security-post-processor";
    protected static final String SECURITY_SHIRO_INIT = "security-shiro-init";

    @Override
    protected Class<? extends Annotation> getAnnotationType() {
        return EnableSecurity.class;
    }

    protected boolean isShiroSecurityConfigured() {
        try {
            return false;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    protected boolean isShiroSecurityNotConfigured() {
        return !this.isShiroSecurityConfigured();
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty(SECURITY_CLIENT_AUTH_INIT, this.resolveProperty(this.securityProperty("client.authentication-initializer"), (String)annotationAttributes.get("clientAuthenticationInitializer")));
        if (this.isShiroSecurityNotConfigured()) {
            gemfireProperties.setPropertyIfNotDefault(SECURITY_MANAGER, annotationAttributes.get("securityManagerClass"), Void.class);
            gemfireProperties.setProperty(SECURITY_MANAGER, this.resolveProperty(this.securityProperty("manager.class-name"), (String)annotationAttributes.get("securityManagerClassName")));
            gemfireProperties.setProperty(SECURITY_SHIRO_INIT, this.resolveProperty(this.securityProperty("shiro.ini-resource-path"), (String)annotationAttributes.get("shiroIniResourcePath")));
        }
        gemfireProperties.setProperty(SECURITY_PEER_AUTH_INIT, this.resolveProperty(this.securityProperty("peer.authentication-initializer"), (String)annotationAttributes.get("peerAuthenticationInitializer")));
        gemfireProperties.setPropertyIfNotDefault(SECURITY_POST_PROCESSOR, annotationAttributes.get("securityPostProcessorClass"), Void.class);
        gemfireProperties.setProperty(SECURITY_POST_PROCESSOR, this.resolveProperty(this.securityProperty("postprocessor.class-name"), (String)annotationAttributes.get("securityPostProcessorClassName")));
        return gemfireProperties.build();
    }
}

