/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.admin.remote;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.management.internal.cli.domain.RegionInformation;
import org.apache.geode.management.internal.cli.functions.GetRegionsFunction;
import org.springframework.data.gemfire.client.function.ListRegionsOnServerFunction;
import org.springframework.data.gemfire.config.admin.AbstractGemfireAdminOperations;
import org.springframework.data.gemfire.config.schema.definitions.IndexDefinition;
import org.springframework.data.gemfire.config.schema.definitions.RegionDefinition;
import org.springframework.data.gemfire.function.execution.GemfireFunctionOperations;
import org.springframework.data.gemfire.function.execution.GemfireOnServersFunctionTemplate;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

public class FunctionGemfireAdminTemplate
extends AbstractGemfireAdminOperations {
    private final ClientCache clientCache;

    public FunctionGemfireAdminTemplate(ClientCache clientCache) {
        Assert.notNull((Object)clientCache, (String)"ClientCache is required");
        this.clientCache = clientCache;
    }

    protected ClientCache getClientCache() {
        return this.clientCache;
    }

    @Override
    public Iterable<String> getAvailableServerRegions() {
        try {
            return (Iterable)this.execute(new ListRegionsOnServerFunction(), new Object[0]);
        }
        catch (Exception cause) {
            try {
                return Optional.ofNullable(this.execute((Function)new GetRegionsFunction(), new Object[0])).filter(this::containsRegionInformation).map(regionInformationArray -> Arrays.stream(ArrayUtils.nullSafeArray((Object[])regionInformationArray, Object.class)).map(regionInformation -> ((RegionInformation)regionInformation).getName()).collect(Collectors.toSet())).orElse(Collections.emptySet());
            }
            catch (Exception ignore) {
                return Collections.emptySet();
            }
        }
    }

    @Override
    public Iterable<String> getAvailableServerRegionIndexes() {
        return (Iterable)this.execute("ListQqlIndexesFunction", new Object[0]);
    }

    @Override
    public void createRegion(RegionDefinition regionDefinition) {
        this.execute("CreateRegionFunction", regionDefinition);
    }

    @Override
    public void createIndex(IndexDefinition indexDefinition) {
        this.execute("CreateOqlIndexFunction", indexDefinition);
    }

    <T> T execute(Function gemfireFunction, Object ... arguments) {
        return this.newGemfireFunctionOperations().executeAndExtract(gemfireFunction, arguments);
    }

    <T> T execute(String gemfireFunctionId, Object ... arguments) {
        return this.newGemfireFunctionOperations().executeAndExtract(gemfireFunctionId, arguments);
    }

    protected GemfireFunctionOperations newGemfireFunctionOperations() {
        return this.newGemfireFunctionOperations(this.getClientCache());
    }

    protected GemfireFunctionOperations newGemfireFunctionOperations(ClientCache clientCache) {
        return new GemfireOnServersFunctionTemplate((RegionService)clientCache);
    }

    boolean containsRegionInformation(Object results) {
        return Optional.ofNullable(results).filter(it -> it instanceof Object[]).filter(it -> ((Object[])it).length > 0).filter(it -> ((Object[])it)[0] instanceof RegionInformation).isPresent();
    }
}

