/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Properties;
import org.apache.shiro.util.StringUtils;
import org.springframework.data.gemfire.config.annotation.support.AbstractAuthInitialize;

public class AutoConfiguredAuthenticationInitializer
extends AbstractAuthInitialize {
    public static final String SDG_SECURITY_USERNAME_PROPERTY = "spring.data.gemfire.security.username";
    public static final String SDG_SECURITY_PASSWORD_PROPERTY = "spring.data.gemfire.security.password";
    public static final String SECURITY_USERNAME_PROPERTY = "security-username";
    public static final String SECURITY_PASSWORD_PROPERTY = "security-password";
    protected static final Properties NO_PARAMETERS = new Properties();

    public static AutoConfiguredAuthenticationInitializer newAuthenticationInitializer() {
        AutoConfiguredAuthenticationInitializer authenticationInitializer = new AutoConfiguredAuthenticationInitializer();
        authenticationInitializer.init(NO_PARAMETERS);
        return authenticationInitializer;
    }

    @Override
    protected Properties doGetCredentials(Properties properties) {
        this.getEnvironment().filter(environment -> StringUtils.hasText((String)environment.getProperty(SDG_SECURITY_USERNAME_PROPERTY))).ifPresent(environment -> {
            String securityUsername = environment.getProperty(SDG_SECURITY_USERNAME_PROPERTY);
            String securityPassword = environment.getProperty(SDG_SECURITY_PASSWORD_PROPERTY);
            properties.setProperty(SECURITY_USERNAME_PROPERTY, securityUsername);
            properties.setProperty(SECURITY_PASSWORD_PROPERTY, securityPassword);
        });
        return properties;
    }
}

