/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.DiskStoreFactory;
import org.apache.geode.cache.GemFireCache;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.config.annotation.DiskStoreConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DiskStoreFactoryBean
extends AbstractFactoryBeanSupport<DiskStore>
implements InitializingBean {
    private Boolean allowForceCompaction;
    private Boolean autoCompact;
    private DiskStore diskStore;
    private GemFireCache cache;
    private Integer compactionThreshold;
    private Integer queueSize;
    private Integer writeBufferSize;
    private Float diskUsageCriticalPercentage;
    private Float diskUsageWarningPercentage;
    private Long maxOplogSize;
    private Long timeInterval;
    private List<DiskStoreConfigurer> diskStoreConfigurers = Collections.emptyList();
    private DiskStoreConfigurer compositeDiskStoreConfigurer = (beanName, bean) -> CollectionUtils.nullSafeCollection(this.diskStoreConfigurers).forEach(diskStoreConfigurer -> diskStoreConfigurer.configure(beanName, bean));
    private List<DiskDir> diskDirs;

    public void afterPropertiesSet() throws Exception {
        String diskStoreName = this.resolveDiskStoreName();
        this.applyDiskStoreConfigurers(diskStoreName);
        GemFireCache cache = this.resolveCache(diskStoreName);
        DiskStoreFactory diskStoreFactory = this.postProcess(this.configure(this.createDiskStoreFactory(cache)));
        this.diskStore = this.postProcess(this.newDiskStore(diskStoreFactory, diskStoreName));
    }

    private void applyDiskStoreConfigurers(String diskStoreName) {
        this.applyDiskStoreConfigurers(diskStoreName, this.getCompositeDiskStoreConfigurer());
    }

    protected void applyDiskStoreConfigurers(String diskStoreName, DiskStoreConfigurer ... diskStoreConfigurers) {
        this.applyDiskStoreConfigurers(diskStoreName, Arrays.asList(ArrayUtils.nullSafeArray(diskStoreConfigurers, DiskStoreConfigurer.class)));
    }

    protected void applyDiskStoreConfigurers(String diskStoreName, Iterable<DiskStoreConfigurer> diskStoreConfigurers) {
        StreamSupport.stream(CollectionUtils.nullSafeIterable(diskStoreConfigurers).spliterator(), false).forEach(diskStoreConfigurer -> diskStoreConfigurer.configure(diskStoreName, this));
    }

    private GemFireCache resolveCache(String diskStoreName) {
        return Optional.ofNullable(this.cache).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Cache is required to create DiskStore [%s]", diskStoreName));
    }

    final String resolveDiskStoreName() {
        return Optional.ofNullable(this.getBeanName()).filter(StringUtils::hasText).orElse("DEFAULT");
    }

    protected DiskStoreFactory createDiskStoreFactory(GemFireCache cache) {
        return cache.createDiskStoreFactory();
    }

    protected DiskStoreFactory configure(DiskStoreFactory diskStoreFactory) {
        Optional.ofNullable(this.allowForceCompaction).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setAllowForceCompaction(arg_0));
        Optional.ofNullable(this.autoCompact).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setAutoCompact(arg_0));
        Optional.ofNullable(this.compactionThreshold).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setCompactionThreshold(arg_0));
        Optional.ofNullable(this.diskUsageCriticalPercentage).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setDiskUsageCriticalPercentage(arg_0));
        Optional.ofNullable(this.diskUsageWarningPercentage).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setDiskUsageWarningPercentage(arg_0));
        Optional.ofNullable(this.maxOplogSize).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setMaxOplogSize(arg_0));
        Optional.ofNullable(this.queueSize).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setQueueSize(arg_0));
        Optional.ofNullable(this.timeInterval).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setTimeInterval(arg_0));
        Optional.ofNullable(this.writeBufferSize).ifPresent(arg_0 -> ((DiskStoreFactory)diskStoreFactory).setWriteBufferSize(arg_0));
        Optional.ofNullable(this.diskDirs).filter(diskDirs -> !org.springframework.util.CollectionUtils.isEmpty((Collection)diskDirs)).ifPresent(diskDirs -> {
            File[] diskDirFiles = new File[diskDirs.size()];
            int[] diskDirSizes = new int[diskDirs.size()];
            for (int index = 0; index < diskDirs.size(); ++index) {
                DiskDir diskDir = (DiskDir)diskDirs.get(index);
                diskDirFiles[index] = new File(diskDir.location);
                diskDirSizes[index] = Optional.ofNullable(diskDir.maxSize).orElse(Integer.MAX_VALUE);
            }
            diskStoreFactory.setDiskDirsAndSizes(diskDirFiles, diskDirSizes);
        });
        return diskStoreFactory;
    }

    protected DiskStore newDiskStore(DiskStoreFactory diskStoreFactory, String diskStoreName) {
        return diskStoreFactory.create(diskStoreName);
    }

    protected DiskStoreFactory postProcess(DiskStoreFactory diskStoreFactory) {
        return diskStoreFactory;
    }

    protected DiskStore postProcess(DiskStore diskStore) {
        return diskStore;
    }

    protected DiskStoreConfigurer getCompositeDiskStoreConfigurer() {
        return this.compositeDiskStoreConfigurer;
    }

    public DiskStore getObject() throws Exception {
        return this.diskStore;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.diskStore).map(Object::getClass).orElse(DiskStore.class);
    }

    public void setCache(GemFireCache cache) {
        this.cache = cache;
    }

    public void setAllowForceCompaction(Boolean allowForceCompaction) {
        this.allowForceCompaction = allowForceCompaction;
    }

    public void setAutoCompact(Boolean autoCompact) {
        this.autoCompact = autoCompact;
    }

    public void setCompactionThreshold(Integer compactionThreshold) {
        this.validateCompactionThreshold(compactionThreshold);
        this.compactionThreshold = compactionThreshold;
    }

    protected void validateCompactionThreshold(Integer compactionThreshold) {
        Assert.isTrue((compactionThreshold == null || compactionThreshold >= 0 && compactionThreshold <= 100 ? 1 : 0) != 0, (String)String.format("The DiskStore's (%1$s) compaction threshold (%2$d) must be an integer value between 0 and 100 inclusive.", this.resolveDiskStoreName(), compactionThreshold));
    }

    public void setDiskDirs(List<DiskDir> diskDirs) {
        this.diskDirs = diskDirs;
    }

    public void setDiskStoreConfigurers(DiskStoreConfigurer ... diskStoreConfigurers) {
        this.setDiskStoreConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(diskStoreConfigurers, DiskStoreConfigurer.class)));
    }

    public void setDiskStoreConfigurers(List<DiskStoreConfigurer> diskStoreConfigurers) {
        this.diskStoreConfigurers = Optional.ofNullable(diskStoreConfigurers).orElseGet(Collections::emptyList);
    }

    public void setDiskUsageCriticalPercentage(Float diskUsageCriticalPercentage) {
        this.diskUsageCriticalPercentage = diskUsageCriticalPercentage;
    }

    public void setDiskUsageWarningPercentage(Float diskUsageWarningPercentage) {
        this.diskUsageWarningPercentage = diskUsageWarningPercentage;
    }

    public void setMaxOplogSize(Long maxOplogSize) {
        this.maxOplogSize = maxOplogSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public void setTimeInterval(Long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public static class DiskDir {
        final Integer maxSize;
        final String location;

        public DiskDir(String location) {
            this.location = location;
            this.maxSize = null;
        }

        public DiskDir(String location, int maxSize) {
            this.location = location;
            this.maxSize = maxSize;
        }
    }
}

