/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.RegionFunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.springframework.data.gemfire.function.GemfireFunctionUtils;
import org.springframework.data.gemfire.function.PdxFunctionArgumentResolver;
import org.springframework.data.gemfire.function.annotation.Filter;
import org.springframework.data.gemfire.function.annotation.RegionData;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.Assert;

class FunctionContextInjectingArgumentResolver
extends PdxFunctionArgumentResolver {
    private static final Log logger = LogFactory.getLog(FunctionContextInjectingArgumentResolver.class);
    private final int filterParameterPosition;
    private final int functionContextParameterPosition;
    private final int regionParameterPosition;
    private final int resultSenderParameterPosition;
    private final Method method;

    public FunctionContextInjectingArgumentResolver(Method method) {
        this.method = method;
        int regionDataAnnotationParameterPosition = GemfireFunctionUtils.getAnnotationParameterPosition(method, RegionData.class, new Class[]{Map.class});
        int regionTypeParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, Region.class);
        if (regionDataAnnotationParameterPosition >= 0 && regionTypeParameterPosition >= 0) {
            Assert.isTrue((regionDataAnnotationParameterPosition == regionTypeParameterPosition ? 1 : 0) != 0, (String)String.format("Function method signature for method %s cannot contain an @RegionData parameter and a different Region type parameter", method.getName()));
        }
        this.regionParameterPosition = regionDataAnnotationParameterPosition >= 0 ? regionDataAnnotationParameterPosition : (regionTypeParameterPosition >= 0 ? regionTypeParameterPosition : -1);
        this.filterParameterPosition = GemfireFunctionUtils.getAnnotationParameterPosition(method, Filter.class, new Class[]{Set.class});
        if (this.regionParameterPosition >= 0 && this.filterParameterPosition >= 0) {
            Assert.state((this.regionParameterPosition != this.filterParameterPosition ? 1 : 0) != 0, (String)"region parameter and filter parameter must be different");
        }
        this.functionContextParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, FunctionContext.class);
        this.resultSenderParameterPosition = FunctionContextInjectingArgumentResolver.getArgumentTypePosition(method, ResultSender.class);
    }

    @Override
    public Method getFunctionAnnotatedMethod() {
        return this.method;
    }

    @Override
    public Object[] resolveFunctionArguments(FunctionContext functionContext) {
        Object[] args = super.resolveFunctionArguments(functionContext);
        if (functionContext instanceof RegionFunctionContext) {
            if (this.regionParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.regionParameterPosition, FunctionContextInjectingArgumentResolver.getRegionForContext((RegionFunctionContext)functionContext));
            }
            if (this.filterParameterPosition >= 0) {
                args = ArrayUtils.insert(args, this.filterParameterPosition, ((RegionFunctionContext)functionContext).getFilter());
            }
        }
        if (this.functionContextParameterPosition >= 0) {
            args = ArrayUtils.insert(args, this.functionContextParameterPosition, functionContext);
        }
        if (this.resultSenderParameterPosition >= 0) {
            args = ArrayUtils.insert(args, this.resultSenderParameterPosition, functionContext.getResultSender());
        }
        Assert.isTrue((args.length == this.method.getParameterTypes().length ? 1 : 0) != 0, (String)String.format("Wrong number of arguments for method [%s]; Expected [%d], but was [%d]", this.method.getName(), this.method.getParameterTypes().length, args.length));
        return args;
    }

    private static Region<?, ?> getRegionForContext(RegionFunctionContext regionFunctionContext) {
        Region region = regionFunctionContext.getDataSet();
        if (PartitionRegionHelper.isPartitionedRegion((Region)region)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"this is a partitioned region - filtering local data for context");
            }
            region = PartitionRegionHelper.getLocalDataForContext((RegionFunctionContext)regionFunctionContext);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("region contains " + region.size() + " items"));
        }
        return region;
    }

    private static int getArgumentTypePosition(Method method, Class<?> requiredType) {
        int index = 0;
        int position = -1;
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (requiredType.equals(parameterType)) {
                Assert.state((position < 0 ? 1 : 0) != 0, (String)String.format("Method %s signature cannot contain more than one parameter of type %s.", method.getName(), requiredType.getName()));
                position = index;
            }
            ++index;
        }
        return position;
    }
}

