/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.CustomExpiry;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EvictionAttributes;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.Scope;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.compression.Compressor;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.data.gemfire.RegionLookupFactoryBean;
import org.springframework.data.gemfire.RegionShortcutWrapper;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.config.annotation.RegionConfigurer;
import org.springframework.data.gemfire.eviction.EvictingRegionFactoryBean;
import org.springframework.data.gemfire.expiration.ExpiringRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.util.StringUtils;

public class CacheTypeAwareRegionFactoryBean<K, V>
extends RegionLookupFactoryBean<K, V>
implements EvictingRegionFactoryBean,
ExpiringRegionFactoryBean<K, V> {
    private GemFireCache gemfireCache;
    private Boolean close = false;
    private Boolean offHeap = false;
    private Boolean statisticsEnabled = false;
    private Class<K> keyConstraint;
    private Class<V> valueConstraint;
    private ClientRegionShortcut clientRegionShortcut = ClientRegionShortcut.PROXY;
    private Compressor compressor;
    private CustomExpiry<K, V> customEntryIdleTimeout;
    private CustomExpiry<K, V> customEntryTimeToLive;
    private DataPolicy dataPolicy = DataPolicy.DEFAULT;
    private EvictionAttributes evictionAttributes;
    private ExpirationAttributes entryIdleTimeout;
    private ExpirationAttributes entryTimeToLive;
    private ExpirationAttributes regionIdleTimeout;
    private ExpirationAttributes regionTimeToLive;
    private List<RegionConfigurer> regionConfigurers = Collections.emptyList();
    private RegionAttributes<K, V> regionAttributes;
    private RegionShortcut serverRegionShortcut;
    private Scope scope;
    private String diskStoreName;
    private String poolName;
    private String regionName;

    @Override
    public Region<K, V> createRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        return GemfireUtils.isClient(gemfireCache) ? this.newClientRegion(gemfireCache, regionName) : this.newServerRegion(gemfireCache, regionName);
    }

    protected Region<K, V> newClientRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        ClientRegionFactoryBean<K, V> clientRegionFactory = this.newClientRegionFactoryBean();
        clientRegionFactory.setAttributes(this.getRegionAttributes());
        clientRegionFactory.setBeanFactory(this.getBeanFactory());
        clientRegionFactory.setCache(gemfireCache);
        clientRegionFactory.setClose(this.isClose());
        clientRegionFactory.setCompressor(this.getCompressor());
        clientRegionFactory.setDiskStoreName(this.getDiskStoreName());
        clientRegionFactory.setKeyConstraint(this.getKeyConstraint());
        clientRegionFactory.setLookupEnabled(this.getLookupEnabled());
        clientRegionFactory.setRegionConfigurers(this.regionConfigurers);
        clientRegionFactory.setRegionName(regionName);
        clientRegionFactory.setShortcut(this.getClientRegionShortcut());
        clientRegionFactory.setValueConstraint(this.getValueConstraint());
        this.getPoolName().ifPresent(clientRegionFactory::setPoolName);
        this.configureEviction(clientRegionFactory);
        this.configureExpiration(clientRegionFactory);
        clientRegionFactory.afterPropertiesSet();
        return clientRegionFactory.getObject();
    }

    protected <K, V> ClientRegionFactoryBean<K, V> newClientRegionFactoryBean() {
        return new ClientRegionFactoryBean();
    }

    protected Region<K, V> newServerRegion(GemFireCache gemfireCache, String regionName) throws Exception {
        RegionFactoryBean<K, V> serverRegionFactory = this.newRegionFactoryBean();
        serverRegionFactory.setAttributes(this.getRegionAttributes());
        serverRegionFactory.setBeanFactory(this.getBeanFactory());
        serverRegionFactory.setCache(gemfireCache);
        serverRegionFactory.setClose(this.isClose());
        serverRegionFactory.setCompressor(this.getCompressor());
        serverRegionFactory.setDataPolicy(this.getDataPolicy());
        serverRegionFactory.setDiskStoreName(this.getDiskStoreName());
        serverRegionFactory.setKeyConstraint(this.getKeyConstraint());
        serverRegionFactory.setLookupEnabled(this.getLookupEnabled());
        serverRegionFactory.setOffHeap(this.getOffHeap());
        serverRegionFactory.setRegionConfigurers(this.regionConfigurers);
        serverRegionFactory.setRegionName(regionName);
        serverRegionFactory.setShortcut(this.getServerRegionShortcut());
        serverRegionFactory.setValueConstraint(this.getValueConstraint());
        this.configureEviction(serverRegionFactory);
        this.configureExpiration(serverRegionFactory);
        serverRegionFactory.afterPropertiesSet();
        return serverRegionFactory.getObject();
    }

    protected RegionFactoryBean<K, V> newRegionFactoryBean() {
        RegionShortcutWrapper regionShortcutWrapper = RegionShortcutWrapper.valueOf(this.getServerRegionShortcut());
        DataPolicy resolvedDataPolicy = Optional.of(regionShortcutWrapper).map(RegionShortcutWrapper::getDataPolicy).orElseGet(this::getDataPolicy);
        if (regionShortcutWrapper.isLocal()) {
            return new LocalRegionFactoryBean();
        }
        if (resolvedDataPolicy.withPartitioning()) {
            return new PartitionedRegionFactoryBean();
        }
        if (resolvedDataPolicy.withReplication()) {
            ReplicatedRegionFactoryBean replicatedRegionFactoryBean = new ReplicatedRegionFactoryBean();
            replicatedRegionFactoryBean.setScope(this.getScope());
            return replicatedRegionFactoryBean;
        }
        return new GenericRegionFactoryBean();
    }

    protected void configureEviction(EvictingRegionFactoryBean regionFactoryBean) {
        regionFactoryBean.setEvictionAttributes(this.getEvictionAttributes());
    }

    protected void configureExpiration(ExpiringRegionFactoryBean<K, V> regionFactoryBean) {
        regionFactoryBean.setCustomEntryIdleTimeout(this.getCustomEntryIdleTimeout());
        regionFactoryBean.setCustomEntryTimeToLive(this.getCustomEntryTimeToLive());
        regionFactoryBean.setEntryIdleTimeout(this.getEntryIdleTimeout());
        regionFactoryBean.setEntryTimeToLive(this.getEntryTimeToLive());
        regionFactoryBean.setRegionIdleTimeout(this.getRegionIdleTimeout());
        regionFactoryBean.setRegionTimeToLive(this.getRegionTimeToLive());
    }

    public void setAttributes(RegionAttributes<K, V> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut).orElse(ClientRegionShortcut.PROXY);
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    protected Boolean getClose() {
        return this.close;
    }

    protected boolean isClose() {
        return Boolean.TRUE.equals(this.getClose());
    }

    public void setCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    protected Compressor getCompressor() {
        return this.compressor;
    }

    @Override
    public void setCustomEntryIdleTimeout(CustomExpiry<K, V> customEntryIdleTimeout) {
        this.customEntryIdleTimeout = customEntryIdleTimeout;
    }

    protected CustomExpiry<K, V> getCustomEntryIdleTimeout() {
        return this.customEntryIdleTimeout;
    }

    @Override
    public void setCustomEntryTimeToLive(CustomExpiry<K, V> customEntryTimeToLive) {
        this.customEntryTimeToLive = customEntryTimeToLive;
    }

    protected CustomExpiry<K, V> getCustomEntryTimeToLive() {
        return this.customEntryTimeToLive;
    }

    public void setDataPolicy(DataPolicy dataPolicy) {
        this.dataPolicy = dataPolicy;
    }

    protected DataPolicy getDataPolicy() {
        return Optional.ofNullable(this.dataPolicy).orElse(DataPolicy.DEFAULT);
    }

    public void setDiskStoreName(String diskStoreName) {
        this.diskStoreName = diskStoreName;
    }

    protected String getDiskStoreName() {
        return this.diskStoreName;
    }

    @Override
    public void setEvictionAttributes(EvictionAttributes evictionAttributes) {
        this.evictionAttributes = evictionAttributes;
    }

    protected EvictionAttributes getEvictionAttributes() {
        return this.evictionAttributes;
    }

    @Override
    public void setEntryIdleTimeout(ExpirationAttributes entryIdleTimeout) {
        this.entryIdleTimeout = entryIdleTimeout;
    }

    protected ExpirationAttributes getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    @Override
    public void setEntryTimeToLive(ExpirationAttributes entryTimeToLive) {
        this.entryTimeToLive = entryTimeToLive;
    }

    protected ExpirationAttributes getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    public void setKeyConstraint(Class<K> keyConstraint) {
        this.keyConstraint = keyConstraint;
    }

    protected Class<K> getKeyConstraint() {
        return this.keyConstraint;
    }

    public void setOffHeap(Boolean offHeap) {
        this.offHeap = offHeap;
    }

    protected Boolean getOffHeap() {
        return this.offHeap;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected Optional<String> getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText);
    }

    protected String resolvePoolName() {
        return this.getPoolName().orElse(null);
    }

    public void setRegionConfigurers(RegionConfigurer ... regionConfigurers) {
        this.setRegionConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(regionConfigurers, RegionConfigurer.class)));
    }

    public void setRegionConfigurers(List<RegionConfigurer> regionConfigurers) {
        this.regionConfigurers = Optional.ofNullable(regionConfigurers).orElseGet(Collections::emptyList);
    }

    @Override
    public void setRegionIdleTimeout(ExpirationAttributes regionIdleTimeout) {
        this.regionIdleTimeout = regionIdleTimeout;
    }

    protected ExpirationAttributes getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    @Override
    public void setRegionTimeToLive(ExpirationAttributes regionTimeToLive) {
        this.regionTimeToLive = regionTimeToLive;
    }

    protected ExpirationAttributes getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    protected Scope getScope() {
        return this.scope;
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut;
    }

    public void setValueConstraint(Class<V> valueConstraint) {
        this.valueConstraint = valueConstraint;
    }

    protected Class<V> getValueConstraint() {
        return this.valueConstraint;
    }
}

