/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene.support;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.WritablePdxInstance;
import org.springframework.data.projection.Accessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class PdxInstanceMethodInterceptor
implements MethodInterceptor {
    private PdxInstance source;

    public static PdxInstanceMethodInterceptor newPdxInstanceMethodInterceptor(Object source) {
        Assert.isInstanceOf(PdxInstance.class, (Object)source, () -> String.format("Source [%1$s] is not an instance of [%2$s]", ObjectUtils.nullSafeClassName((Object)source), PdxInstance.class.getName()));
        return PdxInstanceMethodInterceptor.newPdxInstanceMethodInterceptor((PdxInstance)source);
    }

    public static PdxInstanceMethodInterceptor newPdxInstanceMethodInterceptor(PdxInstance source) {
        return new PdxInstanceMethodInterceptor(source);
    }

    public PdxInstanceMethodInterceptor(PdxInstance source) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        this.source = source;
    }

    protected PdxInstance getSource() {
        return this.source;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return invocation.proceed();
        }
        Accessor methodAccessor = new Accessor(method);
        PdxInstance pdxInstance = this.getSource();
        String propertyName = methodAccessor.getPropertyName();
        Assert.state((boolean)pdxInstance.hasField(propertyName), () -> String.format("Source [%1$s] does not contain field with name [%2$s]", pdxInstance, propertyName));
        if (methodAccessor.isGetter()) {
            return pdxInstance.getField(propertyName);
        }
        Assert.isTrue((invocation.getArguments().length == 1 ? 1 : 0) != 0, () -> String.format("Invoked setter method [%1$s] must expect exactly 1 argument; Arguments were [%2$s]", method.getName(), Arrays.toString(invocation.getArguments())));
        Object value = invocation.getArguments()[0];
        WritablePdxInstance writablePdxInstance = pdxInstance.createWriter();
        Assert.state((writablePdxInstance != null ? 1 : 0) != 0, () -> String.format("No writer for PdxInstance [%1$s] was found for setting field [%2$s] to value [%3$s]", pdxInstance, propertyName, value));
        writablePdxInstance.setField(propertyName, value);
        this.source = writablePdxInstance;
        return null;
    }
}

