/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.Optional;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class RegionUtils
extends CacheUtils {
    public static boolean isClient(Region region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).filter(StringUtils::hasText).isPresent();
    }

    @Nullable
    public static String toRegionName(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getName).orElse(null);
    }

    @Nullable
    public static String toRegionName(String regionPath) {
        return Optional.ofNullable(regionPath).filter(StringUtils::hasText).map(StringUtils::trimWhitespace).map(it -> it.lastIndexOf("/")).filter(index -> index > -1).map(index -> regionPath.substring(index + 1)).orElse(regionPath);
    }

    @Nullable
    public static String toRegionPath(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getFullPath).orElse(null);
    }

    @NonNull
    public static String toRegionPath(String regionName) {
        return String.format("%1$s%2$s", "/", regionName);
    }
}

