/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewaySenderFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewaySenderWrapper;
import org.springframework.data.gemfire.wan.OrderPolicyConverter;
import org.springframework.util.Assert;

public class GatewaySenderFactoryBean
extends AbstractWANComponentFactoryBean<GatewaySender> {
    private boolean manualStart = false;
    private int remoteDistributedSystemId;
    private GatewaySender gatewaySender;
    private List<GatewayEventFilter> eventFilters;
    private List<GatewayTransportFilter> transportFilters;
    private Boolean diskSynchronous;
    private Boolean batchConflationEnabled;
    private Boolean parallel;
    private Boolean persistent;
    private GatewaySender.OrderPolicy orderPolicy;
    private GatewayEventSubstitutionFilter eventSubstitutionFilter;
    private Integer alertThreshold;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private Integer socketBufferSize;
    private Integer socketReadTimeout;
    private String diskStoreReference;

    public GatewaySenderFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    protected void doInit() {
        GatewaySenderFactory gatewaySenderFactory;
        GatewaySenderFactory gatewaySenderFactory2 = gatewaySenderFactory = this.factory != null ? (GatewaySenderFactory)this.factory : this.cache.createGatewaySenderFactory();
        if (this.alertThreshold != null) {
            gatewaySenderFactory.setAlertThreshold(this.alertThreshold.intValue());
        }
        if (this.batchConflationEnabled != null) {
            gatewaySenderFactory.setBatchConflationEnabled(this.batchConflationEnabled.booleanValue());
        }
        if (this.batchSize != null) {
            gatewaySenderFactory.setBatchSize(this.batchSize.intValue());
        }
        if (this.batchTimeInterval != null) {
            gatewaySenderFactory.setBatchTimeInterval(this.batchTimeInterval.intValue());
        }
        if (this.diskStoreReference != null) {
            gatewaySenderFactory.setDiskStoreName(this.diskStoreReference);
        }
        if (this.diskSynchronous != null) {
            gatewaySenderFactory.setDiskSynchronous(this.diskSynchronous.booleanValue());
        }
        if (this.dispatcherThreads != null) {
            gatewaySenderFactory.setDispatcherThreads(this.dispatcherThreads.intValue());
        }
        for (GatewayEventFilter eventFilter : CollectionUtils.nullSafeList(this.eventFilters)) {
            gatewaySenderFactory.addGatewayEventFilter(eventFilter);
        }
        if (this.eventSubstitutionFilter != null) {
            gatewaySenderFactory.setGatewayEventSubstitutionFilter(this.eventSubstitutionFilter);
        }
        gatewaySenderFactory.setManualStart(this.manualStart);
        if (this.maximumQueueMemory != null) {
            gatewaySenderFactory.setMaximumQueueMemory(this.maximumQueueMemory.intValue());
        }
        if (this.orderPolicy != null) {
            Assert.isTrue((boolean)this.isSerialGatewaySender(), (String)"Order Policy cannot be used with a Parallel Gateway Sender Queue.");
            gatewaySenderFactory.setOrderPolicy(this.orderPolicy);
        }
        gatewaySenderFactory.setParallel(this.isParallelGatewaySender());
        gatewaySenderFactory.setPersistenceEnabled(this.isPersistent());
        if (this.socketBufferSize != null) {
            gatewaySenderFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        if (this.socketReadTimeout != null) {
            gatewaySenderFactory.setSocketReadTimeout(this.socketReadTimeout.intValue());
        }
        for (GatewayTransportFilter transportFilter : CollectionUtils.nullSafeList(this.transportFilters)) {
            gatewaySenderFactory.addGatewayTransportFilter(transportFilter);
        }
        GatewaySenderWrapper wrapper = new GatewaySenderWrapper(gatewaySenderFactory.create(this.getName(), this.remoteDistributedSystemId));
        wrapper.setManualStart(this.manualStart);
        this.gatewaySender = wrapper;
    }

    @Override
    public GatewaySender getObject() throws Exception {
        return this.gatewaySender;
    }

    @Override
    public Class<?> getObjectType() {
        return this.gatewaySender != null ? this.gatewaySender.getClass() : GatewaySender.class;
    }

    public void setAlertThreshold(Integer alertThreshold) {
        this.alertThreshold = alertThreshold;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    @Deprecated
    public void setEnableBatchConflation(Boolean enableBatchConflation) {
        this.batchConflationEnabled = enableBatchConflation;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreReference = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setEventFilters(List<GatewayEventFilter> gatewayEventFilters) {
        this.eventFilters = gatewayEventFilters;
    }

    public void setEventSubstitutionFilter(GatewayEventSubstitutionFilter eventSubstitutionFilter) {
        this.eventSubstitutionFilter = eventSubstitutionFilter;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    @Deprecated
    public void setOrderPolicy(String orderPolicy) {
        this.setOrderPolicy(new OrderPolicyConverter().convert(orderPolicy));
    }

    public void setOrderPolicy(GatewaySender.OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isSerialGatewaySender() {
        return !this.isParallelGatewaySender();
    }

    public boolean isParallelGatewaySender() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isNotPersistent() {
        return !this.isPersistent();
    }

    public boolean isPersistent() {
        return Boolean.TRUE.equals(this.persistent);
    }

    public void setRemoteDistributedSystemId(int remoteDistributedSystemId) {
        this.remoteDistributedSystemId = remoteDistributedSystemId;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setSocketReadTimeout(Integer socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
    }

    public void setTransportFilters(List<GatewayTransportFilter> gatewayTransportFilters) {
        this.transportFilters = gatewayTransportFilters;
    }
}

