/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.Region;
import org.springframework.data.gemfire.repository.GemfireRepository;
import org.springframework.data.gemfire.repository.support.GemfireRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.StringUtils;

public class GemfireRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String GEMFIRE_MODULE_PREFIX = "gemfire";
    private static final String MAPPING_CONTEXT_PROPERTY_NAME = "gemfireMappingContext";
    private static final String MAPPING_CONTEXT_REF_ATTRIBUTE_NAME = "mappingContextRef";
    static final String DEFAULT_MAPPING_CONTEXT_BEAN_NAME = String.format("%1$s.%2$s", GemfireMappingContext.class.getName(), "DEFAULT");

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Region.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(GemfireRepository.class);
    }

    protected String getModulePrefix() {
        return GEMFIRE_MODULE_PREFIX;
    }

    public String getRepositoryFactoryClassName() {
        return GemfireRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource configurationSource) {
        builder.addPropertyReference(MAPPING_CONTEXT_PROPERTY_NAME, GemfireRepositoryConfigurationExtension.resolveMappingContextBeanName(configurationSource.getAttribute(MAPPING_CONTEXT_REF_ATTRIBUTE_NAME)));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource configurationSource) {
        builder.addPropertyReference(MAPPING_CONTEXT_PROPERTY_NAME, GemfireRepositoryConfigurationExtension.resolveMappingContextBeanName(configurationSource.getAttribute(MAPPING_CONTEXT_REF_ATTRIBUTE_NAME)));
    }

    private static String resolveMappingContextBeanName(String source) {
        return StringUtils.hasText((String)source) ? source : DEFAULT_MAPPING_CONTEXT_BEAN_NAME;
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        super.registerBeansForRoot(registry, configurationSource);
        if (!StringUtils.hasText((String)configurationSource.getAttribute(MAPPING_CONTEXT_REF_ATTRIBUTE_NAME))) {
            registry.registerBeanDefinition(DEFAULT_MAPPING_CONTEXT_BEAN_NAME, (BeanDefinition)new RootBeanDefinition(GemfireMappingContext.class));
        }
    }
}

