/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.pdx.PdxReader;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.PdxWriter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final ConversionService conversionService;
    private EntityInstantiators instantiators;
    private final GemfireMappingContext mappingContext;
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<Class<?>, PdxSerializer> customSerializers;
    private SpELContext context;

    public static MappingPdxSerializer create(GemfireMappingContext mappingContext, ConversionService conversionService) {
        mappingContext = mappingContext != null ? mappingContext : new GemfireMappingContext();
        conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        return new MappingPdxSerializer(mappingContext, conversionService);
    }

    public MappingPdxSerializer() {
        this(new GemfireMappingContext(), (ConversionService)new DefaultConversionService());
    }

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext));
        Assert.notNull((Object)conversionService);
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.instantiators = new EntityInstantiators();
        this.customSerializers = Collections.emptyMap();
        this.context = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new SpELContext(this.context, (BeanFactory)applicationContext);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        Assert.notNull(customSerializers);
        this.customSerializers = customSerializers;
    }

    protected Map<Class<?>, PdxSerializer> getCustomSerializers() {
        return Collections.unmodifiableMap(this.customSerializers);
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        Assert.notNull(gemfireInstantiators);
        this.instantiators = new EntityInstantiators(gemfireInstantiators);
    }

    protected EntityInstantiators getGemfireInstantiators() {
        return this.instantiators;
    }

    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public Object fromData(final Class<?> type, final PdxReader reader) {
        final GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        final Object instance = this.getInstantiatorFor((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>((PersistentPropertyAccessor)accessor){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            {
                this.val$accessor = persistentPropertyAccessor;
            }

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                if (!entity.isConstructorArgument((PersistentProperty)persistentProperty)) {
                    PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                    Object value = null;
                    try {
                        if (MappingPdxSerializer.this.log.isDebugEnabled()) {
                            MappingPdxSerializer.this.log.debug((Object)String.format("setting property [%1$s] for entity [%2$s] of type [%3$s] from PDX%4$s", persistentProperty.getName(), instance, type, customSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customSerializer) : ""));
                        }
                        Object object = value = customSerializer != null ? customSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                        if (MappingPdxSerializer.this.log.isDebugEnabled()) {
                            MappingPdxSerializer.this.log.debug((Object)String.format("with value [%1$s]", value));
                        }
                        this.val$accessor.setProperty((PersistentProperty)persistentProperty, value);
                    }
                    catch (Exception e) {
                        throw new MappingException(String.format("while setting value [%1$s] of property [%2$s] for entity of type [%3$s] from PDX%4$s", value, persistentProperty.getName(), type, customSerializer != null ? String.format(" using custom PdxSerializer [%14s]", customSerializer) : ""), (Throwable)e);
                    }
                }
            }
        });
        return accessor.getBean();
    }

    public boolean toData(Object value, PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value.getClass());
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(value), this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>((PersistentPropertyAccessor)accessor, value, writer){
            final /* synthetic */ PersistentPropertyAccessor val$accessor;
            final /* synthetic */ Object val$value;
            final /* synthetic */ PdxWriter val$writer;
            {
                this.val$accessor = persistentPropertyAccessor;
                this.val$value = object;
                this.val$writer = pdxWriter;
            }

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                Object propertyValue = null;
                try {
                    propertyValue = this.val$accessor.getProperty((PersistentProperty)persistentProperty);
                    if (MappingPdxSerializer.this.log.isDebugEnabled()) {
                        MappingPdxSerializer.this.log.debug((Object)String.format("serializing value [%1$s] of property [%2$s] for entity of type [%3$s] to PDX%4$s", propertyValue, persistentProperty.getName(), this.val$value.getClass(), customSerializer != null ? String.format(" using custom PdxSerializer [%1$s]", customSerializer) : ""));
                    }
                    if (customSerializer != null) {
                        customSerializer.toData(propertyValue, this.val$writer);
                    } else {
                        this.val$writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                    }
                }
                catch (Exception e) {
                    throw new MappingException(String.format("while serializing value [%1$s] of property [%2$s] for entity of type [%3$s] to PDX%4$s", propertyValue, persistentProperty.getName(), this.val$value.getClass(), customSerializer != null ? String.format(" using custom PdxSerializer [%1$s].", customSerializer.getClass().getName()) : "."), (Throwable)e);
                }
            }
        });
        GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            writer.markIdentityField(idProperty.getName());
        }
        return true;
    }

    protected PdxSerializer getCustomSerializer(Class<?> type) {
        return this.getCustomSerializers().get(type);
    }

    protected EntityInstantiator getInstantiatorFor(PersistentEntity entity) {
        return this.getGemfireInstantiators().getInstantiatorFor(entity);
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }
}

