/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.listener.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.query.CqEvent;
import org.apache.geode.cache.query.CqQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.data.gemfire.listener.GemfireListenerExecutionFailedException;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ContinuousQueryListenerAdapter
implements ContinuousQueryListener {
    public static final String DEFAULT_LISTENER_METHOD_NAME = "handleEvent";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private MethodInvoker invoker;
    private Object delegate;
    private String defaultListenerMethod = "handleEvent";

    public ContinuousQueryListenerAdapter() {
        this.setDelegate(this);
    }

    public ContinuousQueryListenerAdapter(Object delegate) {
        this.setDelegate(delegate);
    }

    public void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' must not be null");
        this.delegate = delegate;
        this.invoker = null;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDefaultListenerMethod(String defaultListenerMethod) {
        this.defaultListenerMethod = defaultListenerMethod;
        this.invoker = null;
    }

    protected String getDefaultListenerMethod() {
        return this.defaultListenerMethod;
    }

    @Override
    public void onEvent(CqEvent event) {
        try {
            if (this.delegate != this && this.delegate instanceof ContinuousQueryListener) {
                ((ContinuousQueryListener)this.delegate).onEvent(event);
            } else {
                String methodName = this.getListenerMethodName(event);
                if (methodName == null) {
                    throw new InvalidDataAccessApiUsageException("No default listener method specified. Either specify a non-null value for the 'defaultListenerMethod' property or override the 'getListenerMethodName' method.");
                }
                this.invoker = this.invoker != null ? this.invoker : new MethodInvoker(this.delegate, methodName);
                this.invokeListenerMethod(event, methodName);
            }
        }
        catch (Throwable cause) {
            this.handleListenerException(cause);
        }
    }

    protected String getListenerMethodName(CqEvent event) {
        return this.getDefaultListenerMethod();
    }

    protected void handleListenerException(Throwable cause) {
        this.logger.error((Object)"Listener execution failed...", cause);
    }

    protected void invokeListenerMethod(CqEvent event, String methodName) {
        try {
            this.invoker.invoke(event);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof DataAccessException) {
                throw (DataAccessException)e.getTargetException();
            }
            throw new GemfireListenerExecutionFailedException(String.format("Listener method [%1$s] threw Exception...", methodName), e.getTargetException());
        }
        catch (Throwable e) {
            throw new GemfireListenerExecutionFailedException(String.format("Failed to invoke the target listener method [%1$s]", methodName), e);
        }
    }

    private class MethodInvoker {
        private final Object delegate;
        List<Method> methods;

        MethodInvoker(Object delegate, final String methodName) {
            Class<?> c = delegate.getClass();
            this.delegate = delegate;
            this.methods = new ArrayList<Method>();
            ReflectionUtils.doWithMethods(c, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    ReflectionUtils.makeAccessible((Method)method);
                    MethodInvoker.this.methods.add(method);
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return MethodInvoker.this.isValidEventMethodSignature(method, methodName);
                }
            });
            Assert.isTrue((!this.methods.isEmpty() ? 1 : 0) != 0, (String)String.format("Cannot find a suitable method named [%1$s#%2$s] - is the method public and does it have the proper arguments?", c.getName(), methodName));
        }

        boolean isValidEventMethodSignature(Method method, String methodName) {
            if (Modifier.isPublic(method.getModifiers()) && methodName.equals(method.getName())) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                int objects = 0;
                int operations = 0;
                if (parameterTypes.length > 0) {
                    for (Class<?> parameterType : parameterTypes) {
                        if (Object.class.equals(parameterType)) {
                            if (++objects <= 2) continue;
                            return false;
                        }
                        if (Operation.class.equals(parameterType)) {
                            if (++operations <= 2) continue;
                            return false;
                        }
                        if (byte[].class.equals(parameterType) || CqEvent.class.equals(parameterType) || CqQuery.class.equals(parameterType) || Throwable.class.equals(parameterType)) continue;
                        return false;
                    }
                    return true;
                }
            }
            return false;
        }

        void invoke(CqEvent event) throws InvocationTargetException, IllegalAccessException {
            for (Method method : this.methods) {
                method.invoke(this.delegate, this.getMethodArguments(method, event));
            }
        }

        Object[] getMethodArguments(Method method, CqEvent event) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] args = new Object[parameterTypes.length];
            boolean query = false;
            boolean value = false;
            for (int index = 0; index < parameterTypes.length; ++index) {
                Class<?> parameterType = parameterTypes[index];
                if (Object.class.equals(parameterType)) {
                    args[index] = value ? event.getNewValue() : event.getKey();
                    value = true;
                    continue;
                }
                if (Operation.class.equals(parameterType)) {
                    args[index] = query ? event.getQueryOperation() : event.getBaseOperation();
                    query = true;
                    continue;
                }
                if (byte[].class.equals(parameterType)) {
                    args[index] = event.getDeltaValue();
                    continue;
                }
                if (CqEvent.class.equals(parameterType)) {
                    args[index] = event;
                    continue;
                }
                if (CqQuery.class.equals(parameterType)) {
                    args[index] = event.getCq();
                    continue;
                }
                if (!Throwable.class.equals(parameterType)) continue;
                args[index] = event.getThrowable();
            }
            return args;
        }
    }
}

