/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.RegionFactoryBean;
import org.springframework.util.Assert;

public class PartitionedRegionFactoryBean<K, V>
extends RegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy == null) {
            dataPolicy = this.isPersistent() ? DataPolicy.PERSISTENT_PARTITION : DataPolicy.PARTITION;
        } else {
            Assert.isTrue((boolean)dataPolicy.withPartitioning(), (String)String.format("Data Policy '%1$s' is not supported in Partitioned Regions.", dataPolicy));
        }
        this.assertDataPolicyAndPersistentAttributesAreCompatible(dataPolicy);
        regionFactory.setDataPolicy(dataPolicy);
        this.setDataPolicy(dataPolicy);
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy resolvedDataPolicy = null;
        if (dataPolicy != null) {
            resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
        }
        this.resolveDataPolicy(regionFactory, persistent, resolvedDataPolicy);
    }
}

