/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.support.JSONRegionAdvice;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class GemfireRegionAutoProxyParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JSONRegionAdvice.class);
        ParsingUtils.setPropertyValue(element, builder, "pretty-print");
        ParsingUtils.setPropertyValue(element, builder, "convert-returned-collections");
        String regionNames = element.getAttribute("included-regions");
        if (StringUtils.hasText((String)regionNames)) {
            String[] regions = StringUtils.commaDelimitedListToStringArray((String)regionNames);
            ManagedList regionList = new ManagedList(regions.length);
            for (String regionRef : regions) {
                regionList.add((Object)regionRef);
            }
            builder.addPropertyValue("includedRegions", (Object)regionList);
        }
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return builder.getBeanDefinition();
    }
}

