/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.gemfire.client.GemfireDataSourcePostProcessor;
import org.springframework.data.gemfire.config.xml.ClientCacheParser;
import org.springframework.data.gemfire.config.xml.PoolParser;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.w3c.dom.Element;

class GemfireDataSourceParser
extends AbstractBeanDefinitionParser {
    static final String SUBSCRIPTION_ENABLED_ATTRIBUTE_NAME = "subscription-enabled";
    static final String SUBSCRIPTION_ENABLED_PROPERTY_NAME = "subscriptionEnabled";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    GemfireDataSourceParser() {
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        this.parseAndRegisterClientCache(element, parserContext);
        this.parseAndRegisterPool(element, parserContext);
        this.registerGemFireDataSourceBeanPostProcessor(parserContext);
        return null;
    }

    private void parseAndRegisterClientCache(Element element, ParserContext parserContext) {
        BeanDefinition clientCacheDefinition = new ClientCacheParser().parse(element, parserContext);
        parserContext.getRegistry().registerBeanDefinition("gemfireCache", clientCacheDefinition);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Registered Pivotal GemFire ClientCache bean [%1$s] of type [%2$s]%n", "gemfireCache", clientCacheDefinition.getBeanClassName()));
        }
    }

    private void parseAndRegisterPool(Element element, ParserContext parserContext) {
        BeanDefinition poolDefinition = new PoolParser().parse(element, parserContext);
        MutablePropertyValues poolProperties = poolDefinition.getPropertyValues();
        if (!element.hasAttribute(SUBSCRIPTION_ENABLED_ATTRIBUTE_NAME)) {
            poolProperties.add(SUBSCRIPTION_ENABLED_PROPERTY_NAME, (Object)true);
        }
        parserContext.getRegistry().registerBeanDefinition("gemfirePool", poolDefinition);
    }

    private void registerGemFireDataSourceBeanPostProcessor(@NonNull ParserContext parserContext) {
        BeanFactory beanFactory = this.resolveBeanFactory(parserContext);
        if (beanFactory != null) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemfireDataSourcePostProcessor.class);
            builder.addPropertyValue("beanFactory", (Object)beanFactory);
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    @Nullable
    private BeanFactory resolveBeanFactory(@NonNull ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        return registry instanceof ConfigurableApplicationContext ? ((ConfigurableApplicationContext)registry).getBeanFactory() : (registry instanceof BeanFactory ? (BeanFactory)registry : null);
    }
}

