/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GatewayReceiverFactoryBean
extends AbstractWANComponentFactoryBean<GatewayReceiver> {
    private boolean manualStart = false;
    private volatile GatewayReceiver gatewayReceiver;
    private Integer endPort;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private Integer startPort;
    private List<GatewayTransportFilter> transportFilters;
    private String bindAddress;
    private String hostnameForSenders;

    public GatewayReceiverFactoryBean(Cache cache) {
        super(cache);
    }

    public GatewayReceiver getObject() throws Exception {
        return this.gatewayReceiver;
    }

    public Class<?> getObjectType() {
        return this.gatewayReceiver != null ? this.gatewayReceiver.getClass() : GatewayReceiver.class;
    }

    @Override
    protected void doInit() throws Exception {
        int localEndPort;
        int localStartPort;
        GatewayReceiverFactory gatewayReceiverFactory = this.cache.createGatewayReceiverFactory();
        if (StringUtils.hasText((String)this.bindAddress)) {
            gatewayReceiverFactory.setBindAddress(this.bindAddress);
        }
        if (StringUtils.hasText((String)this.hostnameForSenders)) {
            gatewayReceiverFactory.setHostnameForSenders(this.hostnameForSenders);
        }
        Assert.isTrue(((localStartPort = this.defaultPort(this.startPort, 5000)) <= (localEndPort = this.defaultPort(this.endPort, 5500)) ? 1 : 0) != 0, (String)String.format("'startPort' must be less than or equal to %d.", localEndPort));
        gatewayReceiverFactory.setStartPort(localStartPort);
        gatewayReceiverFactory.setEndPort(localEndPort);
        gatewayReceiverFactory.setManualStart(this.manualStart);
        if (this.maximumTimeBetweenPings != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(this.maximumTimeBetweenPings.intValue());
        }
        if (this.socketBufferSize != null) {
            gatewayReceiverFactory.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        for (GatewayTransportFilter transportFilter : CollectionUtils.nullSafeList(this.transportFilters)) {
            gatewayReceiverFactory.addGatewayTransportFilter(transportFilter);
        }
        this.gatewayReceiver = gatewayReceiverFactory.create();
    }

    protected int defaultPort(Integer port, int defaultPort) {
        return port != null ? port : defaultPort;
    }

    public void setGatewayReceiver(GatewayReceiver gatewayReceiver) {
        this.gatewayReceiver = gatewayReceiver;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setHostnameForSenders(String hostnameForSenders) {
        this.hostnameForSenders = hostnameForSenders;
    }

    public void setStartPort(Integer startPort) {
        this.startPort = startPort;
    }

    public void setEndPort(Integer endPort) {
        this.endPort = endPort;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = Boolean.TRUE.equals(manualStart);
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setTransportFilters(List<GatewayTransportFilter> transportFilters) {
        this.transportFilters = transportFilters;
    }
}

