/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;

public abstract class AbstractFactoryBeanSupport<T>
implements FactoryBean<T>,
BeanClassLoaderAware,
BeanFactoryAware,
BeanNameAware {
    protected static final boolean DEFAULT_SINGLETON = true;
    private ClassLoader beanClassLoader;
    private BeanFactory beanFactory;
    private final Log log = this.newLog();
    private String beanName;

    protected AbstractFactoryBeanSupport() {
    }

    protected Log newLog() {
        return LogFactory.getLog(this.getClass());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void logDebug(String message, Object ... args) {
        this.logDebug(() -> String.format(message, args));
    }

    protected void logDebug(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isDebugEnabled).ifPresent(log -> log.debug(message.get()));
    }

    protected void logInfo(String message, Object ... args) {
        this.logInfo(() -> String.format(message, args));
    }

    protected void logInfo(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isInfoEnabled).ifPresent(log -> log.info(message.get()));
    }

    protected void logWarning(String message, Object ... args) {
        this.logWarning(() -> String.format(message, args));
    }

    protected void logWarning(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isWarnEnabled).ifPresent(log -> log.warn(message.get()));
    }

    protected void logError(String message, Object ... args) {
        this.logError(() -> String.format(message, args));
    }

    protected void logError(Supplier<String> message) {
        Optional.ofNullable(this.getLog()).filter(Log::isErrorEnabled).ifPresent(log -> log.error(message.get()));
    }
}

