/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.Region;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class AutoRegionLookupBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)String.format("BeanFactory [%1$s] must be an instance of %2$s", ObjectUtils.nullSafeClassName((Object)beanFactory), ConfigurableListableBeanFactory.class.getSimpleName()));
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory was not properly initialized");
        return this.beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof GemFireCache) {
            this.registerCacheRegionsAsBeans((GemFireCache)bean);
        }
        return bean;
    }

    void registerCacheRegionsAsBeans(GemFireCache cache) {
        for (Region region : cache.rootRegions()) {
            this.registerCacheRegionAsBean(region);
        }
    }

    void registerCacheRegionAsBean(Region<?, ?> region) {
        if (region != null) {
            String regionBeanName = this.getBeanName(region);
            if (!this.getBeanFactory().containsBean(regionBeanName)) {
                this.getBeanFactory().registerSingleton(regionBeanName, region);
            }
            for (Region<?, ?> subregion : this.nullSafeSubregions(region)) {
                this.registerCacheRegionAsBean(subregion);
            }
        }
    }

    String getBeanName(Region region) {
        String regionFullPath = region.getFullPath();
        return regionFullPath.lastIndexOf("/") > 0 ? regionFullPath : region.getName();
    }

    Set<Region<?, ?>> nullSafeSubregions(Region<?, ?> parentRegion) {
        Set<Region<?, ?>> subregions = parentRegion.subregions(false);
        return subregions != null ? subregions : Collections.emptySet();
    }
}

