/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.gemfire.function.GemfireFunctionUtils;
import org.springframework.data.gemfire.function.annotation.GemfireFunction;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class GemfireFunctionBeanPostProcessor
implements BeanPostProcessor {
    private static final String GEMFIRE_FUNCTION_ANNOTATION_NAME = GemfireFunction.class.getName();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.registerAnyDeclaredGemfireFunctionMethods(bean);
        return bean;
    }

    private void registerAnyDeclaredGemfireFunctionMethods(Object bean) {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
            GemfireFunction annotation = (GemfireFunction)AnnotationUtils.getAnnotation((Method)method, GemfireFunction.class);
            if (annotation == null) continue;
            Assert.isTrue((boolean)Modifier.isPublic(method.getModifiers()), (String)("The method " + method.getName() + " annotated with" + GEMFIRE_FUNCTION_ANNOTATION_NAME + " must be public"));
            AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)false, (boolean)true);
            GemfireFunctionUtils.registerFunctionForPojoMethod(bean, method, (Map<String, Object>)attributes, false);
        }
    }
}

