/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.util.Map;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.util.Assert;

class FunctionExecutionConfiguration {
    private final Map<String, Object> attributes;
    private Class<?> functionExecutionInterface;
    private final String annotationType;

    FunctionExecutionConfiguration(ScannedGenericBeanDefinition beanDefinition, String annotationType) {
        this.attributes = beanDefinition.getMetadata().getAnnotationAttributes(annotationType, true);
        try {
            this.functionExecutionInterface = beanDefinition.resolveBeanClass(beanDefinition.getClass().getClassLoader());
            Assert.isTrue((boolean)this.functionExecutionInterface.isInterface(), (String)String.format("The annotation %s only applies to an interface. It is not valid for the type %s", annotationType, this.functionExecutionInterface.getName()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.annotationType = annotationType;
    }

    Class<?> getFunctionExecutionInterface() {
        return this.functionExecutionInterface;
    }

    Map<String, Object> getAttributes() {
        return this.attributes;
    }

    Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    String getAnnotationType() {
        return this.annotationType;
    }
}

