/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PoolFactoryBean
implements FactoryBean<Pool>,
InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(PoolFactoryBean.class);
    private volatile boolean internalPool = true;
    private BeanFactory beanFactory;
    private Collection<InetSocketAddress> locators;
    private Collection<InetSocketAddress> servers;
    private Pool pool;
    private String beanName;
    private String name;
    private boolean keepAlive = false;
    private boolean multiUserAuthentication = false;
    private boolean prSingleHopEnabled = true;
    private boolean subscriptionEnabled = false;
    private boolean threadLocalConnections = false;
    private int freeConnectionTimeout = 10000;
    private int loadConditioningInterval = 300000;
    private int maxConnections = -1;
    private int minConnections = 1;
    private int readTimeout = 10000;
    private int retryAttempts = -1;
    private int socketBufferSize = 32768;
    private int statisticInterval = -1;
    private int subscriptionAckInterval = 100;
    private int subscriptionMessageTrackingTimeout = 900000;
    private int subscriptionRedundancy = 0;
    private long idleTimeout = 5000L;
    private long pingInterval = 10000L;
    private String serverGroup = "";

    public Pool getObject() throws Exception {
        return this.pool;
    }

    public Class<?> getObjectType() {
        return this.pool != null ? this.pool.getClass() : Pool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Pool existingPool;
        if (!StringUtils.hasText((String)this.name)) {
            Assert.hasText((String)this.beanName, (String)"The Pool name is required!");
            this.name = this.beanName;
        }
        if ((existingPool = PoolManager.find((String)this.name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("A Pool with name '%1$s' already exists; using existing Pool.", this.name));
            }
            this.internalPool = false;
            this.pool = existingPool;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("No Pool with name '%1$s' was found. Creating a new Pool...", this.name));
            }
            if (CollectionUtils.isEmpty(this.locators) && CollectionUtils.isEmpty(this.servers)) {
                throw new IllegalArgumentException("At least one locator or server is required!");
            }
            this.internalPool = true;
            PoolFactory poolFactory = PoolManager.createFactory();
            poolFactory.setFreeConnectionTimeout(this.freeConnectionTimeout);
            poolFactory.setIdleTimeout(this.idleTimeout);
            poolFactory.setLoadConditioningInterval(this.loadConditioningInterval);
            poolFactory.setMaxConnections(this.maxConnections);
            poolFactory.setMinConnections(this.minConnections);
            poolFactory.setMultiuserAuthentication(this.multiUserAuthentication);
            poolFactory.setPingInterval(this.pingInterval);
            poolFactory.setPRSingleHopEnabled(this.prSingleHopEnabled);
            poolFactory.setReadTimeout(this.readTimeout);
            poolFactory.setRetryAttempts(this.retryAttempts);
            poolFactory.setServerGroup(this.serverGroup);
            poolFactory.setSocketBufferSize(this.socketBufferSize);
            poolFactory.setStatisticInterval(this.statisticInterval);
            poolFactory.setSubscriptionAckInterval(this.subscriptionAckInterval);
            poolFactory.setSubscriptionEnabled(this.subscriptionEnabled);
            poolFactory.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout);
            poolFactory.setSubscriptionRedundancy(this.subscriptionRedundancy);
            poolFactory.setThreadLocalConnections(this.threadLocalConnections);
            for (InetSocketAddress connection : this.nullSafeCollection(this.locators)) {
                poolFactory.addLocator(connection.getHostName(), connection.getPort());
            }
            for (InetSocketAddress connection : this.nullSafeCollection(this.servers)) {
                poolFactory.addServer(connection.getHostName(), connection.getPort());
            }
            if (InternalDistributedSystem.getAnyInstance() == null) {
                PoolFactoryBean.doDistributedSystemConnect(this.resolveGemfireProperties());
            }
            this.pool = poolFactory.create(this.name);
        }
    }

    public void destroy() throws Exception {
        if (this.internalPool && this.pool != null && !this.pool.isDestroyed()) {
            this.pool.releaseThreadLocalConnection();
            this.pool.destroy(this.keepAlive);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Destroyed Pool '%1$s'.", this.name));
            }
        }
    }

    static void doDistributedSystemConnect(Properties properties) {
        Properties gemfireProperties = properties != null ? (Properties)properties.clone() : new Properties();
        gemfireProperties.setProperty("locators", "");
        gemfireProperties.setProperty("mcast-port", "0");
        DistributedSystem.connect((Properties)gemfireProperties);
    }

    private <T> Collection<T> nullSafeCollection(Collection<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private Properties resolveGemfireProperties() {
        try {
            ClientCacheFactoryBean clientCacheFactoryBean = (ClientCacheFactoryBean)this.beanFactory.getBean(ClientCacheFactoryBean.class);
            return clientCacheFactoryBean.getProperties();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setFreeConnectionTimeout(int freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setLoadConditioningInterval(int loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public void setLocators(Collection<InetSocketAddress> locators) {
        this.locators = locators;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setMultiUserAuthentication(boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public void setServers(Collection<InetSocketAddress> servers) {
        this.servers = servers;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setStatisticInterval(int statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    public void setPrSingleHopEnabled(boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    public void setSubscriptionAckInterval(int subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(int subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(int subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public void setThreadLocalConnections(boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }
}

