/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.util.Assert;

public class GemfireAccessor
implements InitializingBean {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Region region;

    public <K, V> Region<K, V> getRegion() {
        return this.region;
    }

    public void setRegion(Region<?, ?> region) {
        this.region = region;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.getRegion(), (String)"The GemFire Cache Region is required.");
    }

    public DataAccessException convertGemFireAccessException(GemFireCheckedException ex) {
        return GemfireCacheUtils.convertGemfireAccessException(ex);
    }

    public DataAccessException convertGemFireAccessException(GemFireException ex) {
        return GemfireCacheUtils.convertGemfireAccessException(ex);
    }

    public DataAccessException convertGemFireQueryException(RuntimeException ex) {
        return GemfireCacheUtils.convertQueryExceptions(ex);
    }
}

