/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.elasticsearch.annotations.Highlight;
import org.springframework.data.elasticsearch.annotations.Query;
import org.springframework.data.elasticsearch.annotations.SearchTemplateQuery;
import org.springframework.data.elasticsearch.annotations.SourceFilters;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.FetchSourceFilterBuilder;
import org.springframework.data.elasticsearch.core.query.HighlightQuery;
import org.springframework.data.elasticsearch.core.query.RuntimeField;
import org.springframework.data.elasticsearch.core.query.ScriptedField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchEntityMetadata;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameters;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.HighlightConverter;
import org.springframework.data.elasticsearch.repository.query.SimpleElasticsearchEntityMetadata;
import org.springframework.data.elasticsearch.repository.support.QueryStringProcessor;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ElasticsearchQueryMethod
extends QueryMethod {
    protected final Method method;
    protected final Class<?> unwrappedReturnType;
    private @Nullable Boolean unwrappedReturnTypeFromSearchHit = null;
    private final MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext;
    private @Nullable ElasticsearchEntityMetadata<?> metadata;
    private final @Nullable Query queryAnnotation;
    private final @Nullable Highlight highlightAnnotation;
    private final @Nullable SourceFilters sourceFilters;
    private final @Nullable SearchTemplateQuery searchTemplateQueryAnnotation;

    public ElasticsearchQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory factory, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        super(method, repositoryMetadata, factory);
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.method = method;
        this.mappingContext = mappingContext;
        this.queryAnnotation = (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Query.class);
        this.highlightAnnotation = (Highlight)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Highlight.class);
        this.sourceFilters = (SourceFilters)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, SourceFilters.class);
        this.unwrappedReturnType = this.potentiallyUnwrapReturnTypeFor(repositoryMetadata, method);
        this.searchTemplateQueryAnnotation = (SearchTemplateQuery)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, SearchTemplateQuery.class);
        this.verifyCountQueryTypes();
    }

    protected Parameters<?, ?> createParameters(ParametersSource parametersSource) {
        return new ElasticsearchParameters(parametersSource);
    }

    protected void verifyCountQueryTypes() {
        TypeInformation returnType;
        if (this.hasCountQueryAnnotation() && (returnType = TypeInformation.fromReturnTypeOf((Method)this.method)).getType() != Long.TYPE && !Long.class.isAssignableFrom(returnType.getType())) {
            throw new InvalidDataAccessApiUsageException("count query methods must return a Long");
        }
    }

    public boolean hasAnnotatedQuery() {
        return this.queryAnnotation != null;
    }

    public @Nullable String getAnnotatedQuery() {
        return this.queryAnnotation != null ? this.queryAnnotation.value() : null;
    }

    public boolean hasAnnotatedHighlight() {
        return this.highlightAnnotation != null;
    }

    public HighlightQuery getAnnotatedHighlightQuery(HighlightConverter highlightConverter) {
        Assert.isTrue((boolean)this.hasAnnotatedHighlight(), (String)("no Highlight annotation present on " + this.getName()));
        Assert.notNull((Object)this.highlightAnnotation, (String)"highlightAnnotation must not be null");
        return new HighlightQuery(highlightConverter.convert(this.highlightAnnotation), this.getDomainClass());
    }

    public boolean hasAnnotatedSearchTemplateQuery() {
        return this.searchTemplateQueryAnnotation != null;
    }

    public SearchTemplateQuery getAnnotatedSearchTemplateQuery() {
        Assert.isTrue((boolean)this.hasAnnotatedSearchTemplateQuery(), (String)("no SearchTemplateQuery annotation present on " + this.getName()));
        Assert.notNull((Object)this.searchTemplateQueryAnnotation, (String)"highlsearchTemplateQueryAnnotationightAnnotation must not be null");
        return this.searchTemplateQueryAnnotation;
    }

    public ElasticsearchEntityMetadata<?> getEntityInformation() {
        if (this.metadata == null) {
            Class returnedObjectType = this.getReturnedObjectType();
            Class domainClass = this.getDomainClass();
            if (ClassUtils.isPrimitiveOrWrapper((Class)returnedObjectType)) {
                this.metadata = new SimpleElasticsearchEntityMetadata(domainClass, (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass));
            } else {
                ElasticsearchPersistentEntity returnedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getPersistentEntity(returnedObjectType);
                ElasticsearchPersistentEntity managedEntity = (ElasticsearchPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
                returnedEntity = returnedEntity == null || returnedEntity.getType().isInterface() ? managedEntity : returnedEntity;
                ElasticsearchPersistentEntity collectionEntity = domainClass.isAssignableFrom(returnedObjectType) ? returnedEntity : managedEntity;
                this.metadata = new SimpleElasticsearchEntityMetadata(returnedEntity.getType(), collectionEntity);
            }
        }
        return this.metadata;
    }

    protected MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    public boolean isSearchHitMethod() {
        if (this.unwrappedReturnTypeFromSearchHit != null && this.unwrappedReturnTypeFromSearchHit.booleanValue()) {
            return true;
        }
        Class<?> methodReturnType = this.method.getReturnType();
        if (SearchHits.class.isAssignableFrom(methodReturnType)) {
            return true;
        }
        try {
            ParameterizedType collectionTypeArgument;
            ParameterizedType methodGenericReturnType = (ParameterizedType)this.method.getGenericReturnType();
            if (this.isAllowedGenericType(methodGenericReturnType) && SearchHit.class.isAssignableFrom((Class)(collectionTypeArgument = (ParameterizedType)methodGenericReturnType.getActualTypeArguments()[0]).getRawType())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSearchPageMethod() {
        return SearchPage.class.isAssignableFrom(this.methodReturnType());
    }

    public Class<?> methodReturnType() {
        return this.method.getReturnType();
    }

    protected boolean isAllowedGenericType(ParameterizedType methodGenericReturnType) {
        return Collection.class.isAssignableFrom((Class)methodGenericReturnType.getRawType()) || Stream.class.isAssignableFrom((Class)methodGenericReturnType.getRawType());
    }

    public boolean isNotSearchHitMethod() {
        return !this.isSearchHitMethod();
    }

    public boolean isNotSearchPageMethod() {
        return !this.isSearchPageMethod();
    }

    public boolean hasCountQueryAnnotation() {
        return this.queryAnnotation != null && this.queryAnnotation.count();
    }

    @Nullable SourceFilter getSourceFilter(ElasticsearchParametersParameterAccessor parameterAccessor, ElasticsearchConverter converter, ValueEvaluationContextProvider evaluationContextProvider) {
        if (this.sourceFilters == null || this.sourceFilters.includes().length == 0 && this.sourceFilters.excludes().length == 0) {
            return null;
        }
        ConversionService conversionService = converter.getConversionService();
        FetchSourceFilterBuilder fetchSourceFilterBuilder = new FetchSourceFilterBuilder();
        if (this.sourceFilters.includes().length > 0) {
            fetchSourceFilterBuilder.withIncludes(this.mapParameters(this.sourceFilters.includes(), parameterAccessor, conversionService, evaluationContextProvider));
        }
        if (this.sourceFilters.excludes().length > 0) {
            fetchSourceFilterBuilder.withExcludes(this.mapParameters(this.sourceFilters.excludes(), parameterAccessor, conversionService, evaluationContextProvider));
        }
        return fetchSourceFilterBuilder.build();
    }

    private String[] mapParameters(String[] source, ElasticsearchParametersParameterAccessor parameterAccessor, ConversionService conversionService, ValueEvaluationContextProvider evaluationContextProvider) {
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String s : source) {
            if (s.isBlank()) continue;
            String fieldName = new QueryStringProcessor(s, this, conversionService, evaluationContextProvider).createQuery(parameterAccessor);
            if (fieldName.startsWith("[") && fieldName.endsWith("]")) {
                fieldNames.addAll(Arrays.asList(fieldName.substring(1, fieldName.length() - 2).replaceAll("\\\"", "").split(",")));
                continue;
            }
            fieldNames.add(fieldName);
        }
        return fieldNames.toArray(new String[0]);
    }

    private Class<?> potentiallyUnwrapReturnTypeFor(RepositoryMetadata metadata, Method method) {
        TypeInformation returnType = metadata.getReturnType(method);
        if (!QueryExecutionConverters.supports((Class)returnType.getType()) && !ReactiveWrapperConverters.supports((Class)returnType.getType())) {
            return returnType.getType();
        }
        TypeInformation componentType = returnType.getComponentType();
        if (componentType == null) {
            throw new IllegalStateException(String.format("Couldn't find component type for return value of method %s", method));
        }
        if (SearchHit.class.isAssignableFrom(componentType.getType())) {
            this.unwrappedReturnTypeFromSearchHit = true;
            return componentType.getComponentType().getType();
        }
        return componentType.getType();
    }

    void addSpecialMethodParameters(BaseQuery query, ElasticsearchParametersParameterAccessor parameterAccessor, ElasticsearchConverter elasticsearchConverter, ValueEvaluationContextProvider evaluationContextProvider) {
        Parameters parameters;
        SourceFilter sourceFilter;
        if (this.hasAnnotatedHighlight()) {
            HighlightQuery highlightQuery = this.getAnnotatedHighlightQuery(new HighlightConverter(parameterAccessor, elasticsearchConverter.getConversionService(), evaluationContextProvider, this));
            query.setHighlightQuery(highlightQuery);
        }
        if ((sourceFilter = this.getSourceFilter(parameterAccessor, elasticsearchConverter, evaluationContextProvider)) != null) {
            query.addSourceFilter(sourceFilter);
        }
        if ((parameters = parameterAccessor.getParameters()) instanceof ElasticsearchParameters) {
            boolean needToAddSourceFilter;
            ElasticsearchParameters methodParameters = (ElasticsearchParameters)parameters;
            Object[] values = parameterAccessor.getValues();
            methodParameters.getScriptedFields().forEach(elasticsearchParameter -> {
                int index = elasticsearchParameter.getIndex();
                if (index >= 0 && index < values.length) {
                    query.addScriptedField((ScriptedField)values[index]);
                }
            });
            methodParameters.getRuntimeFields().forEach(elasticsearchParameter -> {
                int index = elasticsearchParameter.getIndex();
                if (index >= 0 && index < values.length) {
                    RuntimeField runtimeField = (RuntimeField)values[index];
                    query.addRuntimeField(runtimeField);
                    query.addFields(runtimeField.getName());
                }
            });
            boolean bl = needToAddSourceFilter = sourceFilter == null && (!methodParameters.getRuntimeFields().isEmpty() || !methodParameters.getScriptedFields().isEmpty());
            if (needToAddSourceFilter) {
                query.addSourceFilter(FetchSourceFilter.of(b -> b.withIncludes("*")));
            }
        }
    }
}

