/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.ProcessBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.cdi.ElasticsearchRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class ElasticsearchRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Log LOGGER = LogFactory.getLog(ElasticsearchRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<ElasticsearchOperations>> elasticsearchOperationsMap = new HashMap<Set<Annotation>, Bean<ElasticsearchOperations>>();

    <T> void processBean(@Observes ProcessBean<T> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !ElasticsearchOperations.class.isAssignableFrom((Class)type)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)String.format("Discovered %s with qualifiers %s.", ElasticsearchOperations.class.getName(), bean.getQualifiers()));
            }
            this.elasticsearchOperationsMap.put(new HashSet(bean.getQualifiers()), (Bean<ElasticsearchOperations>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)String.format("Registering bean for %s with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<ElasticsearchOperations> elasticsearchOperations = this.elasticsearchOperationsMap.get(qualifiers);
        if (elasticsearchOperations == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", ElasticsearchOperations.class.getName(), qualifiers));
        }
        return new ElasticsearchRepositoryBean<T>(elasticsearchOperations, qualifiers, repositoryType, beanManager, Optional.of(this.getCustomImplementationDetector()));
    }
}

