/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class SqlQuery {
    private final @Nullable Boolean allowPartialSearchResults;
    private final @Nullable String catalog;
    private final @Nullable Boolean columnar;
    private final @Nullable String cursor;
    private final @Nullable Integer fetchSize;
    private final @Nullable Boolean fieldMultiValueLeniency;
    private final @Nullable Query filter;
    private final @Nullable Boolean indexIncludeFrozen;
    private final @Nullable Duration keepAlive;
    private final @Nullable Boolean keepOnCompletion;
    private final @Nullable Duration pageTimeout;
    private final @Nullable Duration requestTimeout;
    private final @Nullable List<Object> params;
    private final String query;
    private final @Nullable TimeZone timeZone;
    private final @Nullable Duration waitForCompletionTimeout;

    private SqlQuery(Builder builder) {
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.catalog = builder.catalog;
        this.columnar = builder.columnar;
        this.cursor = builder.cursor;
        this.fetchSize = builder.fetchSize;
        this.fieldMultiValueLeniency = builder.fieldMultiValueLeniency;
        this.filter = builder.filter;
        this.indexIncludeFrozen = builder.indexIncludeFrozen;
        this.keepAlive = builder.keepAlive;
        this.keepOnCompletion = builder.keepOnCompletion;
        this.pageTimeout = builder.pageTimeout;
        this.requestTimeout = builder.requestTimeout;
        this.params = builder.params;
        this.query = builder.query;
        this.timeZone = builder.timeZone;
        this.waitForCompletionTimeout = builder.waitForCompletionTimeout;
    }

    public @Nullable Boolean getAllowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    public @Nullable String getCatalog() {
        return this.catalog;
    }

    public @Nullable Boolean getColumnar() {
        return this.columnar;
    }

    public @Nullable String getCursor() {
        return this.cursor;
    }

    public @Nullable Integer getFetchSize() {
        return this.fetchSize;
    }

    public @Nullable Boolean getFieldMultiValueLeniency() {
        return this.fieldMultiValueLeniency;
    }

    public @Nullable Query getFilter() {
        return this.filter;
    }

    public @Nullable Boolean getIndexIncludeFrozen() {
        return this.indexIncludeFrozen;
    }

    public @Nullable Duration getKeepAlive() {
        return this.keepAlive;
    }

    public @Nullable Boolean getKeepOnCompletion() {
        return this.keepOnCompletion;
    }

    public @Nullable Duration getPageTimeout() {
        return this.pageTimeout;
    }

    public @Nullable Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public @Nullable List<Object> getParams() {
        return this.params;
    }

    public String getQuery() {
        return this.query;
    }

    public @Nullable TimeZone getTimeZone() {
        return this.timeZone;
    }

    public @Nullable Duration getWaitForCompletionTimeout() {
        return this.waitForCompletionTimeout;
    }

    public static Builder builder(String query) {
        return new Builder(query);
    }

    public static class Builder {
        private @Nullable Boolean allowPartialSearchResults;
        private @Nullable String catalog;
        private @Nullable Boolean columnar;
        private @Nullable String cursor;
        private @Nullable Integer fetchSize;
        private @Nullable Boolean fieldMultiValueLeniency;
        private @Nullable Query filter;
        private @Nullable Boolean indexIncludeFrozen;
        private @Nullable Duration keepAlive;
        private @Nullable Boolean keepOnCompletion;
        private @Nullable Duration pageTimeout;
        private @Nullable Duration requestTimeout;
        private @Nullable List<Object> params;
        private final String query;
        private @Nullable TimeZone timeZone;
        private @Nullable Duration waitForCompletionTimeout;

        private Builder(String query) {
            Assert.notNull((Object)query, (String)"query must not be null");
            this.query = query;
        }

        public Builder withAllowPartialSearchResults(Boolean allowPartialSearchResults) {
            this.allowPartialSearchResults = allowPartialSearchResults;
            return this;
        }

        public Builder withCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder withColumnar(Boolean columnar) {
            this.columnar = columnar;
            return this;
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder withFieldMultiValueLeniency(Boolean fieldMultiValueLeniency) {
            this.fieldMultiValueLeniency = fieldMultiValueLeniency;
            return this;
        }

        public Builder setFilter(Query filter) {
            this.filter = filter;
            return this;
        }

        public Builder withIndexIncludeFrozen(Boolean indexIncludeFrozen) {
            this.indexIncludeFrozen = indexIncludeFrozen;
            return this;
        }

        public Builder setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder withKeepOnCompletion(Boolean keepOnCompletion) {
            this.keepOnCompletion = keepOnCompletion;
            return this;
        }

        public Builder withPageTimeout(Duration pageTimeout) {
            this.pageTimeout = pageTimeout;
            return this;
        }

        public Builder withRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }

        public Builder withParams(List<Object> params) {
            this.params = params;
            return this;
        }

        public Builder withParam(Object param) {
            if (this.params == null) {
                this.params = new ArrayList<Object>();
            }
            this.params.add(param);
            return this;
        }

        public Builder withTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder withWaitForCompletionTimeout(Duration waitForCompletionTimeout) {
            this.waitForCompletionTimeout = waitForCompletionTimeout;
            return this;
        }

        public SqlQuery build() {
            return new SqlQuery(this);
        }
    }
}

