/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Map;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public record ScriptData(@Nullable String language, @Nullable String script, @Nullable String scriptName, @Nullable Map<String, Object> params) {
    public ScriptData(@Nullable String language, @Nullable String script, @Nullable String scriptName, @Nullable Map<String, Object> params) {
        Assert.isTrue((script != null || scriptName != null ? 1 : 0) != 0, (String)"script or scriptName is required");
    }

    public static ScriptData of(@Nullable String language, @Nullable String script, @Nullable String scriptName, @Nullable Map<String, Object> params) {
        return new ScriptData(language, script, scriptName, params);
    }

    public static ScriptData of(Function<Builder, Builder> builderFunction) {
        Assert.notNull(builderFunction, (String)"builderFunction must not be null");
        return builderFunction.apply(new Builder()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private @Nullable String language;
        private @Nullable String script;
        private @Nullable String scriptName;
        private @Nullable Map<String, Object> params;

        private Builder() {
        }

        public Builder withLanguage(@Nullable String language) {
            this.language = language;
            return this;
        }

        public Builder withScript(@Nullable String script) {
            this.script = script;
            return this;
        }

        public Builder withScriptName(@Nullable String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public Builder withParams(@Nullable Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public ScriptData build() {
            return new ScriptData(this.language, this.script, this.scriptName, this.params);
        }
    }
}

