/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class Order
extends Sort.Order {
    public static final Sort.NullHandling DEFAULT_NULL_HANDLING = Sort.NullHandling.NATIVE;
    protected final @Nullable Mode mode;
    protected final @Nullable String unmappedType;
    protected final @Nullable String missing;
    protected final @Nullable Nested nested;

    public Order(Sort.Direction direction, String property) {
        this(direction, property, (Mode)null, null);
    }

    public Order(Sort.Direction direction, String property, @Nullable Mode mode) {
        this(direction, property, DEFAULT_NULL_HANDLING, mode, null);
    }

    public Order(Sort.Direction direction, String property, @Nullable String unmappedType) {
        this(direction, property, DEFAULT_NULL_HANDLING, null, unmappedType);
    }

    public Order(Sort.Direction direction, String property, @Nullable Mode mode, @Nullable String unmappedType) {
        this(direction, property, DEFAULT_NULL_HANDLING, mode, unmappedType);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
        this(direction, property, nullHandlingHint, null, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable Mode mode) {
        this(direction, property, nullHandlingHint, mode, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable String unmappedType) {
        this(direction, property, nullHandlingHint, null, unmappedType);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable Mode mode, @Nullable String unmappedType) {
        this(direction, property, nullHandlingHint, mode, unmappedType, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable Mode mode, @Nullable String unmappedType, @Nullable String missing) {
        this(direction, property, nullHandlingHint, mode, unmappedType, missing, null);
    }

    public Order(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint, @Nullable Mode mode, @Nullable String unmappedType, @Nullable String missing, @Nullable Nested nested) {
        super(direction, property, nullHandlingHint);
        this.mode = mode;
        this.unmappedType = unmappedType;
        this.missing = missing;
        this.nested = nested;
    }

    public @Nullable String getUnmappedType() {
        return this.unmappedType;
    }

    public Sort.Order with(Sort.Direction direction) {
        return new Order(direction, this.getProperty(), this.getNullHandling(), this.mode, this.unmappedType, this.missing, this.nested);
    }

    public Sort.Order withProperty(String property) {
        return new Order(this.getDirection(), property, this.getNullHandling(), this.mode, this.unmappedType, this.missing, this.nested);
    }

    public Sort.Order with(Sort.NullHandling nullHandling) {
        return new Order(this.getDirection(), this.getProperty(), nullHandling, this.getMode(), this.unmappedType, this.missing, this.nested);
    }

    public Order withUnmappedType(@Nullable String unmappedType) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), this.getMode(), unmappedType, this.missing, this.nested);
    }

    public Order with(@Nullable Mode mode) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), mode, this.unmappedType, this.missing, this.nested);
    }

    public Order withMissing(@Nullable String missing) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), this.mode, this.unmappedType, missing, this.nested);
    }

    public Order withNested(@Nullable Nested nested) {
        return new Order(this.getDirection(), this.getProperty(), this.getNullHandling(), this.mode, this.unmappedType, this.missing, nested);
    }

    public @Nullable Mode getMode() {
        return this.mode;
    }

    public @Nullable String getMissing() {
        return this.missing;
    }

    public @Nullable Nested getNested() {
        return this.nested;
    }

    public static enum Mode {
        min,
        max,
        median,
        avg;

    }

    public static class Nested {
        private final String path;
        private final @Nullable Query filter;
        private @Nullable Integer maxChildren = null;
        private final @Nullable Nested nested;

        public static Nested of(String path, Function<Builder, Builder> builderFunction) {
            Assert.notNull((Object)path, (String)"path must not be null");
            Assert.notNull(builderFunction, (String)"builderFunction must not be null");
            return builderFunction.apply(Nested.builder(path)).build();
        }

        public Nested(String path, @Nullable Query filter, @Nullable Integer maxChildren, @Nullable Nested nested) {
            Assert.notNull((Object)path, (String)"path must not be null");
            this.path = path;
            this.filter = filter;
            this.maxChildren = maxChildren;
            this.nested = nested;
        }

        public String getPath() {
            return this.path;
        }

        public @Nullable Query getFilter() {
            return this.filter;
        }

        public @Nullable Integer getMaxChildren() {
            return this.maxChildren;
        }

        public @Nullable Nested getNested() {
            return this.nested;
        }

        public static Builder builder(String path) {
            return new Builder(path);
        }

        public static class Builder {
            private final String path;
            private @Nullable Query filter = null;
            private @Nullable Integer maxChildren = null;
            private @Nullable Nested nested = null;

            public Builder(String path) {
                Assert.notNull((Object)path, (String)"path must not be null");
                this.path = path;
            }

            public Builder withFilter(@Nullable Query filter) {
                if (filter instanceof CriteriaQuery) {
                    throw new IllegalArgumentException("Cannot use a CriteriaQuery in a nested sort filter.");
                }
                this.filter = filter;
                return this;
            }

            public Builder withMaxChildren(@Nullable Integer maxChildren) {
                this.maxChildren = maxChildren;
                return this;
            }

            public Builder withNested(@Nullable Nested nested) {
                this.nested = nested;
                return this;
            }

            public Nested build() {
                return new Nested(this.path, this.filter, this.maxChildren, this.nested);
            }
        }
    }
}

