/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.InnerHitsQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class HasChildQuery {
    private final String type;
    private final Query query;
    private final @Nullable Boolean ignoreUnmapped;
    private final @Nullable Integer maxChildren;
    private final @Nullable Integer minChildren;
    private final @Nullable ScoreMode scoreMode;
    private final @Nullable InnerHitsQuery innerHitsQuery;

    public static Builder builder(String type) {
        return new Builder(type);
    }

    private HasChildQuery(Builder builder) {
        this.type = builder.type;
        this.query = builder.query;
        this.innerHitsQuery = builder.innerHitsQuery;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.maxChildren = builder.maxChildren;
        this.minChildren = builder.minChildren;
        this.scoreMode = builder.scoreMode;
    }

    public String getType() {
        return this.type;
    }

    public Query getQuery() {
        return this.query;
    }

    public @Nullable Boolean getIgnoreUnmapped() {
        return this.ignoreUnmapped;
    }

    public @Nullable Integer getMaxChildren() {
        return this.maxChildren;
    }

    public @Nullable Integer getMinChildren() {
        return this.minChildren;
    }

    public @Nullable ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    public @Nullable InnerHitsQuery getInnerHitsQuery() {
        return this.innerHitsQuery;
    }

    public static final class Builder {
        private final String type;
        private @Nullable Query query;
        private @Nullable Boolean ignoreUnmapped;
        private @Nullable Integer maxChildren;
        private @Nullable Integer minChildren;
        private @Nullable ScoreMode scoreMode;
        private @Nullable InnerHitsQuery innerHitsQuery;

        private Builder(String type) {
            Assert.notNull((Object)type, (String)"type must not be null");
            this.type = type;
        }

        public Builder withQuery(Query query) {
            this.query = query;
            return this;
        }

        public Builder withIgnoreUnmapped(@Nullable Boolean ignoreUnmapped) {
            this.ignoreUnmapped = ignoreUnmapped;
            return this;
        }

        public Builder withMaxChildren(@Nullable Integer maxChildren) {
            this.maxChildren = maxChildren;
            return this;
        }

        public Builder withMinChildren(@Nullable Integer minChildren) {
            this.minChildren = minChildren;
            return this;
        }

        public Builder withScoreMode(@Nullable ScoreMode scoreMode) {
            this.scoreMode = scoreMode;
            return this;
        }

        public Builder withInnerHitsQuery(@Nullable InnerHitsQuery innerHitsQuery) {
            this.innerHitsQuery = innerHitsQuery;
            return this;
        }

        public HasChildQuery build() {
            Assert.notNull((Object)this.query, (String)"query must not be null.");
            return new HasChildQuery(this);
        }
    }

    public static enum ScoreMode {
        Default,
        Avg,
        Max,
        Min,
        Sum;

    }
}

