/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.util.Assert;

public class Alias {
    private final String alias;
    private final @Nullable Query filter;
    private final @Nullable String indexRouting;
    private final @Nullable String searchRouting;
    private final @Nullable String routing;
    private final @Nullable Boolean isHidden;
    private final @Nullable Boolean isWriteIndex;

    private Alias(Builder builder) {
        this.alias = builder.alias;
        this.filter = builder.filter;
        this.indexRouting = builder.indexRouting;
        this.searchRouting = builder.searchRouting;
        this.routing = builder.routing;
        this.isHidden = builder.isHidden;
        this.isWriteIndex = builder.isWriteIndex;
    }

    public String getAlias() {
        return this.alias;
    }

    public @Nullable Query getFilter() {
        return this.filter;
    }

    public @Nullable String getIndexRouting() {
        return this.indexRouting;
    }

    public @Nullable String getSearchRouting() {
        return this.searchRouting;
    }

    public @Nullable String getRouting() {
        return this.routing;
    }

    public @Nullable Boolean getHidden() {
        return this.isHidden;
    }

    public @Nullable Boolean getWriteIndex() {
        return this.isWriteIndex;
    }

    public static Builder builder(String alias) {
        return new Builder(alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Alias)) {
            return false;
        }
        Alias that = (Alias)o;
        return Objects.equals(this.alias, that.alias) && Objects.equals(this.filter, that.filter) && Objects.equals(this.indexRouting, that.indexRouting) && Objects.equals(this.searchRouting, that.searchRouting) && Objects.equals(this.routing, that.routing) && Objects.equals(this.isHidden, that.isHidden) && Objects.equals(this.isWriteIndex, that.isWriteIndex);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.filter, this.indexRouting, this.searchRouting, this.routing, this.isHidden, this.isWriteIndex);
    }

    public static class Builder {
        private final String alias;
        private @Nullable Query filter;
        private @Nullable String indexRouting;
        private @Nullable String searchRouting;
        private @Nullable String routing;
        private @Nullable Boolean isHidden;
        private @Nullable Boolean isWriteIndex;

        public Builder(String alias) {
            Assert.notNull((Object)alias, (String)"alias must not be null");
            this.alias = alias;
        }

        public Builder withFilter(@Nullable Query filter) {
            this.filter = filter;
            return this;
        }

        public Builder withIndexRouting(@Nullable String indexRouting) {
            if (indexRouting != null && !indexRouting.trim().isEmpty()) {
                this.indexRouting = indexRouting;
            }
            return this;
        }

        public Builder withSearchRouting(@Nullable String searchRouting) {
            if (searchRouting != null && !searchRouting.trim().isEmpty()) {
                this.searchRouting = searchRouting;
            }
            return this;
        }

        public Builder withRouting(@Nullable String routing) {
            if (routing != null && !routing.trim().isEmpty()) {
                this.routing = routing;
            }
            return this;
        }

        public Builder withHidden(@Nullable Boolean hidden) {
            this.isHidden = hidden;
            return this;
        }

        public Builder withWriteIndex(@Nullable Boolean writeIndex) {
            this.isWriteIndex = writeIndex;
            return this;
        }

        public Alias build() {
            return new Alias(this);
        }
    }
}

