/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.Settings;
import org.springframework.util.Assert;

public record PutIndexTemplateRequest(String name, String[] indexPatterns, @Nullable Settings settings, @Nullable Document mapping, @Nullable AliasActions aliasActions, List<String> composedOf) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable String name;
        private String @Nullable [] indexPatterns;
        private @Nullable Settings settings;
        private @Nullable Document mapping;
        @Nullable AliasActions aliasActions;
        @Nullable List<String> composedOf;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withIndexPatterns(String ... indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder withSettings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withMapping(Document mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withAliasActions(AliasActions aliasActions) {
            this.aliasActions = aliasActions;
            return this;
        }

        public Builder withComposedOf(List<String> composedOf) {
            this.composedOf = composedOf;
            return this;
        }

        public PutIndexTemplateRequest build() {
            Assert.notNull((Object)this.name, (String)"name must not be null");
            Assert.notNull((Object)this.indexPatterns, (String)"indexPatterns must not be null");
            Assert.isTrue((this.indexPatterns.length > 0 ? 1 : 0) != 0, (String)"indexPatterns must not be empty");
            return new PutIndexTemplateRequest(this.name, this.indexPatterns, this.settings, this.mapping, this.aliasActions, this.composedOf != null ? this.composedOf : List.of());
        }
    }
}

