/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.IndexOptions;
import org.springframework.data.elasticsearch.annotations.IndexPrefixes;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.KnnAlgorithmType;
import org.springframework.data.elasticsearch.annotations.KnnIndexOptions;
import org.springframework.data.elasticsearch.annotations.KnnSimilarity;
import org.springframework.data.elasticsearch.annotations.NullValueType;
import org.springframework.data.elasticsearch.annotations.TermVector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class MappingParameters {
    static final String FIELD_PARAM_COERCE = "coerce";
    static final String FIELD_PARAM_COPY_TO = "copy_to";
    static final String FIELD_PARAM_DATA = "fielddata";
    static final String FIELD_PARAM_DOC_VALUES = "doc_values";
    static final String FIELD_PARAM_EAGER_GLOBAL_ORDINALS = "eager_global_ordinals";
    static final String FIELD_PARAM_ENABLED = "enabled";
    static final String FIELD_PARAM_FORMAT = "format";
    static final String FIELD_PARAM_IGNORE_ABOVE = "ignore_above";
    static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    static final String FIELD_PARAM_IGNORE_Z_VALUE = "ignore_z_value";
    static final String FIELD_PARAM_INDEX = "index";
    static final String FIELD_PARAM_INDEX_OPTIONS = "index_options";
    static final String FIELD_PARAM_INDEX_PHRASES = "index_phrases";
    static final String FIELD_PARAM_INDEX_PREFIXES = "index_prefixes";
    static final String FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS = "min_chars";
    static final String FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS = "max_chars";
    static final String FIELD_PARAM_INDEX_ANALYZER = "analyzer";
    static final String FIELD_PARAM_MAX_SHINGLE_SIZE = "max_shingle_size";
    static final String FIELD_PARAM_NORMALIZER = "normalizer";
    static final String FIELD_PARAM_NORMS = "norms";
    static final String FIELD_PARAM_NULL_VALUE = "null_value";
    static final String FIELD_PARAM_POSITION_INCREMENT_GAP = "position_increment_gap";
    static final String FIELD_PARAM_ORIENTATION = "orientation";
    static final String FIELD_PARAM_POSITIVE_SCORE_IMPACT = "positive_score_impact";
    static final String FIELD_PARAM_DIMS = "dims";
    static final String FIELD_PARAM_ELEMENT_TYPE = "element_type";
    static final String FIELD_PARAM_M = "m";
    static final String FIELD_PARAM_EF_CONSTRUCTION = "ef_construction";
    static final String FIELD_PARAM_CONFIDENCE_INTERVAL = "confidence_interval";
    static final String FIELD_PARAM_SCALING_FACTOR = "scaling_factor";
    static final String FIELD_PARAM_SEARCH_ANALYZER = "search_analyzer";
    static final String FIELD_PARAM_STORE = "store";
    static final String FIELD_PARAM_SIMILARITY = "similarity";
    static final String FIELD_PARAM_TERM_VECTOR = "term_vector";
    static final String FIELD_PARAM_TYPE = "type";
    static final String FIELD_PARAM_PATH = "path";
    static final String FIELD_PARAM_TYPE_ALIAS = "alias";
    private final String analyzer;
    private final boolean coerce;
    private final @Nullable String[] copyTo;
    private final DateFormat[] dateFormats;
    private final String[] dateFormatPatterns;
    private final boolean docValues;
    private final boolean eagerGlobalOrdinals;
    private final boolean enabled;
    private final boolean fielddata;
    private final @Nullable Integer ignoreAbove;
    private final boolean ignoreMalformed;
    private final boolean index;
    private final IndexOptions indexOptions;
    private final boolean indexPhrases;
    private final @Nullable IndexPrefixes indexPrefixes;
    private final String normalizer;
    private final boolean norms;
    private final @Nullable Integer maxShingleSize;
    private final String nullValue;
    private final NullValueType nullValueType;
    private final Integer positionIncrementGap;
    private final boolean positiveScoreImpact;
    private final Integer dims;
    private final String elementType;
    private final KnnSimilarity knnSimilarity;
    private final @Nullable KnnIndexOptions knnIndexOptions;
    private final String searchAnalyzer;
    private final double scalingFactor;
    private final String similarity;
    private final boolean store;
    private final TermVector termVector;
    private final FieldType type;
    private final String mappedTypeName;

    public static MappingParameters from(Annotation annotation) {
        Assert.notNull((Object)annotation, (String)"annotation must not be null!");
        if (annotation instanceof Field) {
            Field field = (Field)annotation;
            return new MappingParameters(field);
        }
        if (annotation instanceof InnerField) {
            InnerField innerField = (InnerField)annotation;
            return new MappingParameters(innerField);
        }
        throw new IllegalArgumentException("annotation must be an instance of @Field or @InnerField");
    }

    private MappingParameters(Field field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.mappedTypeName = StringUtils.hasText((String)field.mappedTypeName()) ? field.mappedTypeName() : this.type.getMappedName();
        this.dateFormats = field.format();
        this.dateFormatPatterns = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = field.copyTo();
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        this.dims = field.dims();
        if (this.type == FieldType.Dense_Vector) {
            Assert.isTrue((this.dims >= 1 && this.dims <= 4096 ? 1 : 0) != 0, (String)"Invalid required parameter! Dense_Vector value \"dims\" must be between 1 and 4096.");
        }
        this.elementType = field.elementType();
        this.knnSimilarity = field.knnSimilarity();
        this.knnIndexOptions = field.knnIndexOptions().length > 0 ? field.knnIndexOptions()[0] : null;
        Assert.isTrue((field.enabled() || this.type == FieldType.Object ? 1 : 0) != 0, (String)"enabled false is only allowed for field type object");
        this.enabled = field.enabled();
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    private MappingParameters(InnerField field) {
        this.index = field.index();
        this.store = field.store();
        this.fielddata = field.fielddata();
        this.type = field.type();
        this.mappedTypeName = StringUtils.hasText((String)field.mappedTypeName()) ? field.mappedTypeName() : this.type.getMappedName();
        this.dateFormats = field.format();
        this.dateFormatPatterns = field.pattern();
        this.analyzer = field.analyzer();
        this.searchAnalyzer = field.searchAnalyzer();
        this.normalizer = field.normalizer();
        this.copyTo = null;
        this.ignoreAbove = field.ignoreAbove() >= 0 ? Integer.valueOf(field.ignoreAbove()) : null;
        this.coerce = field.coerce();
        this.docValues = field.docValues();
        Assert.isTrue((this.type != FieldType.Text && this.type != FieldType.Nested || this.docValues ? 1 : 0) != 0, (String)"docValues false is not allowed for field type text");
        this.ignoreMalformed = field.ignoreMalformed();
        this.indexOptions = field.indexOptions();
        this.indexPhrases = field.indexPhrases();
        this.indexPrefixes = field.indexPrefixes().length > 0 ? field.indexPrefixes()[0] : null;
        this.norms = field.norms();
        this.nullValue = field.nullValue();
        this.nullValueType = field.nullValueType();
        this.positionIncrementGap = field.positionIncrementGap();
        this.similarity = field.similarity();
        this.termVector = field.termVector();
        this.scalingFactor = field.scalingFactor();
        this.maxShingleSize = field.maxShingleSize() >= 0 ? Integer.valueOf(field.maxShingleSize()) : null;
        Assert.isTrue((this.type != FieldType.Search_As_You_Type || this.maxShingleSize == null || this.maxShingleSize >= 2 && this.maxShingleSize <= 4 ? 1 : 0) != 0, (String)"maxShingleSize must be in inclusive range from 2 to 4 for field type search_as_you_type");
        this.positiveScoreImpact = field.positiveScoreImpact();
        this.dims = field.dims();
        if (this.type == FieldType.Dense_Vector) {
            Assert.isTrue((this.dims >= 1 && this.dims <= 4096 ? 1 : 0) != 0, (String)"Invalid required parameter! Dense_Vector value \"dims\" must be between 1 and 4096.");
        }
        this.elementType = field.elementType();
        this.knnSimilarity = field.knnSimilarity();
        this.knnIndexOptions = field.knnIndexOptions().length > 0 ? field.knnIndexOptions()[0] : null;
        this.enabled = true;
        this.eagerGlobalOrdinals = field.eagerGlobalOrdinals();
    }

    public boolean isStore() {
        return this.store;
    }

    public void writeTypeAndParametersTo(ObjectNode objectNode) throws IOException {
        Assert.notNull((Object)objectNode, (String)"objectNode must not be null");
        if (this.fielddata) {
            objectNode.put(FIELD_PARAM_DATA, this.fielddata);
        }
        if (this.type != FieldType.Auto) {
            objectNode.put(FIELD_PARAM_TYPE, this.mappedTypeName);
            if (this.type == FieldType.Date || this.type == FieldType.Date_Nanos || this.type == FieldType.Date_Range) {
                ArrayList<String> formats = new ArrayList<String>();
                for (DateFormat dateFormat : this.dateFormats) {
                    formats.add(dateFormat.toString());
                }
                Collections.addAll(formats, this.dateFormatPatterns);
                if (!formats.isEmpty()) {
                    objectNode.put(FIELD_PARAM_FORMAT, String.join((CharSequence)"||", formats));
                }
            }
        }
        if (!this.index) {
            objectNode.put(FIELD_PARAM_INDEX, this.index);
        }
        if (StringUtils.hasLength((String)this.analyzer)) {
            objectNode.put(FIELD_PARAM_INDEX_ANALYZER, this.analyzer);
        }
        if (StringUtils.hasLength((String)this.searchAnalyzer)) {
            objectNode.put(FIELD_PARAM_SEARCH_ANALYZER, this.searchAnalyzer);
        }
        if (StringUtils.hasLength((String)this.normalizer)) {
            objectNode.put(FIELD_PARAM_NORMALIZER, this.normalizer);
        }
        if (this.copyTo != null && this.copyTo.length > 0) {
            objectNode.putArray(FIELD_PARAM_COPY_TO).addAll((Collection)Arrays.stream(this.copyTo).map(TextNode::valueOf).collect(Collectors.toList()));
        }
        if (this.ignoreAbove != null) {
            Assert.isTrue((this.ignoreAbove >= 0 ? 1 : 0) != 0, (String)"ignore_above must be a positive value");
            objectNode.put(FIELD_PARAM_IGNORE_ABOVE, this.ignoreAbove);
        }
        if (!this.coerce) {
            objectNode.put(FIELD_PARAM_COERCE, this.coerce);
        }
        if (!this.docValues) {
            objectNode.put(FIELD_PARAM_DOC_VALUES, this.docValues);
        }
        if (this.ignoreMalformed) {
            objectNode.put(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (this.indexOptions != IndexOptions.none) {
            objectNode.put(FIELD_PARAM_INDEX_OPTIONS, this.indexOptions.toString());
        }
        if (this.indexPhrases) {
            objectNode.put(FIELD_PARAM_INDEX_PHRASES, this.indexPhrases);
        }
        if (this.indexPrefixes != null) {
            ObjectNode prefixNode = objectNode.putObject(FIELD_PARAM_INDEX_PREFIXES);
            if (this.indexPrefixes.minChars() != 2) {
                prefixNode.put(FIELD_PARAM_INDEX_PREFIXES_MIN_CHARS, this.indexPrefixes.minChars());
            }
            if (this.indexPrefixes.maxChars() != 2) {
                prefixNode.put(FIELD_PARAM_INDEX_PREFIXES_MAX_CHARS, this.indexPrefixes.maxChars());
            }
        }
        if (!this.norms) {
            objectNode.put(FIELD_PARAM_NORMS, this.norms);
        }
        if (StringUtils.hasLength((String)this.nullValue)) {
            switch (this.nullValueType) {
                case Integer: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Integer.valueOf(this.nullValue));
                    break;
                }
                case Long: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Long.valueOf(this.nullValue));
                    break;
                }
                case Double: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, Double.valueOf(this.nullValue));
                    break;
                }
                case String: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, this.nullValue);
                    break;
                }
                default: {
                    objectNode.put(FIELD_PARAM_NULL_VALUE, this.nullValue);
                }
            }
        }
        if (this.positionIncrementGap != null && this.positionIncrementGap >= 0) {
            objectNode.put(FIELD_PARAM_POSITION_INCREMENT_GAP, this.positionIncrementGap);
        }
        if (!"default".equals(this.similarity)) {
            objectNode.put(FIELD_PARAM_SIMILARITY, this.similarity);
            objectNode.put(FIELD_PARAM_INDEX, this.index);
        }
        if (this.termVector != TermVector.none) {
            objectNode.put(FIELD_PARAM_TERM_VECTOR, this.termVector.toString());
        }
        if (this.type == FieldType.Scaled_Float) {
            objectNode.put(FIELD_PARAM_SCALING_FACTOR, this.scalingFactor);
        }
        if (this.maxShingleSize != null) {
            objectNode.put(FIELD_PARAM_MAX_SHINGLE_SIZE, this.maxShingleSize);
        }
        if (!this.positiveScoreImpact) {
            objectNode.put(FIELD_PARAM_POSITIVE_SCORE_IMPACT, this.positiveScoreImpact);
        }
        if (this.type == FieldType.Dense_Vector) {
            objectNode.put(FIELD_PARAM_DIMS, this.dims);
            if (!"".equals(this.elementType)) {
                objectNode.put(FIELD_PARAM_ELEMENT_TYPE, this.elementType);
            }
            if (this.knnSimilarity != KnnSimilarity.DEFAULT) {
                objectNode.put(FIELD_PARAM_SIMILARITY, this.knnSimilarity.getSimilarity());
            }
            if (this.knnSimilarity != KnnSimilarity.DEFAULT) {
                Assert.isTrue((boolean)this.index, (String)"knn similarity can only be specified when 'index' is true.");
                objectNode.put(FIELD_PARAM_SIMILARITY, this.knnSimilarity.getSimilarity());
            }
            if (this.knnIndexOptions != null) {
                Assert.isTrue((boolean)this.index, (String)"knn index options can only be specified when 'index' is true.");
                ObjectNode indexOptionsNode = objectNode.putObject(FIELD_PARAM_INDEX_OPTIONS);
                KnnAlgorithmType algoType = this.knnIndexOptions.type();
                if (algoType != KnnAlgorithmType.DEFAULT) {
                    if (algoType == KnnAlgorithmType.INT8_HNSW || algoType == KnnAlgorithmType.INT8_FLAT) {
                        Assert.isTrue((!"byte".equals(this.elementType) ? 1 : 0) != 0, (String)"'element_type' can only be float when using vector quantization.");
                    }
                    indexOptionsNode.put(FIELD_PARAM_TYPE, algoType.getType());
                }
                if (this.knnIndexOptions.m() >= 0) {
                    Assert.isTrue((algoType == KnnAlgorithmType.HNSW || algoType == KnnAlgorithmType.INT8_HNSW ? 1 : 0) != 0, (String)"knn 'm' parameter can only be applicable to hnsw and int8_hnsw index types.");
                    indexOptionsNode.put(FIELD_PARAM_M, this.knnIndexOptions.m());
                }
                if (this.knnIndexOptions.efConstruction() >= 0) {
                    Assert.isTrue((algoType == KnnAlgorithmType.HNSW || algoType == KnnAlgorithmType.INT8_HNSW ? 1 : 0) != 0, (String)"knn 'ef_construction' can only be applicable to hnsw and int8_hnsw index types.");
                    indexOptionsNode.put(FIELD_PARAM_EF_CONSTRUCTION, this.knnIndexOptions.efConstruction());
                }
                if (this.knnIndexOptions.confidenceInterval() >= 0.0f) {
                    Assert.isTrue((algoType == KnnAlgorithmType.INT8_HNSW || algoType == KnnAlgorithmType.INT8_FLAT ? 1 : 0) != 0, (String)"knn 'confidence_interval' can only be applicable to int8_hnsw and int8_flat index types.");
                    indexOptionsNode.put(FIELD_PARAM_CONFIDENCE_INTERVAL, this.knnIndexOptions.confidenceInterval());
                }
            }
        }
        if (!this.enabled) {
            objectNode.put(FIELD_PARAM_ENABLED, this.enabled);
        }
        if (this.eagerGlobalOrdinals) {
            objectNode.put(FIELD_PARAM_EAGER_GLOBAL_ORDINALS, this.eagerGlobalOrdinals);
        }
    }
}

