/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.annotations.GeoShapeField;
import org.springframework.util.Assert;

final class GeoShapeMappingParameters {
    private static final String FIELD_PARAM_TYPE = "type";
    private static final String FIELD_PARAM_COERCE = "coerce";
    private static final String FIELD_PARAM_IGNORE_MALFORMED = "ignore_malformed";
    private static final String FIELD_PARAM_IGNORE_Z_VALUE = "ignore_z_value";
    private static final String FIELD_PARAM_ORIENTATION = "orientation";
    private static final String TYPE_VALUE_GEO_SHAPE = "geo_shape";
    private final boolean coerce;
    private final boolean ignoreMalformed;
    private final boolean ignoreZValue;
    private final GeoShapeField.Orientation orientation;

    public static GeoShapeMappingParameters from(@Nullable GeoShapeField annotation) {
        if (annotation == null) {
            return new GeoShapeMappingParameters(false, false, true, GeoShapeField.Orientation.ccw);
        }
        return new GeoShapeMappingParameters(annotation.coerce(), annotation.ignoreMalformed(), annotation.ignoreZValue(), annotation.orientation());
    }

    private GeoShapeMappingParameters(boolean coerce, boolean ignoreMalformed, boolean ignoreZValue, GeoShapeField.Orientation orientation) {
        this.coerce = coerce;
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
        this.orientation = orientation;
    }

    public boolean isCoerce() {
        return this.coerce;
    }

    public boolean isIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public boolean isIgnoreZValue() {
        return this.ignoreZValue;
    }

    public GeoShapeField.Orientation getOrientation() {
        return this.orientation;
    }

    public void writeTypeAndParametersTo(ObjectNode objectNode) throws IOException {
        Assert.notNull((Object)objectNode, (String)"objectNode must not be null");
        if (this.coerce) {
            objectNode.put(FIELD_PARAM_COERCE, this.coerce);
        }
        if (this.ignoreMalformed) {
            objectNode.put(FIELD_PARAM_IGNORE_MALFORMED, this.ignoreMalformed);
        }
        if (!this.ignoreZValue) {
            objectNode.put(FIELD_PARAM_IGNORE_Z_VALUE, this.ignoreZValue);
        }
        if (this.orientation != GeoShapeField.Orientation.ccw) {
            objectNode.put(FIELD_PARAM_ORIENTATION, this.orientation.name());
        }
        objectNode.put(FIELD_PARAM_TYPE, TYPE_VALUE_GEO_SHAPE);
    }
}

