/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.document;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;

public interface SearchDocument
extends Document {
    public float getScore();

    public Map<String, List<Object>> getFields();

    default public <V> @Nullable V getFieldValue(String name) {
        List<Object> values = this.getFields().get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (V)values.get(0);
    }

    default public <V> @Nullable List<V> getFieldValues(String name) {
        List<Object> values = this.getFields().get(name);
        if (values == null) {
            return null;
        }
        return values;
    }

    default public @Nullable Object[] getSortValues() {
        return null;
    }

    default public @Nullable Map<String, List<String>> getHighlightFields() {
        return null;
    }

    default public @Nullable Map<String, SearchDocumentResponse> getInnerHits() {
        return null;
    }

    default public @Nullable NestedMetaData getNestedMetaData() {
        return null;
    }

    default public @Nullable String getRouting() {
        return (String)this.getFieldValue("_routing");
    }

    public @Nullable Explanation getExplanation();

    public @Nullable Map<String, Double> getMatchedQueries();
}

