/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.util.Assert;

public class SearchHit<T> {
    private final @Nullable String index;
    private final @Nullable String id;
    private final float score;
    private final List<Object> sortValues;
    private final T content;
    private final Map<String, List<String>> highlightFields = new LinkedHashMap<String, List<String>>();
    private final Map<String, SearchHits<?>> innerHits = new LinkedHashMap();
    private final @Nullable NestedMetaData nestedMetaData;
    private final @Nullable String routing;
    private final @Nullable Explanation explanation;
    private final Map<String, Double> matchedQueries = new LinkedHashMap<String, Double>();

    public SearchHit(@Nullable String index, @Nullable String id, @Nullable String routing, float score, @Nullable Object[] sortValues, @Nullable Map<String, List<String>> highlightFields, @Nullable Map<String, SearchHits<?>> innerHits, @Nullable NestedMetaData nestedMetaData, @Nullable Explanation explanation, @Nullable Map<String, Double> matchedQueries, T content) {
        this.index = index;
        this.id = id;
        this.routing = routing;
        this.score = score;
        List<Object> list = this.sortValues = sortValues != null ? Arrays.asList(sortValues) : new ArrayList<Object>();
        if (highlightFields != null) {
            this.highlightFields.putAll(highlightFields);
        }
        if (innerHits != null) {
            this.innerHits.putAll(innerHits);
        }
        this.nestedMetaData = nestedMetaData;
        this.explanation = explanation;
        this.content = content;
        if (matchedQueries != null) {
            this.matchedQueries.putAll(matchedQueries);
        }
    }

    public @Nullable String getIndex() {
        return this.index;
    }

    public @Nullable String getId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public T getContent() {
        return this.content;
    }

    public List<Object> getSortValues() {
        return Collections.unmodifiableList(this.sortValues);
    }

    public Map<String, List<String>> getHighlightFields() {
        return Collections.unmodifiableMap(this.highlightFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue()))));
    }

    public List<String> getHighlightField(String field) {
        Assert.notNull((Object)field, (String)"field must not be null");
        return Collections.unmodifiableList(this.highlightFields.getOrDefault(field, Collections.emptyList()));
    }

    public @Nullable SearchHits<?> getInnerHits(String name) {
        return this.innerHits.get(name);
    }

    public Map<String, SearchHits<?>> getInnerHits() {
        return this.innerHits;
    }

    public @Nullable NestedMetaData getNestedMetaData() {
        return this.nestedMetaData;
    }

    public String toString() {
        return "SearchHit{id='" + this.id + "', score=" + this.score + ", sortValues=" + String.valueOf(this.sortValues) + ", content=" + String.valueOf(this.content) + ", highlightFields=" + String.valueOf(this.highlightFields) + "}";
    }

    public @Nullable String getRouting() {
        return this.routing;
    }

    public @Nullable Explanation getExplanation() {
        return this.explanation;
    }

    public @Nullable Map<String, Double> getMatchedQueries() {
        return this.matchedQueries;
    }
}

