/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.WaitForActiveShardOptions;
import co.elastic.clients.elasticsearch._types.mapping.FieldType;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldAndFormat;
import co.elastic.clients.elasticsearch._types.query_dsl.Like;
import co.elastic.clients.elasticsearch._types.query_dsl.MoreLikeThisQuery;
import co.elastic.clients.elasticsearch.cluster.DeleteComponentTemplateRequest;
import co.elastic.clients.elasticsearch.cluster.GetComponentTemplateRequest;
import co.elastic.clients.elasticsearch.cluster.HealthRequest;
import co.elastic.clients.elasticsearch.cluster.PutComponentTemplateRequest;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.ClosePointInTimeRequest;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.DeleteScriptRequest;
import co.elastic.clients.elasticsearch.core.ExistsRequest;
import co.elastic.clients.elasticsearch.core.GetRequest;
import co.elastic.clients.elasticsearch.core.GetScriptRequest;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.MgetRequest;
import co.elastic.clients.elasticsearch.core.MsearchRequest;
import co.elastic.clients.elasticsearch.core.MsearchTemplateRequest;
import co.elastic.clients.elasticsearch.core.OpenPointInTimeRequest;
import co.elastic.clients.elasticsearch.core.PutScriptRequest;
import co.elastic.clients.elasticsearch.core.ReindexRequest;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchTemplateRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.CreateOperation;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.elasticsearch.core.bulk.UpdateOperation;
import co.elastic.clients.elasticsearch.core.mget.MultiGetOperation;
import co.elastic.clients.elasticsearch.core.msearch.MultisearchHeader;
import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.Rescore;
import co.elastic.clients.elasticsearch.core.search.SearchRequestBody;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.elasticsearch.indices.Alias;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.ExistsRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexRequest;
import co.elastic.clients.elasticsearch.indices.GetIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.GetIndicesSettingsRequest;
import co.elastic.clients.elasticsearch.indices.GetMappingRequest;
import co.elastic.clients.elasticsearch.indices.GetTemplateRequest;
import co.elastic.clients.elasticsearch.indices.PutIndexTemplateRequest;
import co.elastic.clients.elasticsearch.indices.PutMappingRequest;
import co.elastic.clients.elasticsearch.indices.PutTemplateRequest;
import co.elastic.clients.elasticsearch.indices.RefreshRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.sql.QueryRequest;
import co.elastic.clients.elasticsearch.sql.query.SqlFormat;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.client.elc.AbstractQueryProcessor;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.client.elc.HighlightQueryBuilder;
import org.springframework.data.elasticsearch.client.elc.NativeQuery;
import org.springframework.data.elasticsearch.client.elc.Queries;
import org.springframework.data.elasticsearch.client.elc.TypeUtils;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.index.AliasAction;
import org.springframework.data.elasticsearch.core.index.AliasActionParameters;
import org.springframework.data.elasticsearch.core.index.AliasActions;
import org.springframework.data.elasticsearch.core.index.ComponentTemplateRequestData;
import org.springframework.data.elasticsearch.core.index.DeleteTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsComponentTemplateRequest;
import org.springframework.data.elasticsearch.core.index.ExistsTemplateRequest;
import org.springframework.data.elasticsearch.core.index.PutTemplateRequest;
import org.springframework.data.elasticsearch.core.mapping.Alias;
import org.springframework.data.elasticsearch.core.mapping.CreateIndexSettings;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BaseQuery;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.GeoDistanceOrder;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.RescorerQuery;
import org.springframework.data.elasticsearch.core.query.ScriptData;
import org.springframework.data.elasticsearch.core.query.SearchTemplateQuery;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.data.elasticsearch.core.query.SqlQuery;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.reindex.ReindexRequest;
import org.springframework.data.elasticsearch.core.reindex.Remote;
import org.springframework.data.elasticsearch.core.script.Script;
import org.springframework.data.elasticsearch.support.DefaultStringObjectMap;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class RequestConverter
extends AbstractQueryProcessor {
    private static final Log LOGGER = LogFactory.getLog(RequestConverter.class);
    protected final JsonpMapper jsonpMapper;
    protected final ElasticsearchConverter elasticsearchConverter;

    public RequestConverter(ElasticsearchConverter elasticsearchConverter, JsonpMapper jsonpMapper) {
        this.elasticsearchConverter = elasticsearchConverter;
        Assert.notNull((Object)jsonpMapper, (String)"jsonpMapper must not be null");
        this.jsonpMapper = jsonpMapper;
    }

    public HealthRequest clusterHealthRequest() {
        return new HealthRequest.Builder().build();
    }

    public PutComponentTemplateRequest clusterPutComponentTemplateRequest(org.springframework.data.elasticsearch.core.index.PutComponentTemplateRequest putComponentTemplateRequest) {
        Assert.notNull((Object)putComponentTemplateRequest, (String)"putComponentTemplateRequest must not be null");
        return PutComponentTemplateRequest.of(b -> b.name(putComponentTemplateRequest.name()).create(putComponentTemplateRequest.create()).version(putComponentTemplateRequest.version()).masterTimeout(TypeUtils.time(putComponentTemplateRequest.masterTimeout())).template(isb -> {
            ComponentTemplateRequestData componentTemplateData = putComponentTemplateRequest.template();
            isb.mappings(TypeUtils.typeMapping(componentTemplateData.mapping())).settings(TypeUtils.indexSettings(componentTemplateData.settings()));
            AliasActions aliasActions = componentTemplateData.aliasActions();
            if (aliasActions != null) {
                aliasActions.getActions().forEach(aliasAction -> {
                    AliasAction.Add add;
                    AliasActionParameters parameters;
                    String[] parametersAliases;
                    if (aliasAction instanceof AliasAction.Add && (parametersAliases = (parameters = (add = (AliasAction.Add)aliasAction).getParameters()).getAliases()) != null) {
                        for (String aliasName : parametersAliases) {
                            isb.aliases(aliasName, aliasBuilder -> this.buildAlias(parameters, (Alias.Builder)aliasBuilder));
                        }
                    }
                });
            }
            return isb;
        }));
    }

    private Alias.Builder buildAlias(AliasActionParameters parameters, Alias.Builder aliasBuilder) {
        co.elastic.clients.elasticsearch._types.query_dsl.Query esQuery;
        Query filterQuery;
        if (parameters.getRouting() != null) {
            aliasBuilder.routing(parameters.getRouting());
        }
        if (parameters.getIndexRouting() != null) {
            aliasBuilder.indexRouting(parameters.getIndexRouting());
        }
        if (parameters.getSearchRouting() != null) {
            aliasBuilder.searchRouting(parameters.getSearchRouting());
        }
        if (parameters.getHidden() != null) {
            aliasBuilder.isHidden(parameters.getHidden());
        }
        if (parameters.getWriteIndex() != null) {
            aliasBuilder.isWriteIndex(parameters.getWriteIndex());
        }
        if ((filterQuery = parameters.getFilterQuery()) != null && (esQuery = this.getQuery(filterQuery, null)) != null) {
            aliasBuilder.filter(esQuery);
        }
        return aliasBuilder;
    }

    public co.elastic.clients.elasticsearch.cluster.ExistsComponentTemplateRequest clusterExistsComponentTemplateRequest(ExistsComponentTemplateRequest existsComponentTemplateRequest) {
        Assert.notNull((Object)existsComponentTemplateRequest, (String)"existsComponentTemplateRequest must not be null");
        return co.elastic.clients.elasticsearch.cluster.ExistsComponentTemplateRequest.of(b -> b.name(existsComponentTemplateRequest.templateName(), new String[0]));
    }

    public GetComponentTemplateRequest clusterGetComponentTemplateRequest(org.springframework.data.elasticsearch.core.index.GetComponentTemplateRequest getComponentTemplateRequest) {
        Assert.notNull((Object)getComponentTemplateRequest, (String)"getComponentTemplateRequest must not be null");
        return GetComponentTemplateRequest.of(b -> b.name(getComponentTemplateRequest.templateName()));
    }

    public DeleteComponentTemplateRequest clusterDeleteComponentTemplateRequest(org.springframework.data.elasticsearch.core.index.DeleteComponentTemplateRequest deleteComponentTemplateRequest) {
        return DeleteComponentTemplateRequest.of(b -> b.name(deleteComponentTemplateRequest.templateName(), new String[0]));
    }

    public co.elastic.clients.elasticsearch.indices.ExistsRequest indicesExistsRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new ExistsRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public CreateIndexRequest indicesCreateRequest(CreateIndexSettings indexSettings) {
        HashMap<String, co.elastic.clients.elasticsearch.indices.Alias> aliases = new HashMap<String, co.elastic.clients.elasticsearch.indices.Alias>();
        for (Alias alias : indexSettings.getAliases()) {
            co.elastic.clients.elasticsearch.indices.Alias esAlias = co.elastic.clients.elasticsearch.indices.Alias.of(ab -> ab.filter(this.getQuery(alias.getFilter(), null)).routing(alias.getRouting()).indexRouting(alias.getIndexRouting()).searchRouting(alias.getSearchRouting()).isHidden(alias.getHidden()).isWriteIndex(alias.getWriteIndex()));
            aliases.put(alias.getAlias(), esAlias);
        }
        return new CreateIndexRequest.Builder().index(indexSettings.getIndexCoordinates().getIndexName()).aliases(aliases).settings(TypeUtils.indexSettings(indexSettings.getSettings())).mappings(TypeUtils.typeMapping(indexSettings.getMapping())).build();
    }

    public RefreshRequest indicesRefreshRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new RefreshRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public DeleteIndexRequest indicesDeleteRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new DeleteIndexRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public UpdateAliasesRequest indicesUpdateAliasesRequest(AliasActions aliasActions) {
        Assert.notNull((Object)aliasActions, (String)"aliasActions must not be null");
        UpdateAliasesRequest.Builder updateAliasRequestBuilder = new UpdateAliasesRequest.Builder();
        ArrayList actions = new ArrayList();
        aliasActions.getActions().forEach(aliasAction -> {
            AliasActionParameters parameters;
            Action.Builder actionBuilder = this.getBuilder((AliasAction)aliasAction);
            if (aliasAction instanceof AliasAction.Remove) {
                AliasAction.Remove remove = (AliasAction.Remove)aliasAction;
                parameters = remove.getParameters();
                actionBuilder.remove(removeActionBuilder -> {
                    removeActionBuilder.indices(Arrays.asList(parameters.getIndices()));
                    if (parameters.getAliases() != null) {
                        removeActionBuilder.aliases(Arrays.asList(parameters.getAliases()));
                    }
                    return removeActionBuilder;
                });
            }
            if (aliasAction instanceof AliasAction.RemoveIndex) {
                AliasAction.RemoveIndex removeIndex = (AliasAction.RemoveIndex)aliasAction;
                parameters = removeIndex.getParameters();
                actionBuilder.removeIndex(removeIndexActionBuilder -> removeIndexActionBuilder.indices(Arrays.asList(parameters.getIndices())));
            }
            actions.add(actionBuilder.build());
        });
        updateAliasRequestBuilder.actions(actions);
        return updateAliasRequestBuilder.build();
    }

    private Action.Builder getBuilder(AliasAction aliasAction) {
        Action.Builder actionBuilder = new Action.Builder();
        if (aliasAction instanceof AliasAction.Add) {
            AliasAction.Add add = (AliasAction.Add)aliasAction;
            AliasActionParameters parameters = add.getParameters();
            actionBuilder.add(addActionBuilder -> {
                Query filterQuery;
                addActionBuilder.indices(Arrays.asList(parameters.getIndices())).isHidden(parameters.getHidden()).isWriteIndex(parameters.getWriteIndex()).routing(parameters.getRouting()).indexRouting(parameters.getIndexRouting()).searchRouting(parameters.getSearchRouting());
                if (parameters.getAliases() != null) {
                    addActionBuilder.aliases(Arrays.asList(parameters.getAliases()));
                }
                if ((filterQuery = parameters.getFilterQuery()) != null) {
                    this.elasticsearchConverter.updateQuery(filterQuery, parameters.getFilterQueryClass());
                    co.elastic.clients.elasticsearch._types.query_dsl.Query esQuery = this.getQuery(filterQuery, null);
                    if (esQuery != null) {
                        addActionBuilder.filter(esQuery);
                    }
                }
                return addActionBuilder;
            });
        }
        return actionBuilder;
    }

    public PutMappingRequest indicesPutMappingRequest(IndexCoordinates indexCoordinates, Document mapping) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        Assert.notNull((Object)mapping, (String)"mapping must not be null");
        return ((PutMappingRequest.Builder)new PutMappingRequest.Builder().withJson((Reader)new StringReader(mapping.toJson()))).index(Arrays.asList(indexCoordinates.getIndexNames())).build();
    }

    public GetMappingRequest indicesGetMappingRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetMappingRequest.Builder().index(List.of(indexCoordinates.getIndexNames())).build();
    }

    public GetIndicesSettingsRequest indicesGetSettingsRequest(IndexCoordinates indexCoordinates, boolean includeDefaults) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetIndicesSettingsRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).includeDefaults(Boolean.valueOf(includeDefaults)).build();
    }

    public GetIndexRequest indicesGetIndexRequest(IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return new GetIndexRequest.Builder().index(Arrays.asList(indexCoordinates.getIndexNames())).includeDefaults(Boolean.valueOf(true)).build();
    }

    public GetAliasRequest indicesGetAliasRequest(@Nullable String[] aliasNames, @Nullable String[] indexNames) {
        GetAliasRequest.Builder builder = new GetAliasRequest.Builder();
        if (aliasNames != null) {
            builder.name(Arrays.asList(aliasNames));
        }
        if (indexNames != null) {
            builder.index(Arrays.asList(indexNames));
        }
        return builder.build();
    }

    public co.elastic.clients.elasticsearch.indices.PutTemplateRequest indicesPutTemplateRequest(PutTemplateRequest putTemplateRequest) {
        AliasActions aliasActions;
        Assert.notNull((Object)putTemplateRequest, (String)"putTemplateRequest must not be null");
        PutTemplateRequest.Builder builder = new PutTemplateRequest.Builder();
        builder.name(putTemplateRequest.getName()).indexPatterns(Arrays.asList(putTemplateRequest.getIndexPatterns())).order(Integer.valueOf(putTemplateRequest.getOrder()));
        if (putTemplateRequest.getSettings() != null) {
            Map<String, JsonData> settings = this.getTemplateParams(putTemplateRequest.getSettings().entrySet());
            builder.settings(sb -> sb.otherSettings(settings));
        }
        if (putTemplateRequest.getMappings() != null) {
            builder.mappings(TypeUtils.typeMapping(putTemplateRequest.getMappings()));
        }
        if (putTemplateRequest.getVersion() != null) {
            builder.version(Long.valueOf(putTemplateRequest.getVersion().intValue()));
        }
        if ((aliasActions = putTemplateRequest.getAliasActions()) != null) {
            aliasActions.getActions().forEach(aliasAction -> {
                AliasActionParameters parameters = aliasAction.getParameters();
                String[] parametersAliases = parameters.getAliases();
                if (parametersAliases != null) {
                    for (String aliasName : parametersAliases) {
                        builder.aliases(aliasName, aliasBuilder -> this.buildAlias(parameters, (Alias.Builder)aliasBuilder));
                    }
                }
            });
        }
        return builder.build();
    }

    public PutIndexTemplateRequest indicesPutIndexTemplateRequest(org.springframework.data.elasticsearch.core.index.PutIndexTemplateRequest putIndexTemplateRequest) {
        Assert.notNull((Object)putIndexTemplateRequest, (String)"putIndexTemplateRequest must not be null");
        PutIndexTemplateRequest.Builder builder = new PutIndexTemplateRequest.Builder().name(putIndexTemplateRequest.name()).indexPatterns(Arrays.asList(putIndexTemplateRequest.indexPatterns())).template(t -> {
            t.settings(TypeUtils.indexSettings(putIndexTemplateRequest.settings())).mappings(TypeUtils.typeMapping(putIndexTemplateRequest.mapping()));
            AliasActions aliasActions = putIndexTemplateRequest.aliasActions();
            if (aliasActions != null) {
                aliasActions.getActions().forEach(aliasAction -> {
                    AliasAction.Add add;
                    AliasActionParameters parameters;
                    String[] parametersAliases;
                    if (aliasAction instanceof AliasAction.Add && (parametersAliases = (parameters = (add = (AliasAction.Add)aliasAction).getParameters()).getAliases()) != null) {
                        for (String aliasName : parametersAliases) {
                            t.aliases(aliasName, aliasBuilder -> this.buildAlias(parameters, (Alias.Builder)aliasBuilder));
                        }
                    }
                });
            }
            return t;
        });
        if (!putIndexTemplateRequest.composedOf().isEmpty()) {
            builder.composedOf(putIndexTemplateRequest.composedOf());
        }
        return builder.build();
    }

    public ExistsIndexTemplateRequest indicesExistsIndexTemplateRequest(org.springframework.data.elasticsearch.core.index.ExistsIndexTemplateRequest existsIndexTemplateRequest) {
        Assert.notNull((Object)existsIndexTemplateRequest, (String)"existsIndexTemplateRequest must not be null");
        return ExistsIndexTemplateRequest.of(b -> b.name(existsIndexTemplateRequest.templateName()));
    }

    public co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest indicesExistsTemplateRequest(ExistsTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        return co.elastic.clients.elasticsearch.indices.ExistsTemplateRequest.of(etr -> etr.name(existsTemplateRequest.getTemplateName(), new String[0]));
    }

    public GetIndexTemplateRequest indicesGetIndexTemplateRequest(org.springframework.data.elasticsearch.core.index.GetIndexTemplateRequest getIndexTemplateRequest) {
        Assert.notNull((Object)getIndexTemplateRequest, (String)"getIndexTemplateRequest must not be null");
        return GetIndexTemplateRequest.of(gitr -> gitr.name(getIndexTemplateRequest.templateName()));
    }

    public DeleteIndexTemplateRequest indicesDeleteIndexTemplateRequest(org.springframework.data.elasticsearch.core.index.DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        Assert.notNull((Object)deleteIndexTemplateRequest, (String)"deleteIndexTemplateRequest must not be null");
        return DeleteIndexTemplateRequest.of(ditr -> ditr.name(deleteIndexTemplateRequest.templateName(), new String[0]));
    }

    public co.elastic.clients.elasticsearch.indices.DeleteTemplateRequest indicesDeleteTemplateRequest(DeleteTemplateRequest existsTemplateRequest) {
        Assert.notNull((Object)existsTemplateRequest, (String)"existsTemplateRequest must not be null");
        return co.elastic.clients.elasticsearch.indices.DeleteTemplateRequest.of(dtr -> dtr.name(existsTemplateRequest.getTemplateName()));
    }

    public GetTemplateRequest indicesGetTemplateRequest(org.springframework.data.elasticsearch.core.index.GetTemplateRequest getTemplateRequest) {
        Assert.notNull((Object)getTemplateRequest, (String)"getTemplateRequest must not be null");
        return GetTemplateRequest.of(gtr -> gtr.name(getTemplateRequest.getTemplateName(), new String[0]).flatSettings(Boolean.valueOf(true)));
    }

    public QueryRequest sqlQueryRequest(SqlQuery query) {
        Assert.notNull((Object)query, (String)"Query must not be null.");
        return QueryRequest.of(sqb -> sqb.query(query.getQuery()).catalog(query.getCatalog()).columnar(query.getColumnar()).cursor(query.getCursor()).fetchSize(query.getFetchSize()).fieldMultiValueLeniency(query.getFieldMultiValueLeniency()).indexUsingFrozen(query.getIndexIncludeFrozen()).keepAlive(TypeUtils.time(query.getKeepAlive())).keepOnCompletion(query.getKeepOnCompletion()).pageTimeout(TypeUtils.time(query.getPageTimeout())).requestTimeout(TypeUtils.time(query.getRequestTimeout())).waitForCompletionTimeout(TypeUtils.time(query.getWaitForCompletionTimeout())).filter(this.getQuery(query.getFilter(), null)).timeZone(Objects.toString(query.getTimeZone(), null)).format(SqlFormat.Json));
    }

    public IndexRequest<?> documentIndexRequest(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        IndexRequest.Builder builder = new IndexRequest.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            builder.id(StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject)).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            builder.id(query.getId()).document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            builder.version(query.getVersion()).versionType(versionType);
        }
        builder.ifSeqNo(query.getSeqNo()).ifPrimaryTerm(query.getPrimaryTerm()).routing(query.getRouting());
        if (query.getOpType() != null) {
            switch (query.getOpType()) {
                case INDEX: {
                    builder.opType(OpType.Index);
                    break;
                }
                case CREATE: {
                    builder.opType(OpType.Create);
                }
            }
        }
        builder.refresh(TypeUtils.refresh(refreshPolicy));
        return builder.build();
    }

    private IndexOperation<?> bulkIndexOperation(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        IndexOperation.Builder builder = new IndexOperation.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            ((IndexOperation.Builder)builder.id(StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject))).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            ((IndexOperation.Builder)builder.id(query.getId())).document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            ((IndexOperation.Builder)builder.version(query.getVersion())).versionType(versionType);
        }
        ((IndexOperation.Builder)((IndexOperation.Builder)builder.ifSeqNo(query.getSeqNo())).ifPrimaryTerm(query.getPrimaryTerm())).routing(query.getRouting());
        return builder.build();
    }

    private CreateOperation<?> bulkCreateOperation(IndexQuery query, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        CreateOperation.Builder builder = new CreateOperation.Builder();
        builder.index(query.getIndexName() != null ? query.getIndexName() : indexCoordinates.getIndexName());
        Object queryObject = query.getObject();
        if (queryObject != null) {
            ((CreateOperation.Builder)builder.id(StringUtils.hasText((String)query.getId()) ? query.getId() : this.getPersistentEntityId(queryObject))).document((Object)this.elasticsearchConverter.mapObject(queryObject));
        } else if (query.getSource() != null) {
            ((CreateOperation.Builder)builder.id(query.getId())).document(new DefaultStringObjectMap().fromJson(query.getSource()));
        } else {
            throw new InvalidDataAccessApiUsageException("object or source is null, failed to index the document [id: " + query.getId() + "]");
        }
        if (query.getVersion() != null) {
            VersionType versionType = this.retrieveVersionTypeFromPersistentEntity(queryObject != null ? queryObject.getClass() : null);
            ((CreateOperation.Builder)builder.version(query.getVersion())).versionType(versionType);
        }
        ((CreateOperation.Builder)((CreateOperation.Builder)builder.ifSeqNo(query.getSeqNo())).ifPrimaryTerm(query.getPrimaryTerm())).routing(query.getRouting());
        return builder.build();
    }

    private UpdateOperation<?, ?> bulkUpdateOperation(UpdateQuery query, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        UpdateOperation.Builder uob = new UpdateOperation.Builder();
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        ((UpdateOperation.Builder)uob.index(indexName)).id(query.getId());
        uob.action(a -> {
            a.script(this.getScript(query.getScriptData())).doc((Object)query.getDocument()).upsert((Object)query.getUpsert()).scriptedUpsert(query.getScriptedUpsert()).docAsUpsert(query.getDocAsUpsert());
            if (query.getFetchSource() != null) {
                a.source(sc -> sc.fetch(query.getFetchSource()));
            }
            if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
                List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
                List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
                a.source(sc -> sc.filter(sf -> sf.includes(includes).excludes(excludes)));
            }
            return a;
        });
        ((UpdateOperation.Builder)((UpdateOperation.Builder)((UpdateOperation.Builder)uob.routing(query.getRouting())).ifSeqNo(query.getIfSeqNo())).ifPrimaryTerm(query.getIfPrimaryTerm())).retryOnConflict(query.getRetryOnConflict());
        return uob.build();
    }

    private @Nullable co.elastic.clients.elasticsearch._types.Script getScript(@Nullable ScriptData scriptData) {
        if (scriptData == null) {
            return null;
        }
        HashMap params = new HashMap();
        if (scriptData.params() != null) {
            scriptData.params().forEach((key, value) -> params.put(key, JsonData.of((Object)value, (JsonpMapper)this.jsonpMapper)));
        }
        return co.elastic.clients.elasticsearch._types.Script.of(sb -> {
            sb.lang(scriptData.language()).params(params).id(scriptData.scriptName());
            if (scriptData.script() != null) {
                sb.source(s -> s.scriptString(scriptData.script()));
            }
            return sb;
        });
    }

    public BulkRequest documentBulkRequest(List<?> queries, BulkOptions bulkOptions, IndexCoordinates indexCoordinates, @Nullable RefreshPolicy refreshPolicy) {
        BulkRequest.Builder builder = new BulkRequest.Builder();
        if (bulkOptions.getTimeout() != null) {
            builder.timeout(tb -> tb.time(Long.valueOf(bulkOptions.getTimeout().toMillis()).toString() + "ms"));
        }
        builder.refresh(TypeUtils.refresh(refreshPolicy));
        if (bulkOptions.getRefreshPolicy() != null) {
            builder.refresh(TypeUtils.refresh(bulkOptions.getRefreshPolicy()));
        }
        if (bulkOptions.getWaitForActiveShards() != null) {
            builder.waitForActiveShards(wasb -> wasb.count(Integer.valueOf(bulkOptions.getWaitForActiveShards().value())));
        }
        if (bulkOptions.getPipeline() != null) {
            builder.pipeline(bulkOptions.getPipeline());
        }
        if (bulkOptions.getRoutingId() != null) {
            builder.routing(bulkOptions.getRoutingId());
        }
        List operations = queries.stream().map(query -> {
            BulkOperation.Builder ob = new BulkOperation.Builder();
            if (query instanceof IndexQuery) {
                IndexQuery indexQuery = (IndexQuery)query;
                if (indexQuery.getOpType() == IndexQuery.OpType.CREATE) {
                    ob.create(this.bulkCreateOperation(indexQuery, indexCoordinates, refreshPolicy));
                } else {
                    ob.index(this.bulkIndexOperation(indexQuery, indexCoordinates, refreshPolicy));
                }
            } else if (query instanceof UpdateQuery) {
                UpdateQuery updateQuery = (UpdateQuery)query;
                ob.update(this.bulkUpdateOperation(updateQuery, indexCoordinates, refreshPolicy));
            }
            return ob.build();
        }).collect(Collectors.toList());
        builder.operations(operations);
        return builder.build();
    }

    public GetRequest documentGetRequest(String id, @Nullable String routing, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return GetRequest.of(grb -> grb.index(indexCoordinates.getIndexName()).id(id).routing(routing));
    }

    public ExistsRequest documentExistsRequest(String id, @Nullable String routing, IndexCoordinates indexCoordinates) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        return ExistsRequest.of(erb -> erb.index(indexCoordinates.getIndexName()).id(id).routing(routing));
    }

    public <T> MgetRequest documentMgetRequest(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        if (query.getIdsWithRouting().isEmpty()) {
            throw new IllegalArgumentException("query does not contain any ids");
        }
        this.elasticsearchConverter.updateQuery(query, clazz);
        SourceConfig sourceConfig = this.getSourceConfig(query);
        List multiGetOperations = query.getIdsWithRouting().stream().map(idWithRouting -> MultiGetOperation.of(mgo -> mgo.index(index.getIndexName()).id(idWithRouting.id()).routing(idWithRouting.routing()).source(sourceConfig))).collect(Collectors.toList());
        return MgetRequest.of(mg -> mg.docs(multiGetOperations));
    }

    public ReindexRequest reindex(org.springframework.data.elasticsearch.core.reindex.ReindexRequest reindexRequest, boolean waitForCompletion) {
        ReindexRequest.Script script;
        Assert.notNull((Object)reindexRequest, (String)"reindexRequest must not be null");
        ReindexRequest.Builder builder = new ReindexRequest.Builder();
        builder.source(s -> {
            SourceFilter sourceFilter;
            ReindexRequest.Source source = reindexRequest.getSource();
            s.index(Arrays.asList(source.getIndexes().getIndexNames())).size(source.getSize());
            ReindexRequest.Slice slice = source.getSlice();
            if (slice != null) {
                s.slice(sl -> sl.id(String.valueOf(slice.getId())).max(slice.getMax()));
            }
            if (source.getQuery() != null) {
                s.query(this.getQuery(source.getQuery(), null));
            }
            if (source.getRemote() != null) {
                Remote remote = source.getRemote();
                s.remote(rs -> {
                    StringBuilder sb = new StringBuilder(remote.getScheme());
                    sb.append("://");
                    sb.append(remote.getHost());
                    sb.append(':');
                    sb.append(remote.getPort());
                    if (remote.getPathPrefix() != null) {
                        sb.append(remote.getPathPrefix());
                    }
                    String socketTimeoutSecs = remote.getSocketTimeout() != null ? remote.getSocketTimeout().getSeconds() + "s" : "30s";
                    String connectTimeoutSecs = remote.getConnectTimeout() != null ? remote.getConnectTimeout().getSeconds() + "s" : "30s";
                    return rs.host(sb.toString()).username(remote.getUsername()).password(remote.getPassword()).socketTimeout(tv -> tv.time(socketTimeoutSecs)).connectTimeout(tv -> tv.time(connectTimeoutSecs));
                });
            }
            if ((sourceFilter = source.getSourceFilter()) != null && sourceFilter.getIncludes() != null) {
                s.sourceFields(Arrays.asList(sourceFilter.getIncludes()));
            }
            return s;
        }).dest(d -> {
            ReindexRequest.Dest dest = reindexRequest.getDest();
            return d.index(dest.getIndex().getIndexName()).versionType(TypeUtils.versionType(dest.getVersionType())).opType(TypeUtils.opType(dest.getOpType()));
        });
        if (reindexRequest.getConflicts() != null) {
            builder.conflicts(TypeUtils.conflicts(reindexRequest.getConflicts()));
        }
        if ((script = reindexRequest.getScript()) != null) {
            builder.script(sb -> {
                if (script.getSource() != null) {
                    sb.source(s -> s.scriptString(script.getSource()));
                }
                sb.lang(script.getLang());
                return sb;
            });
        }
        builder.timeout(TypeUtils.time(reindexRequest.getTimeout())).scroll(TypeUtils.time(reindexRequest.getScroll()));
        if (reindexRequest.getWaitForActiveShards() != null) {
            builder.waitForActiveShards(wfas -> wfas.count(TypeUtils.waitForActiveShardsCount(reindexRequest.getWaitForActiveShards())));
        }
        builder.maxDocs(reindexRequest.getMaxDocs()).waitForCompletion(Boolean.valueOf(waitForCompletion)).refresh(reindexRequest.getRefresh()).requireAlias(reindexRequest.getRequireAlias()).requestsPerSecond(TypeUtils.toFloat(reindexRequest.getRequestsPerSecond())).slices(TypeUtils.slices(reindexRequest.getSlices()));
        return builder.build();
    }

    public DeleteRequest documentDeleteRequest(String id, @Nullable String routing, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return DeleteRequest.of(r -> {
            r.id(id).index(index.getIndexName());
            if (routing != null) {
                r.routing(routing);
            }
            r.refresh(TypeUtils.refresh(refreshPolicy));
            return r;
        });
    }

    public DeleteByQueryRequest documentDeleteByQueryRequest(Query query, @Nullable String routing, Class<?> clazz, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return DeleteByQueryRequest.of(b -> {
            b.index(Arrays.asList(index.getIndexNames())).query(this.getQuery(query, clazz)).refresh(RequestConverter.deleteByQueryRefresh(refreshPolicy));
            if (query.isLimiting()) {
                b.maxDocs(Long.valueOf(query.getMaxResults().intValue()));
            }
            b.scroll(TypeUtils.time(query.getScrollTime()));
            if (query.getRoute() != null) {
                b.routing(query.getRoute());
            } else if (StringUtils.hasText((String)routing)) {
                b.routing(routing);
            }
            return b;
        });
    }

    public DeleteByQueryRequest documentDeleteByQueryRequest(DeleteQuery query, @Nullable String routing, Class<?> clazz, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return DeleteByQueryRequest.of(dqb -> {
            dqb.index(Arrays.asList(index.getIndexNames())).query(this.getQuery(query.getQuery(), clazz)).refresh(RequestConverter.deleteByQueryRefresh(refreshPolicy)).requestsPerSecond(query.getRequestsPerSecond()).maxDocs(query.getMaxDocs()).scroll(TypeUtils.time(query.getScroll())).scrollSize(query.getScrollSize());
            if (query.getRouting() != null) {
                dqb.routing(query.getRouting());
            } else if (StringUtils.hasText((String)routing)) {
                dqb.routing(routing);
            }
            if (query.getQ() != null) {
                dqb.q(query.getQ()).analyzer(query.getAnalyzer()).analyzeWildcard(query.getAnalyzeWildcard()).defaultOperator(TypeUtils.operator(query.getDefaultOperator())).df(query.getDf()).lenient(query.getLenient());
            }
            if (query.getExpandWildcards() != null && !query.getExpandWildcards().isEmpty()) {
                dqb.expandWildcards(TypeUtils.expandWildcards(query.getExpandWildcards()));
            }
            if (query.getStats() != null && !query.getStats().isEmpty()) {
                dqb.stats(query.getStats());
            }
            if (query.getSlices() != null) {
                dqb.slices(sb -> sb.value(query.getSlices()));
            }
            if (query.getSort() != null) {
                ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(clazz);
                List<SortOptions> sortOptions = this.getSortOptions(query.getSort(), persistentEntity);
                if (!sortOptions.isEmpty()) {
                    dqb.sort(sortOptions);
                }
            }
            if (query.getRefresh() != null) {
                dqb.refresh(query.getRefresh());
            }
            dqb.allowNoIndices(query.getAllowNoIndices()).conflicts(TypeUtils.conflicts(query.getConflicts())).ignoreUnavailable(query.getIgnoreUnavailable()).preference(query.getPreference()).requestCache(query.getRequestCache()).searchType(TypeUtils.searchType(query.getSearchType())).searchTimeout(TypeUtils.time(query.getSearchTimeout())).terminateAfter(query.getTerminateAfter()).timeout(TypeUtils.time(query.getTimeout())).version(query.getVersion());
            return dqb;
        });
    }

    public UpdateRequest<Document, ?> documentUpdateRequest(UpdateQuery query, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy, @Nullable String routing) {
        String indexName = query.getIndexName() != null ? query.getIndexName() : index.getIndexName();
        return UpdateRequest.of(uqb -> {
            String waitForActiveShards;
            uqb.index(indexName).id(query.getId());
            if (query.getScript() != null) {
                HashMap params = new HashMap();
                if (query.getParams() != null) {
                    query.getParams().forEach((key, value) -> params.put(key, JsonData.of((Object)value, (JsonpMapper)this.jsonpMapper)));
                }
                uqb.script(sb -> {
                    sb.lang(query.getLang()).params(params);
                    if (query.getScript() != null) {
                        sb.source(s -> s.scriptString(query.getScript()));
                    }
                    sb.id(query.getId());
                    return sb;
                });
            }
            uqb.doc((Object)query.getDocument()).upsert((Object)query.getUpsert()).routing(query.getRouting() != null ? query.getRouting() : routing).scriptedUpsert(query.getScriptedUpsert()).docAsUpsert(query.getDocAsUpsert()).ifSeqNo(query.getIfSeqNo()).ifPrimaryTerm(query.getIfPrimaryTerm()).refresh(query.getRefreshPolicy() != null ? TypeUtils.refresh(query.getRefreshPolicy()) : TypeUtils.refresh(refreshPolicy)).retryOnConflict(query.getRetryOnConflict());
            if (query.getFetchSource() != null) {
                uqb.source(sc -> sc.fetch(query.getFetchSource()));
            }
            if (query.getFetchSourceIncludes() != null || query.getFetchSourceExcludes() != null) {
                List<Object> includes = query.getFetchSourceIncludes() != null ? query.getFetchSourceIncludes() : Collections.emptyList();
                List<Object> excludes = query.getFetchSourceExcludes() != null ? query.getFetchSourceExcludes() : Collections.emptyList();
                uqb.source(sc -> sc.filter(sf -> sf.includes(includes).excludes(excludes)));
            }
            if (query.getTimeout() != null) {
                uqb.timeout(tv -> tv.time(query.getTimeout()));
            }
            if ((waitForActiveShards = query.getWaitForActiveShards()) != null) {
                if ("all".equalsIgnoreCase(waitForActiveShards)) {
                    uqb.waitForActiveShards(wfa -> wfa.option(WaitForActiveShardOptions.All));
                } else {
                    int val;
                    try {
                        val = Integer.parseInt(waitForActiveShards);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("cannot parse ActiveShardCount[" + waitForActiveShards + "]", e);
                    }
                    uqb.waitForActiveShards(wfa -> wfa.count(Integer.valueOf(val)));
                }
            }
            return uqb;
        });
    }

    public UpdateByQueryRequest documentUpdateByQueryRequest(UpdateQuery updateQuery, IndexCoordinates index, @Nullable RefreshPolicy refreshPolicy) {
        return UpdateByQueryRequest.of(ub -> {
            ub.index(Arrays.asList(index.getIndexNames())).refresh(Boolean.valueOf(refreshPolicy == RefreshPolicy.IMMEDIATE)).routing(updateQuery.getRouting()).script(this.getScript(updateQuery.getScriptData())).maxDocs(updateQuery.getMaxDocs() != null ? Long.valueOf(updateQuery.getMaxDocs().intValue()) : null).pipeline(updateQuery.getPipeline()).requestsPerSecond(updateQuery.getRequestsPerSecond()).slices(TypeUtils.slices(updateQuery.getSlices() != null ? Long.valueOf(updateQuery.getSlices().intValue()) : null));
            if (updateQuery.getAbortOnVersionConflict() != null) {
                ub.conflicts(updateQuery.getAbortOnVersionConflict() != false ? Conflicts.Abort : Conflicts.Proceed);
            }
            if (updateQuery.getQuery() != null) {
                Query queryQuery = updateQuery.getQuery();
                if (updateQuery.getBatchSize() != null) {
                    ((BaseQuery)queryQuery).setMaxResults(updateQuery.getBatchSize());
                }
                ub.query(this.getQuery(queryQuery, null));
                ub.scroll(TypeUtils.time(queryQuery.getScrollTime()));
            }
            if (updateQuery.getRefreshPolicy() != null) {
                ub.refresh(Boolean.valueOf(updateQuery.getRefreshPolicy() == RefreshPolicy.IMMEDIATE));
            }
            if (updateQuery.getTimeout() != null) {
                ub.timeout(tb -> tb.time(updateQuery.getTimeout()));
            }
            if (updateQuery.getWaitForActiveShards() != null) {
                ub.waitForActiveShards(w -> w.count(TypeUtils.waitForActiveShardsCount(updateQuery.getWaitForActiveShards())));
            }
            return ub;
        });
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount) {
        return this.searchRequest(query, routing, clazz, indexCoordinates, forCount, false, null);
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, long scrollTimeInMillis) {
        return this.searchRequest(query, routing, clazz, indexCoordinates, forCount, true, scrollTimeInMillis);
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, boolean forBatchedSearch) {
        return this.searchRequest(query, routing, clazz, indexCoordinates, forCount, forBatchedSearch, null);
    }

    public <T> SearchRequest searchRequest(Query query, @Nullable String routing, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, boolean forCount, boolean forBatchedSearch, @Nullable Long scrollTimeInMillis) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)indexCoordinates, (String)"indexCoordinates must not be null");
        this.elasticsearchConverter.updateQuery(query, clazz);
        SearchRequest.Builder builder = new SearchRequest.Builder();
        this.prepareSearchRequest(query, routing, clazz, indexCoordinates, builder, forCount, forBatchedSearch);
        if (scrollTimeInMillis != null) {
            builder.scroll(t -> t.time(scrollTimeInMillis + "ms"));
        }
        builder.query(this.getQuery(query, clazz));
        if (StringUtils.hasText((String)query.getRoute())) {
            builder.routing(query.getRoute());
        }
        if (StringUtils.hasText((String)routing)) {
            builder.routing(routing);
        }
        this.addPostFilter(query, builder);
        return builder.build();
    }

    public MsearchTemplateRequest searchMsearchTemplateRequest(List<ElasticsearchTemplate.MultiSearchTemplateQueryParameter> multiSearchTemplateQueryParameters, @Nullable String routing) {
        return MsearchTemplateRequest.of(mtrb -> {
            multiSearchTemplateQueryParameters.forEach(param -> {
                SearchTemplateQuery query = param.query();
                mtrb.searchTemplates(stb -> stb.header(this.msearchHeaderBuilder(query, param.index(), routing)).body(bb -> {
                    bb.explain(Boolean.valueOf(query.getExplain())).id(query.getId());
                    if (query.getSource() != null) {
                        bb.source(s -> s.scriptString(query.getSource()));
                    }
                    if (!CollectionUtils.isEmpty(query.getParams())) {
                        Map<String, JsonData> params = this.getTemplateParams(query.getParams().entrySet());
                        bb.params(params);
                    }
                    return bb;
                }));
            });
            return mtrb;
        });
    }

    public MsearchRequest searchMsearchRequest(List<ElasticsearchTemplate.MultiSearchQueryParameter> multiSearchQueryParameters, @Nullable String routing) {
        return MsearchRequest.of(mrb -> {
            multiSearchQueryParameters.forEach(param -> {
                ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(param.clazz());
                Query query = param.query();
                mrb.searches(sb -> sb.header(this.msearchHeaderBuilder(query, param.index(), routing)).body(bb -> {
                    List<SortOptions> sortOptions;
                    bb.query(this.getQuery(query, param.clazz())).seqNoPrimaryTerm(persistentEntity != null ? Boolean.valueOf(persistentEntity.hasSeqNoPrimaryTermProperty()) : null).version(Boolean.valueOf(true)).trackScores(Boolean.valueOf(query.getTrackScores())).source(this.getSourceConfig(query)).timeout(TypeUtils.timeStringMs(query.getTimeout()));
                    bb.from(Integer.valueOf((int)(query.getPageable().isPaged() ? query.getPageable().getOffset() : 0L))).size(query.getRequestSize());
                    if (!CollectionUtils.isEmpty(query.getFields())) {
                        bb.fields(fb -> {
                            query.getFields().forEach(arg_0 -> ((FieldAndFormat.Builder)fb).field(arg_0));
                            return fb;
                        });
                    }
                    if (!CollectionUtils.isEmpty(query.getStoredFields())) {
                        bb.storedFields(query.getStoredFields());
                    }
                    if (query.getMinScore() > 0.0f) {
                        bb.minScore(Double.valueOf(query.getMinScore()));
                    }
                    if (query.getSort() != null && !(sortOptions = this.getSortOptions(query.getSort(), persistentEntity)).isEmpty()) {
                        bb.sort(sortOptions);
                    }
                    this.addHighlight(query, (SearchRequestBody.Builder)bb);
                    if (query.getExplain()) {
                        bb.explain(Boolean.valueOf(true));
                    }
                    if (!CollectionUtils.isEmpty(query.getSearchAfter())) {
                        bb.searchAfter(query.getSearchAfter().stream().map(TypeUtils::toFieldValue).toList());
                    }
                    query.getRescorerQueries().forEach(rescorerQuery -> bb.rescore(this.getRescore((RescorerQuery)rescorerQuery), new Rescore[0]));
                    if (!query.getRuntimeFields().isEmpty()) {
                        HashMap runtimeMappings = new HashMap();
                        query.getRuntimeFields().forEach(runtimeField -> {
                            RuntimeField esRuntimeField = RuntimeField.of(rt -> {
                                RuntimeField.Builder rfb = rt.type((RuntimeFieldType)RuntimeFieldType._DESERIALIZER.parse(runtimeField.getType()));
                                String script = runtimeField.getScript();
                                if (script != null) {
                                    rfb.script(s -> {
                                        if (script != null) {
                                            s.source(so -> so.scriptString(script));
                                        }
                                        if (runtimeField.getParams() != null) {
                                            s.params(TypeUtils.paramsMap(runtimeField.getParams()));
                                        }
                                        return s;
                                    });
                                }
                                return rfb;
                            });
                            runtimeMappings.put(runtimeField.getName(), esRuntimeField);
                        });
                        bb.runtimeMappings(runtimeMappings);
                    }
                    if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
                        Stream<NamedValue> namedValueStream = query.getIndicesBoost().stream().map(indexBoost -> {
                            NamedValue namedValue = new NamedValue(indexBoost.getIndexName(), (Object)Float.valueOf(indexBoost.getBoost()).doubleValue());
                            return namedValue;
                        });
                        List namedValueList = namedValueStream.collect(Collectors.toList());
                        bb.indicesBoost(namedValueList);
                    }
                    query.getScriptedFields().forEach(scriptedField -> bb.scriptFields(scriptedField.getFieldName(), sf -> sf.script(this.getScript(scriptedField.getScriptData()))));
                    if (query instanceof NativeQuery) {
                        NativeQuery nativeQuery = (NativeQuery)query;
                        this.prepareNativeSearch(nativeQuery, (SearchRequestBody.Builder)bb);
                    }
                    return bb;
                }));
            });
            return mrb;
        });
    }

    private Function<MultisearchHeader.Builder, ObjectBuilder<MultisearchHeader>> msearchHeaderBuilder(Query query, IndexCoordinates index, @Nullable String routing) {
        return h -> {
            NativeQuery nativeQuery;
            SearchType searchType = query instanceof NativeQuery && !CollectionUtils.isEmpty((nativeQuery = (NativeQuery)query).getKnnSearches()) ? null : TypeUtils.searchType(query.getSearchType());
            h.index(Arrays.asList(index.getIndexNames())).searchType(searchType).requestCache(query.getRequestCache());
            if (StringUtils.hasText((String)query.getRoute())) {
                h.routing(query.getRoute());
            } else if (StringUtils.hasText((String)routing)) {
                h.routing(routing);
            }
            if (query.getPreference() != null) {
                h.preference(query.getPreference());
            }
            return h;
        };
    }

    private <T> void prepareSearchRequest(Query query, @Nullable String routing, @Nullable Class<T> clazz, IndexCoordinates indexCoordinates, SearchRequest.Builder builder, boolean forCount, boolean forBatchedSearch) {
        List<SortOptions> sortOptions;
        NativeQuery nativeQuery;
        Object[] indexNames = indexCoordinates.getIndexNames();
        Assert.notEmpty((Object[])indexNames, (String)"indexCoordinates does not contain entries");
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(clazz);
        SearchType searchType = query instanceof NativeQuery && !CollectionUtils.isEmpty((nativeQuery = (NativeQuery)query).getKnnSearches()) ? null : TypeUtils.searchType(query.getSearchType());
        builder.version(Boolean.valueOf(true)).trackScores(Boolean.valueOf(query.getTrackScores())).allowNoIndices(query.getAllowNoIndices()).source(this.getSourceConfig(query)).searchType(searchType).timeout(TypeUtils.timeStringMs(query.getTimeout())).requestCache(query.getRequestCache());
        Query.PointInTime pointInTime = query.getPointInTime();
        if (pointInTime != null) {
            builder.pit(pb -> pb.id(pointInTime.id()).keepAlive(TypeUtils.time(pointInTime.keepAlive())));
        } else {
            builder.index(Arrays.asList(indexNames));
            EnumSet<IndicesOptions.WildcardStates> expandWildcards = query.getExpandWildcards();
            if (expandWildcards != null && !expandWildcards.isEmpty()) {
                builder.expandWildcards(TypeUtils.expandWildcards(expandWildcards));
            }
            if (query.getRoute() != null) {
                builder.routing(query.getRoute());
            } else if (StringUtils.hasText((String)routing)) {
                builder.routing(routing);
            }
            if (query.getPreference() != null) {
                builder.preference(query.getPreference());
            }
        }
        if (persistentEntity != null && persistentEntity.hasSeqNoPrimaryTermProperty()) {
            builder.seqNoPrimaryTerm(Boolean.valueOf(true));
        }
        builder.from(Integer.valueOf((int)(query.getPageable().isPaged() ? query.getPageable().getOffset() : 0L))).size(query.getRequestSize());
        if (!CollectionUtils.isEmpty(query.getFields())) {
            List<FieldAndFormat> fieldAndFormats = query.getFields().stream().map(field -> FieldAndFormat.of(b -> b.field(field))).toList();
            builder.fields(fieldAndFormats);
        }
        if (!CollectionUtils.isEmpty(query.getStoredFields())) {
            builder.storedFields(query.getStoredFields());
        }
        if (query.getIndicesOptions() != null) {
            this.addIndicesOptions(builder, query.getIndicesOptions());
        }
        if (query.getMinScore() > 0.0f) {
            builder.minScore(Double.valueOf(query.getMinScore()));
        }
        this.addHighlight(query, builder);
        query.getScriptedFields().forEach(scriptedField -> builder.scriptFields(scriptedField.getFieldName(), sf -> sf.script(this.getScript(scriptedField.getScriptData()))));
        if (query instanceof NativeQuery) {
            NativeQuery nativeQuery2 = (NativeQuery)query;
            this.prepareNativeSearch(nativeQuery2, builder);
        }
        if (query.getSort() != null && !(sortOptions = this.getSortOptions(query.getSort(), persistentEntity)).isEmpty()) {
            builder.sort(sortOptions);
        }
        if (query.getTrackTotalHits() != null) {
            int value = query.getTrackTotalHits() != false ? Integer.MAX_VALUE : -1;
            builder.trackTotalHits(th -> th.count(Integer.valueOf(value)));
        } else if (query.getTrackTotalHitsUpTo() != null) {
            builder.trackTotalHits(th -> th.count(query.getTrackTotalHitsUpTo()));
        }
        if (query.getExplain()) {
            builder.explain(Boolean.valueOf(true));
        }
        if (!CollectionUtils.isEmpty(query.getSearchAfter())) {
            NativeQuery nativeQuery3;
            List<FieldValue> fieldValues = query.getSearchAfter().stream().map(TypeUtils::toFieldValue).toList();
            if (query instanceof NativeQuery && (nativeQuery3 = (NativeQuery)query).getFieldCollapse() != null) {
                builder.searchAfter(fieldValues.get(0), new FieldValue[0]);
            } else {
                builder.searchAfter(fieldValues);
            }
        }
        query.getRescorerQueries().forEach(rescorerQuery -> builder.rescore(this.getRescore((RescorerQuery)rescorerQuery), new Rescore[0]));
        if (!query.getRuntimeFields().isEmpty()) {
            HashMap runtimeMappings = new HashMap();
            query.getRuntimeFields().forEach(runtimeField -> runtimeMappings.put(runtimeField.getName(), RuntimeField.of(rfb -> {
                rfb.type((RuntimeFieldType)RuntimeFieldType._DESERIALIZER.parse(runtimeField.getType()));
                String script = runtimeField.getScript();
                if (script != null) {
                    rfb.script(s -> {
                        if (script != null) {
                            s.source(so -> so.scriptString(script));
                        }
                        if (runtimeField.getParams() != null) {
                            s.params(TypeUtils.paramsMap(runtimeField.getParams()));
                        }
                        return s;
                    });
                }
                return rfb;
            })));
            builder.runtimeMappings(runtimeMappings);
        }
        if (forCount) {
            builder.size(Integer.valueOf(0)).trackTotalHits(th -> th.count(Integer.valueOf(Integer.MAX_VALUE))).source(SourceConfig.of(sc -> sc.fetch(Boolean.valueOf(false))));
        } else if (forBatchedSearch) {
            builder.requestCache(null);
            if (query.getPageable().isUnpaged()) {
                builder.size(query.getReactiveBatchSize());
            }
        }
        if (!CollectionUtils.isEmpty(query.getIndicesBoost())) {
            Stream<NamedValue> namedValueStream = query.getIndicesBoost().stream().map(indexBoost -> {
                NamedValue namedValue = new NamedValue(indexBoost.getIndexName(), (Object)Float.valueOf(indexBoost.getBoost()).doubleValue());
                return namedValue;
            });
            List namedValueList = namedValueStream.collect(Collectors.toList());
            builder.indicesBoost(namedValueList);
        }
        if (!CollectionUtils.isEmpty(query.getDocValueFields())) {
            builder.docvalueFields(query.getDocValueFields().stream().map(docValueField -> FieldAndFormat.of(b -> b.field(docValueField.field()).format(docValueField.format()))).toList());
        }
    }

    private void addIndicesOptions(SearchRequest.Builder builder, IndicesOptions indicesOptions) {
        indicesOptions.getOptions().forEach(option -> {
            switch (option) {
                case ALLOW_NO_INDICES: {
                    builder.allowNoIndices(Boolean.valueOf(true));
                    break;
                }
                case IGNORE_UNAVAILABLE: {
                    builder.ignoreUnavailable(Boolean.valueOf(true));
                    break;
                }
                case IGNORE_THROTTLED: {
                    builder.ignoreThrottled(Boolean.valueOf(true));
                    break;
                }
                case FORBID_ALIASES_TO_MULTIPLE_INDICES: 
                case FORBID_CLOSED_INDICES: 
                case IGNORE_ALIASES: {
                    if (!LOGGER.isWarnEnabled()) break;
                    LOGGER.warn((Object)String.format("indices option %s is not supported by the Elasticsearch client.", option.name()));
                }
            }
        });
        builder.expandWildcards(indicesOptions.getExpandWildcards().stream().map(wildcardStates -> switch (wildcardStates) {
            default -> throw new IncompatibleClassChangeError();
            case IndicesOptions.WildcardStates.OPEN -> ExpandWildcard.Open;
            case IndicesOptions.WildcardStates.CLOSED -> ExpandWildcard.Closed;
            case IndicesOptions.WildcardStates.HIDDEN -> ExpandWildcard.Hidden;
            case IndicesOptions.WildcardStates.ALL -> ExpandWildcard.All;
            case IndicesOptions.WildcardStates.NONE -> ExpandWildcard.None;
        }).collect(Collectors.toList()));
    }

    private Rescore getRescore(RescorerQuery rescorerQuery) {
        return Rescore.of(r -> r.query(rq -> rq.query(this.getQuery(rescorerQuery.getQuery(), null)).scoreMode(TypeUtils.scoreMode(rescorerQuery.getScoreMode())).queryWeight(Double.valueOf(rescorerQuery.getQueryWeight() != null ? Double.valueOf(rescorerQuery.getQueryWeight().floatValue()) : 1.0)).rescoreQueryWeight(Double.valueOf(rescorerQuery.getRescoreQueryWeight() != null ? Double.valueOf(rescorerQuery.getRescoreQueryWeight().floatValue()) : 1.0))).windowSize(rescorerQuery.getWindowSize()));
    }

    private void addHighlight(Query query, SearchRequest.Builder builder) {
        Highlight highlight = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext(), this).getHighlight(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        builder.highlight(highlight);
    }

    private void addHighlight(Query query, SearchRequestBody.Builder builder) {
        Highlight highlight = query.getHighlightQuery().map(highlightQuery -> new HighlightQueryBuilder(this.elasticsearchConverter.getMappingContext(), this).getHighlight(highlightQuery.getHighlight(), highlightQuery.getType())).orElse(null);
        builder.highlight(highlight);
    }

    private List<SortOptions> getSortOptions(Sort sort, @Nullable ElasticsearchPersistentEntity<?> persistentEntity) {
        return sort.stream().map(order -> this.getSortOptions((Sort.Order)order, persistentEntity)).collect(Collectors.toList());
    }

    private SortOptions getSortOptions(Sort.Order order, @Nullable ElasticsearchPersistentEntity<?> persistentEntity) {
        String fieldName;
        SortOrder sortOrder = order.getDirection().isDescending() ? SortOrder.Desc : SortOrder.Asc;
        Order.Mode mode = order.getDirection().isAscending() ? Order.Mode.min : Order.Mode.max;
        String unmappedType = null;
        String missing = null;
        NestedSortValue nestedSortValue = null;
        if (SortOptions.Kind.Score.jsonValue().equals(order.getProperty())) {
            return SortOptions.of(so -> so.score(s -> s.order(sortOrder)));
        }
        if (order instanceof Order) {
            Order o = (Order)order;
            if (o.getMode() != null) {
                mode = o.getMode();
            }
            unmappedType = o.getUnmappedType();
            missing = o.getMissing();
            nestedSortValue = this.getNestedSort(o.getNested(), persistentEntity);
        }
        Order.Mode finalMode = mode;
        String finalUnmappedType = unmappedType;
        NestedSortValue finalNestedSortValue = nestedSortValue;
        ElasticsearchPersistentProperty property = persistentEntity != null ? (ElasticsearchPersistentProperty)persistentEntity.getPersistentProperty(order.getProperty()) : null;
        String string = fieldName = property != null ? property.getFieldName() : order.getProperty();
        if (order instanceof GeoDistanceOrder) {
            GeoDistanceOrder geoDistanceOrder = (GeoDistanceOrder)order;
            return RequestConverter.getSortOptions(geoDistanceOrder, fieldName, finalMode);
        }
        String finalMissing = missing != null ? missing : (order.getNullHandling() == Sort.NullHandling.NULLS_FIRST ? "_first" : (order.getNullHandling() == Sort.NullHandling.NULLS_LAST ? "_last" : null));
        return SortOptions.of(so -> so.field(f -> {
            FieldType fieldType;
            f.field(fieldName).order(sortOrder).mode(TypeUtils.sortMode(finalMode));
            if (finalUnmappedType != null && (fieldType = TypeUtils.fieldType(finalUnmappedType)) != null) {
                f.unmappedType(fieldType);
            }
            if (finalMissing != null) {
                f.missing(fv -> fv.stringValue(finalMissing));
            }
            if (finalNestedSortValue != null) {
                f.nested(finalNestedSortValue);
            }
            return f;
        }));
    }

    private @Nullable NestedSortValue getNestedSort(@Nullable Order.Nested nested, @Nullable ElasticsearchPersistentEntity<?> persistentEntity) {
        return nested == null || persistentEntity == null ? null : NestedSortValue.of(b -> b.path(this.elasticsearchConverter.updateFieldNames(nested.getPath(), persistentEntity)).maxChildren(nested.getMaxChildren()).nested(this.getNestedSort(nested.getNested(), persistentEntity)).filter(this.getQuery(nested.getFilter(), persistentEntity.getType())));
    }

    private static SortOptions getSortOptions(GeoDistanceOrder geoDistanceOrder, String fieldName, Order.Mode finalMode) {
        return SortOptions.of(so -> so.geoDistance(gd -> gd.field(fieldName).location(loc -> loc.latlon(Queries.latLon(geoDistanceOrder.getGeoPoint()))).distanceType(TypeUtils.geoDistanceType(geoDistanceOrder.getDistanceType())).mode(TypeUtils.sortMode(finalMode)).order(TypeUtils.sortOrder(geoDistanceOrder.getDirection())).unit(TypeUtils.distanceUnit(geoDistanceOrder.getUnit())).ignoreUnmapped(geoDistanceOrder.getIgnoreUnmapped())));
    }

    private void prepareNativeSearch(NativeQuery query, SearchRequest.Builder builder) {
        builder.suggest(query.getSuggester()).collapse(query.getFieldCollapse()).sort(query.getSortOptions());
        if (!CollectionUtils.isEmpty(query.getKnnSearches())) {
            builder.knn(query.getKnnSearches());
        }
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            builder.aggregations(query.getAggregations());
        }
        if (!CollectionUtils.isEmpty(query.getSearchExtensions())) {
            builder.ext(query.getSearchExtensions());
        }
    }

    private void prepareNativeSearch(NativeQuery query, SearchRequestBody.Builder builder) {
        builder.suggest(query.getSuggester()).collapse(query.getFieldCollapse()).sort(query.getSortOptions());
        if (!CollectionUtils.isEmpty(query.getKnnSearches())) {
            builder.knn(query.getKnnSearches());
        }
        if (!CollectionUtils.isEmpty(query.getAggregations())) {
            builder.aggregations(query.getAggregations());
        }
        if (!CollectionUtils.isEmpty(query.getSearchExtensions())) {
            builder.ext(query.getSearchExtensions());
        }
    }

    @Nullable co.elastic.clients.elasticsearch._types.query_dsl.Query getQuery(@Nullable Query query, @Nullable Class<?> clazz) {
        return RequestConverter.getEsQuery(query, q -> this.elasticsearchConverter.updateQuery((Query)q, clazz));
    }

    private void addPostFilter(Query query, SearchRequest.Builder builder) {
        if (query instanceof NativeQuery) {
            NativeQuery nativeQuery = (NativeQuery)query;
            if (nativeQuery.getFilter() != null) {
                builder.postFilter(nativeQuery.getFilter());
            } else if (nativeQuery.getSpringDataQuery() != null) {
                this.addPostFilter(nativeQuery.getSpringDataQuery(), builder);
            }
        }
    }

    public MoreLikeThisQuery moreLikeThisQuery(org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery query, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return MoreLikeThisQuery.of(q -> {
            q.like(Like.of(l -> l.document(ld -> ld.index(index.getIndexName()).id(query.getId()))), new Like[0]).fields(query.getFields());
            if (query.getMinTermFreq() != null) {
                q.minTermFreq(query.getMinTermFreq());
            }
            if (query.getMaxQueryTerms() != null) {
                q.maxQueryTerms(query.getMaxQueryTerms());
            }
            if (!CollectionUtils.isEmpty(query.getStopWords())) {
                q.stopWords(query.getStopWords());
            }
            if (query.getMinDocFreq() != null) {
                q.minDocFreq(query.getMinDocFreq());
            }
            if (query.getMaxDocFreq() != null) {
                q.maxDocFreq(query.getMaxDocFreq());
            }
            if (query.getMinWordLen() != null) {
                q.minWordLength(query.getMinWordLen());
            }
            if (query.getMaxWordLen() != null) {
                q.maxWordLength(query.getMaxWordLen());
            }
            if (query.getBoostTerms() != null) {
                q.boostTerms(Double.valueOf(query.getBoostTerms().floatValue()));
            }
            return q;
        });
    }

    public OpenPointInTimeRequest searchOpenPointInTimeRequest(IndexCoordinates index, Duration keepAlive, Boolean ignoreUnavailable) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notNull((Object)keepAlive, (String)"keepAlive must not be null");
        Assert.notNull((Object)ignoreUnavailable, (String)"ignoreUnavailable must not be null");
        return OpenPointInTimeRequest.of(opit -> opit.index(Arrays.asList(index.getIndexNames())).ignoreUnavailable(ignoreUnavailable).keepAlive(TypeUtils.time(keepAlive)));
    }

    public ClosePointInTimeRequest searchClosePointInTime(String pit) {
        Assert.notNull((Object)pit, (String)"pit must not be null");
        return ClosePointInTimeRequest.of(cpit -> cpit.id(pit));
    }

    public SearchTemplateRequest searchTemplate(SearchTemplateQuery query, @Nullable String routing, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        return SearchTemplateRequest.of(builder -> {
            builder.allowNoIndices(query.getAllowNoIndices()).explain(Boolean.valueOf(query.getExplain())).id(query.getId()).index(Arrays.asList(index.getIndexNames())).preference(query.getPreference()).searchType(TypeUtils.searchType(query.getSearchType()));
            if (query.getSource() != null) {
                builder.source(so -> so.scriptString(query.getSource()));
            }
            if (query.getRoute() != null) {
                builder.routing(query.getRoute());
            } else if (StringUtils.hasText((String)routing)) {
                builder.routing(routing);
            }
            EnumSet<IndicesOptions.WildcardStates> expandWildcards = query.getExpandWildcards();
            if (expandWildcards != null && !expandWildcards.isEmpty()) {
                builder.expandWildcards(TypeUtils.expandWildcards(expandWildcards));
            }
            if (query.hasScrollTime()) {
                builder.scroll(TypeUtils.time(query.getScrollTime()));
            }
            if (!CollectionUtils.isEmpty(query.getParams())) {
                Map<String, JsonData> params = this.getTemplateParams(query.getParams().entrySet());
                builder.params(params);
            }
            return builder;
        });
    }

    private Map<String, JsonData> getTemplateParams(Set<Map.Entry<String, Object>> query) {
        Function<Map.Entry, String> keyMapper = Map.Entry::getKey;
        Function<Map.Entry, JsonData> valueMapper = entry -> JsonData.of(entry.getValue(), (JsonpMapper)this.jsonpMapper);
        return query.stream().collect(Collectors.toMap(keyMapper, valueMapper));
    }

    public PutScriptRequest scriptPut(Script script) {
        Assert.notNull((Object)script, (String)"script must not be null");
        return PutScriptRequest.of(b -> b.id(script.id()).script(sb -> sb.lang(script.language()).source(s -> s.scriptString(script.source()))));
    }

    public GetScriptRequest scriptGet(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        return GetScriptRequest.of(b -> b.id(name));
    }

    public DeleteScriptRequest scriptDelete(String name) {
        Assert.notNull((Object)name, (String)"name must not be null");
        return DeleteScriptRequest.of(b -> b.id(name));
    }

    public <T> T fromJson(String json, JsonpDeserializer<T> deserializer) {
        Assert.notNull((Object)json, (String)"json must not be null");
        Assert.notNull(deserializer, (String)"deserializer must not be null");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        return this.fromJson(byteArrayInputStream, deserializer);
    }

    public <T> T fromJson(ByteArrayInputStream byteArrayInputStream, JsonpDeserializer<T> deserializer) {
        Assert.notNull((Object)byteArrayInputStream, (String)"byteArrayInputStream must not be null");
        Assert.notNull(deserializer, (String)"deserializer must not be null");
        JsonParser parser = this.jsonpMapper.jsonProvider().createParser((InputStream)byteArrayInputStream);
        return (T)deserializer.deserialize(parser, this.jsonpMapper);
    }

    private @Nullable ElasticsearchPersistentEntity<?> getPersistentEntity(Object entity) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(entity.getClass());
    }

    private @Nullable ElasticsearchPersistentEntity<?> getPersistentEntity(@Nullable Class<?> clazz) {
        return clazz != null ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(clazz) : null;
    }

    private @Nullable String getPersistentEntityId(Object entity) {
        Object identifier;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(entity);
        if (persistentEntity != null && (identifier = persistentEntity.getIdentifierAccessor(entity).getIdentifier()) != null) {
            return identifier.toString();
        }
        return null;
    }

    private VersionType retrieveVersionTypeFromPersistentEntity(@Nullable Class<?> clazz) {
        Document.VersionType entityVersionType;
        ElasticsearchPersistentEntity<?> persistentEntity = this.getPersistentEntity(clazz);
        VersionType versionType = null;
        if (persistentEntity != null && (entityVersionType = persistentEntity.getVersionType()) != null) {
            versionType = switch (entityVersionType) {
                default -> throw new IncompatibleClassChangeError();
                case Document.VersionType.INTERNAL -> VersionType.Internal;
                case Document.VersionType.EXTERNAL -> VersionType.External;
                case Document.VersionType.EXTERNAL_GTE -> VersionType.ExternalGte;
            };
        }
        return versionType != null ? versionType : VersionType.External;
    }

    private @Nullable SourceConfig getSourceConfig(Query query) {
        if (query.getSourceFilter() != null) {
            return SourceConfig.of(s -> {
                SourceFilter sourceFilter = query.getSourceFilter();
                if (sourceFilter.fetchSource() != null) {
                    s.fetch(sourceFilter.fetchSource());
                } else {
                    s.filter(sfb -> {
                        String[] includes = sourceFilter.getIncludes();
                        String[] excludes = sourceFilter.getExcludes();
                        if (includes != null) {
                            sfb.includes(Arrays.asList(includes));
                        }
                        if (excludes != null) {
                            sfb.excludes(Arrays.asList(excludes));
                        }
                        return sfb;
                    });
                }
                return s;
            });
        }
        return null;
    }

    static @Nullable Boolean deleteByQueryRefresh(@Nullable RefreshPolicy refreshPolicy) {
        if (refreshPolicy == null) {
            return null;
        }
        return switch (refreshPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RefreshPolicy.IMMEDIATE -> true;
            case RefreshPolicy.WAIT_UNTIL -> null;
            case RefreshPolicy.NONE -> false;
        };
    }
}

