/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.repository.support.ReactiveElasticsearchRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.Assert;

public class ReactiveElasticsearchRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private @Nullable ReactiveElasticsearchOperations operations;
    private boolean mappingContextConfigured = false;

    public ReactiveElasticsearchRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setReactiveElasticsearchOperations(@Nullable ReactiveElasticsearchOperations operations) {
        this.operations = operations;
    }

    protected void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
        this.mappingContextConfigured = true;
    }

    protected final RepositoryFactorySupport createRepositoryFactory() {
        return this.getFactoryInstance(this.operations);
    }

    protected RepositoryFactorySupport getFactoryInstance(ReactiveElasticsearchOperations operations) {
        return new ReactiveElasticsearchRepositoryFactory(operations);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.operations != null ? 1 : 0) != 0, (String)"ReactiveElasticsearchOperations must not be null!");
        if (!this.mappingContextConfigured) {
            this.setMappingContext(this.operations.getElasticsearchConverter().getMappingContext());
        }
    }
}

