/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.suggest.response;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.elasticsearch.support.ScoreDoc;

public class CompletionSuggestion<T>
extends Suggest.Suggestion<Entry<T>> {
    public CompletionSuggestion(String name, int size, List<Entry<T>> entries) {
        super(name, size, entries);
    }

    public static class Entry<T>
    extends Suggest.Suggestion.Entry<Option<T>> {
        public Entry(String text, int offset, int length, List<Option<T>> options) {
            super(text, offset, length, options);
        }

        public static class Option<T>
        extends Suggest.Suggestion.Entry.Option {
            private final Map<String, Set<String>> contexts;
            private final ScoreDoc scoreDoc;
            private final @Nullable SearchDocument searchDocument;
            private final @Nullable T hitEntity;
            private @Nullable SearchHit<T> searchHit;

            public Option(String text, @Nullable String highlighted, @Nullable Double score, Boolean collateMatch, Map<String, Set<String>> contexts, ScoreDoc scoreDoc, @Nullable SearchDocument searchDocument, @Nullable T hitEntity) {
                super(text, highlighted, score, collateMatch);
                this.contexts = contexts;
                this.scoreDoc = scoreDoc;
                this.searchDocument = searchDocument;
                this.hitEntity = hitEntity;
            }

            public Map<String, Set<String>> getContexts() {
                return this.contexts;
            }

            public ScoreDoc getScoreDoc() {
                return this.scoreDoc;
            }

            public @Nullable SearchHit<T> getSearchHit() {
                return this.searchHit;
            }

            public void updateSearchHit(BiFunction<SearchDocument, T, SearchHit<T>> mapper) {
                this.searchHit = mapper.apply(this.searchDocument, (SearchDocument)this.hitEntity);
            }
        }
    }
}

