/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.ElasticsearchErrorCause;

public class MultiGetItem<T> {
    private final @Nullable T item;
    private final @Nullable Failure failure;

    private MultiGetItem(@Nullable T item, @Nullable Failure failure) {
        this.item = item;
        this.failure = failure;
    }

    public static <T> MultiGetItem<T> of(@Nullable T item, @Nullable Failure failure) {
        return new MultiGetItem<T>(item, failure);
    }

    public boolean hasItem() {
        return this.item != null;
    }

    public @Nullable T getItem() {
        return this.item;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public @Nullable Failure getFailure() {
        return this.failure;
    }

    public static class Failure {
        private final @Nullable String index;
        private final @Nullable String type;
        private final @Nullable String id;
        private final @Nullable Exception exception;
        private final @Nullable ElasticsearchErrorCause elasticsearchErrorCause;

        private Failure(@Nullable String index, @Nullable String type, @Nullable String id, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.exception = exception;
            this.elasticsearchErrorCause = elasticsearchErrorCause;
        }

        public static Failure of(String index, @Nullable String type, String id, @Nullable Exception exception, @Nullable ElasticsearchErrorCause elasticsearchErrorCause) {
            return new Failure(index, type, id, exception, elasticsearchErrorCause);
        }

        public @Nullable String getIndex() {
            return this.index;
        }

        public @Nullable String getType() {
            return this.type;
        }

        public @Nullable String getId() {
            return this.id;
        }

        public @Nullable Exception getException() {
            return this.exception;
        }

        public @Nullable ElasticsearchErrorCause getElasticsearchErrorCause() {
            return this.elasticsearchErrorCause;
        }
    }
}

