/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.IndicesOptions;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.types.ConflictsType;
import org.springframework.data.elasticsearch.core.query.types.OperatorType;
import org.springframework.util.Assert;

public class DeleteQuery {
    private final @Nullable String q;
    private final @Nullable Boolean analyzeWildcard;
    private final @Nullable String analyzer;
    private final @Nullable OperatorType defaultOperator;
    private final @Nullable String df;
    private final @Nullable Boolean lenient;
    private final @Nullable Boolean allowNoIndices;
    private final @Nullable ConflictsType conflicts;
    private final @Nullable EnumSet<IndicesOptions.WildcardStates> expandWildcards;
    private final @Nullable Boolean ignoreUnavailable;
    private final @Nullable Long maxDocs;
    private final @Nullable String preference;
    private final @Nullable Boolean requestCache;
    private final @Nullable Boolean refresh;
    private final @Nullable Float requestsPerSecond;
    private final @Nullable String routing;
    private final @Nullable Duration scroll;
    private final @Nullable Long scrollSize;
    private final @Nullable Query.SearchType searchType;
    private final @Nullable Duration searchTimeout;
    private final @Nullable Integer slices;
    private final @Nullable Sort sort;
    private final @Nullable List<String> stats;
    private final @Nullable Long terminateAfter;
    private final @Nullable Duration timeout;
    private final @Nullable Boolean version;
    private final Query query;

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    private DeleteQuery(Builder builder) {
        this.q = builder.luceneQuery;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.analyzer = builder.analyzer;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.defaultField;
        this.lenient = builder.lenient;
        this.allowNoIndices = builder.allowNoIndices;
        this.conflicts = builder.conflicts;
        this.expandWildcards = builder.expandWildcards;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.maxDocs = builder.maxDocs;
        this.preference = builder.preference;
        this.requestCache = builder.requestCache;
        this.refresh = builder.refresh;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.routing = builder.routing;
        this.scroll = builder.scrollTime;
        this.scrollSize = builder.scrollSize;
        this.searchType = builder.searchType;
        this.searchTimeout = builder.searchTimeout;
        this.slices = builder.slices;
        this.sort = builder.sort;
        this.stats = builder.stats;
        this.terminateAfter = builder.terminateAfter;
        this.timeout = builder.timeout;
        this.version = builder.version;
        this.query = builder.query;
    }

    public @Nullable String getQ() {
        return this.q;
    }

    public @Nullable Boolean getAnalyzeWildcard() {
        return this.analyzeWildcard;
    }

    public @Nullable String getAnalyzer() {
        return this.analyzer;
    }

    public @Nullable OperatorType getDefaultOperator() {
        return this.defaultOperator;
    }

    public @Nullable String getDf() {
        return this.df;
    }

    public @Nullable Boolean getLenient() {
        return this.lenient;
    }

    public @Nullable Boolean getAllowNoIndices() {
        return this.allowNoIndices;
    }

    public @Nullable ConflictsType getConflicts() {
        return this.conflicts;
    }

    public @Nullable EnumSet<IndicesOptions.WildcardStates> getExpandWildcards() {
        return this.expandWildcards;
    }

    public @Nullable Boolean getIgnoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public @Nullable Long getMaxDocs() {
        return this.maxDocs;
    }

    public @Nullable String getPreference() {
        return this.preference;
    }

    public @Nullable Boolean getRequestCache() {
        return this.requestCache;
    }

    public @Nullable Boolean getRefresh() {
        return this.refresh;
    }

    public @Nullable Float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public @Nullable String getRouting() {
        return this.routing;
    }

    public @Nullable Duration getScroll() {
        return this.scroll;
    }

    public @Nullable Long getScrollSize() {
        return this.scrollSize;
    }

    public @Nullable Query.SearchType getSearchType() {
        return this.searchType;
    }

    public @Nullable Duration getSearchTimeout() {
        return this.searchTimeout;
    }

    public @Nullable Integer getSlices() {
        return this.slices;
    }

    public @Nullable Sort getSort() {
        return this.sort;
    }

    public @Nullable List<String> getStats() {
        return this.stats;
    }

    public @Nullable Long getTerminateAfter() {
        return this.terminateAfter;
    }

    public @Nullable Duration getTimeout() {
        return this.timeout;
    }

    public @Nullable Boolean getVersion() {
        return this.version;
    }

    public @Nullable Query getQuery() {
        return this.query;
    }

    public static final class Builder {
        private @Nullable String luceneQuery;
        private @Nullable Boolean analyzeWildcard;
        private @Nullable String analyzer;
        private @Nullable OperatorType defaultOperator;
        private @Nullable String defaultField;
        private @Nullable Boolean lenient;
        private @Nullable Boolean allowNoIndices;
        private @Nullable ConflictsType conflicts;
        private @Nullable EnumSet<IndicesOptions.WildcardStates> expandWildcards;
        private @Nullable Boolean ignoreUnavailable;
        private @Nullable Long maxDocs;
        private @Nullable String preference;
        private @Nullable Boolean requestCache;
        private @Nullable Boolean refresh;
        private @Nullable Float requestsPerSecond;
        private @Nullable String routing;
        private @Nullable Duration scrollTime;
        private @Nullable Long scrollSize;
        private @Nullable Query.SearchType searchType;
        private @Nullable Duration searchTimeout;
        private @Nullable Integer slices;
        private @Nullable Sort sort;
        private @Nullable List<String> stats;
        private @Nullable Long terminateAfter;
        private @Nullable Duration timeout;
        private @Nullable Boolean version;
        private final Query query;

        private Builder(Query query) {
            Assert.notNull((Object)query, (String)"query must not be null");
            this.query = query;
        }

        public Builder withLuceneQuery(@Nullable String luceneQuery) {
            this.luceneQuery = luceneQuery;
            return this;
        }

        public Builder withAnalyzeWildcard(@Nullable Boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
            return this;
        }

        public Builder withAnalyzer(@Nullable String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder withDefaultOperator(@Nullable OperatorType defaultOperator) {
            this.defaultOperator = defaultOperator;
            return this;
        }

        public Builder withDefaultField(@Nullable String defaultField) {
            this.defaultField = defaultField;
            return this;
        }

        public Builder withLenient(@Nullable Boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder withAllowNoIndices(@Nullable Boolean allowNoIndices) {
            this.allowNoIndices = allowNoIndices;
            return this;
        }

        public Builder withConflicts(@Nullable ConflictsType conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder setExpandWildcards(@Nullable EnumSet<IndicesOptions.WildcardStates> expandWildcards) {
            this.expandWildcards = expandWildcards;
            return this;
        }

        public Builder withIgnoreUnavailable(@Nullable Boolean ignoreUnavailable) {
            this.ignoreUnavailable = ignoreUnavailable;
            return this;
        }

        public Builder withMaxDocs(@Nullable Long maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public Builder withPreference(@Nullable String preference) {
            this.preference = preference;
            return this;
        }

        public Builder withRequestCache(@Nullable Boolean requestCache) {
            this.requestCache = requestCache;
            return this;
        }

        public Builder withRefresh(@Nullable Boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder withRequestsPerSecond(@Nullable Float requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public Builder withRouting(@Nullable String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withScrollTime(@Nullable Duration scrollTime) {
            this.scrollTime = scrollTime;
            return this;
        }

        public Builder withScrollSize(@Nullable Long scrollSize) {
            this.scrollSize = scrollSize;
            return this;
        }

        public Builder withSearchType(@Nullable Query.SearchType searchType) {
            this.searchType = searchType;
            return this;
        }

        public Builder withSearchTimeout(@Nullable Duration searchTimeout) {
            this.searchTimeout = searchTimeout;
            return this;
        }

        public Builder withSlices(@Nullable Integer slices) {
            this.slices = slices;
            return this;
        }

        public Builder withSort(@Nullable Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder withStats(@Nullable List<String> stats) {
            this.stats = stats;
            return this;
        }

        public Builder withTerminateAfter(@Nullable Long terminateAfter) {
            this.terminateAfter = terminateAfter;
            return this;
        }

        public Builder withTimeout(@Nullable Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withVersion(@Nullable Boolean version) {
            this.version = version;
            return this;
        }

        public DeleteQuery build() {
            if (this.luceneQuery == null) {
                if (this.defaultField != null) {
                    throw new IllegalArgumentException("When defining the df parameter, you must include the Lucene query.");
                }
                if (this.analyzer != null) {
                    throw new IllegalArgumentException("When defining the analyzer parameter, you must include the Lucene query.");
                }
                if (this.analyzeWildcard != null) {
                    throw new IllegalArgumentException("When defining the analyzeWildcard parameter, you must include the Lucene query.");
                }
                if (this.defaultOperator != null) {
                    throw new IllegalArgumentException("When defining the defaultOperator parameter, you must include the Lucene query.");
                }
                if (this.lenient != null) {
                    throw new IllegalArgumentException("When defining the lenient parameter, you must include the Lucene query.");
                }
            }
            return new DeleteQuery(this);
        }
    }
}

