/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.ScriptData;

public class UpdateQuery {
    private final String id;
    private final @Nullable Document document;
    private final @Nullable Document upsert;
    private final @Nullable String routing;
    private final @Nullable Boolean scriptedUpsert;
    private final @Nullable Boolean docAsUpsert;
    private final @Nullable Boolean fetchSource;
    private final @Nullable List<String> fetchSourceIncludes;
    private final @Nullable List<String> fetchSourceExcludes;
    private final @Nullable Long ifSeqNo;
    private final @Nullable Long ifPrimaryTerm;
    private final @Nullable RefreshPolicy refreshPolicy;
    private final @Nullable Integer retryOnConflict;
    private final @Nullable String timeout;
    private final @Nullable String waitForActiveShards;
    private final @Nullable Query query;
    private final @Nullable Boolean abortOnVersionConflict;
    private final @Nullable Integer batchSize;
    private final @Nullable Integer maxDocs;
    private final @Nullable Integer maxRetries;
    private final @Nullable String pipeline;
    private final @Nullable Float requestsPerSecond;
    private final @Nullable Boolean shouldStoreResult;
    private final @Nullable Integer slices;
    private final @Nullable String indexName;
    private final @Nullable ScriptData scriptData;

    public static Builder builder(String id) {
        return new Builder(id);
    }

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    private UpdateQuery(String id, @Nullable String script, @Nullable Map<String, Object> params, @Nullable Document document, @Nullable Document upsert, @Nullable String lang, @Nullable String routing, @Nullable Boolean scriptedUpsert, @Nullable Boolean docAsUpsert, @Nullable Boolean fetchSource, @Nullable List<String> fetchSourceIncludes, @Nullable List<String> fetchSourceExcludes, @Nullable Long ifSeqNo, @Nullable Long ifPrimaryTerm, @Nullable RefreshPolicy refreshPolicy, @Nullable Integer retryOnConflict, @Nullable String timeout, @Nullable String waitForActiveShards, @Nullable Query query, @Nullable Boolean abortOnVersionConflict, @Nullable Integer batchSize, @Nullable Integer maxDocs, @Nullable Integer maxRetries, @Nullable String pipeline, @Nullable Float requestsPerSecond, @Nullable Boolean shouldStoreResult, @Nullable Integer slices, @Nullable String scriptName, @Nullable String indexName) {
        this.id = id;
        this.document = document;
        this.upsert = upsert;
        this.routing = routing;
        this.scriptedUpsert = scriptedUpsert;
        this.docAsUpsert = docAsUpsert;
        this.fetchSource = fetchSource;
        this.fetchSourceIncludes = fetchSourceIncludes;
        this.fetchSourceExcludes = fetchSourceExcludes;
        this.ifSeqNo = ifSeqNo;
        this.ifPrimaryTerm = ifPrimaryTerm;
        this.refreshPolicy = refreshPolicy;
        this.retryOnConflict = retryOnConflict;
        this.timeout = timeout;
        this.waitForActiveShards = waitForActiveShards;
        this.query = query;
        this.abortOnVersionConflict = abortOnVersionConflict;
        this.batchSize = batchSize;
        this.maxDocs = maxDocs;
        this.maxRetries = maxRetries;
        this.pipeline = pipeline;
        this.requestsPerSecond = requestsPerSecond;
        this.shouldStoreResult = shouldStoreResult;
        this.slices = slices;
        this.indexName = indexName;
        this.scriptData = lang != null || script != null || scriptName != null || params != null ? new ScriptData(lang, script, scriptName, params) : null;
    }

    public String getId() {
        return this.id;
    }

    public @Nullable String getScript() {
        return this.scriptData != null ? this.scriptData.script() : null;
    }

    public @Nullable Map<String, Object> getParams() {
        return this.scriptData != null ? this.scriptData.params() : null;
    }

    public @Nullable Document getDocument() {
        return this.document;
    }

    public @Nullable Document getUpsert() {
        return this.upsert;
    }

    public @Nullable String getLang() {
        return this.scriptData != null ? this.scriptData.language() : null;
    }

    public @Nullable String getRouting() {
        return this.routing;
    }

    public @Nullable Boolean getScriptedUpsert() {
        return this.scriptedUpsert;
    }

    public @Nullable Boolean getDocAsUpsert() {
        return this.docAsUpsert;
    }

    public @Nullable Boolean getFetchSource() {
        return this.fetchSource;
    }

    public @Nullable List<String> getFetchSourceIncludes() {
        return this.fetchSourceIncludes;
    }

    public @Nullable List<String> getFetchSourceExcludes() {
        return this.fetchSourceExcludes;
    }

    public @Nullable Long getIfSeqNo() {
        return this.ifSeqNo;
    }

    public @Nullable Long getIfPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public @Nullable RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public @Nullable Integer getRetryOnConflict() {
        return this.retryOnConflict;
    }

    public @Nullable String getTimeout() {
        return this.timeout;
    }

    public @Nullable String getWaitForActiveShards() {
        return this.waitForActiveShards;
    }

    public @Nullable Query getQuery() {
        return this.query;
    }

    public @Nullable Boolean getAbortOnVersionConflict() {
        return this.abortOnVersionConflict;
    }

    public @Nullable Integer getBatchSize() {
        return this.batchSize;
    }

    public @Nullable Integer getMaxDocs() {
        return this.maxDocs;
    }

    public @Nullable Integer getMaxRetries() {
        return this.maxRetries;
    }

    public @Nullable String getPipeline() {
        return this.pipeline;
    }

    public @Nullable Float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public @Nullable Boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    public @Nullable Integer getSlices() {
        return this.slices;
    }

    public @Nullable String getScriptName() {
        return this.scriptData != null ? this.scriptData.scriptName() : null;
    }

    public @Nullable String getIndexName() {
        return this.indexName;
    }

    public @Nullable ScriptData getScriptData() {
        return this.scriptData;
    }

    public static final class Builder {
        private String id = "";
        private @Nullable String script = null;
        private @Nullable Map<String, Object> params;
        private @Nullable Document document = null;
        private @Nullable Document upsert = null;
        private @Nullable String lang = null;
        private @Nullable String routing = null;
        private @Nullable Boolean scriptedUpsert;
        private @Nullable Boolean docAsUpsert;
        private @Nullable Boolean fetchSource;
        private @Nullable Long ifSeqNo;
        private @Nullable Long ifPrimaryTerm;
        private @Nullable RefreshPolicy refreshPolicy;
        private @Nullable Integer retryOnConflict;
        private @Nullable String timeout;
        @Nullable String waitForActiveShards;
        private @Nullable List<String> fetchSourceIncludes;
        private @Nullable List<String> fetchSourceExcludes;
        private @Nullable Query query;
        private @Nullable Boolean abortOnVersionConflict;
        private @Nullable Integer batchSize;
        private @Nullable Integer maxDocs;
        private @Nullable Integer maxRetries;
        private @Nullable String pipeline;
        private @Nullable Float requestsPerSecond;
        private @Nullable Boolean shouldStoreResult;
        private @Nullable Integer slices;
        private @Nullable String scriptName;
        private @Nullable String indexName;

        private Builder(String id) {
            this.id = id;
        }

        private Builder(Query query) {
            this.query = query;
        }

        public Builder withScript(String script) {
            this.script = script;
            return this;
        }

        public Builder withParams(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public Builder withDocument(Document document) {
            this.document = document;
            return this;
        }

        public Builder withUpsert(Document upsert) {
            this.upsert = upsert;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withRouting(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder withScriptedUpsert(Boolean scriptedUpsert) {
            this.scriptedUpsert = scriptedUpsert;
            return this;
        }

        public Builder withDocAsUpsert(Boolean docAsUpsert) {
            this.docAsUpsert = docAsUpsert;
            return this;
        }

        public Builder withFetchSource(Boolean fetchSource) {
            this.fetchSource = fetchSource;
            return this;
        }

        public Builder withIfSeqNo(Long ifSeqNo) {
            this.ifSeqNo = ifSeqNo;
            return this;
        }

        public Builder withIfPrimaryTerm(Long ifPrimaryTerm) {
            this.ifPrimaryTerm = ifPrimaryTerm;
            return this;
        }

        public Builder withRefreshPolicy(RefreshPolicy refreshPolicy) {
            this.refreshPolicy = refreshPolicy;
            return this;
        }

        public Builder withRetryOnConflict(Integer retryOnConflict) {
            this.retryOnConflict = retryOnConflict;
            return this;
        }

        public Builder withTimeout(String timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder withWaitForActiveShards(String waitForActiveShards) {
            this.waitForActiveShards = waitForActiveShards;
            return this;
        }

        public Builder withFetchSourceIncludes(List<String> fetchSourceIncludes) {
            this.fetchSourceIncludes = fetchSourceIncludes;
            return this;
        }

        public Builder withFetchSourceExcludes(List<String> fetchSourceExcludes) {
            this.fetchSourceExcludes = fetchSourceExcludes;
            return this;
        }

        public Builder withAbortOnVersionConflict(Boolean abortOnVersionConflict) {
            this.abortOnVersionConflict = abortOnVersionConflict;
            return this;
        }

        public Builder withBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder withMaxDocs(Integer maxDocs) {
            this.maxDocs = maxDocs;
            return this;
        }

        public Builder withMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withPipeline(String pipeline) {
            this.pipeline = pipeline;
            return this;
        }

        public Builder withRequestsPerSecond(Float requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public Builder withShouldStoreResult(Boolean shouldStoreResult) {
            this.shouldStoreResult = shouldStoreResult;
            return this;
        }

        public Builder withSlices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public Builder withScriptName(String scriptName) {
            this.scriptName = scriptName;
            return this;
        }

        public UpdateQuery build() {
            if (this.script == null && this.document == null && this.query == null) {
                throw new IllegalArgumentException("either script, document or query must be set");
            }
            return new UpdateQuery(this.id, this.script, this.params, this.document, this.upsert, this.lang, this.routing, this.scriptedUpsert, this.docAsUpsert, this.fetchSource, this.fetchSourceIncludes, this.fetchSourceExcludes, this.ifSeqNo, this.ifPrimaryTerm, this.refreshPolicy, this.retryOnConflict, this.timeout, this.waitForActiveShards, this.query, this.abortOnVersionConflict, this.batchSize, this.maxDocs, this.maxRetries, this.pipeline, this.requestsPerSecond, this.shouldStoreResult, this.slices, this.scriptName, this.indexName);
        }

        public Builder withIndex(@Nullable String indexName) {
            this.indexName = indexName;
            return this;
        }
    }
}

