/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.util.Assert;

public interface ElasticsearchConverter
extends EntityConverter<ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty, Object, Document> {
    default public ProjectionFactory getProjectionFactory() {
        return new SpelAwareProxyProjectionFactory();
    }

    default public String convertId(Object idValue) {
        Assert.notNull((Object)idValue, (String)"idValue must not be null!");
        if (!this.getConversionService().canConvert(idValue.getClass(), String.class)) {
            return idValue.toString();
        }
        String converted = (String)this.getConversionService().convert(idValue, String.class);
        if (converted == null) {
            return idValue.toString();
        }
        return converted;
    }

    default public Document mapObject(@Nullable Object source) {
        Document target = Document.create();
        if (source != null) {
            this.write(source, target);
        }
        return target;
    }

    public void updateQuery(Query var1, @Nullable Class<?> var2);

    public String updateFieldNames(String var1, ElasticsearchPersistentEntity<?> var2);
}

