/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.cluster;

public class ClusterHealth {
    private final String clusterName;
    private final String status;
    private final int numberOfNodes;
    private final int numberOfDataNodes;
    private final int activeShards;
    private final int relocatingShards;
    private final int activePrimaryShards;
    private final int initializingShards;
    private final int unassignedShards;
    private final double activeShardsPercent;
    private final int numberOfPendingTasks;
    private final boolean timedOut;
    private final int numberOfInFlightFetch;
    private final int delayedUnassignedShards;
    private final long taskMaxWaitingTimeMillis;

    private ClusterHealth(String clusterName, String status, int numberOfNodes, int numberOfDataNodes, int activeShards, int relocatingShards, int activePrimaryShards, int initializingShards, int unassignedShards, double activeShardsPercent, int numberOfPendingTasks, boolean timedOut, int numberOfInFlightFetch, int delayedUnassignedShards, long taskMaxWaitingTimeMillis) {
        this.clusterName = clusterName;
        this.status = status;
        this.numberOfNodes = numberOfNodes;
        this.numberOfDataNodes = numberOfDataNodes;
        this.activeShards = activeShards;
        this.relocatingShards = relocatingShards;
        this.activePrimaryShards = activePrimaryShards;
        this.initializingShards = initializingShards;
        this.unassignedShards = unassignedShards;
        this.activeShardsPercent = activeShardsPercent;
        this.numberOfPendingTasks = numberOfPendingTasks;
        this.timedOut = timedOut;
        this.numberOfInFlightFetch = numberOfInFlightFetch;
        this.delayedUnassignedShards = delayedUnassignedShards;
        this.taskMaxWaitingTimeMillis = taskMaxWaitingTimeMillis;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getStatus() {
        return this.status;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public int getNumberOfDataNodes() {
        return this.numberOfDataNodes;
    }

    public int getActiveShards() {
        return this.activeShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards;
    }

    public int getActivePrimaryShards() {
        return this.activePrimaryShards;
    }

    public int getInitializingShards() {
        return this.initializingShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards;
    }

    public double getActiveShardsPercent() {
        return this.activeShardsPercent;
    }

    public int getNumberOfPendingTasks() {
        return this.numberOfPendingTasks;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public int getNumberOfInFlightFetch() {
        return this.numberOfInFlightFetch;
    }

    public int getDelayedUnassignedShards() {
        return this.delayedUnassignedShards;
    }

    public long getTaskMaxWaitingTimeMillis() {
        return this.taskMaxWaitingTimeMillis;
    }

    public String toString() {
        return "ClusterHealth{clusterName='" + this.clusterName + "', status='" + this.status + "', numberOfNodes=" + this.numberOfNodes + ", numberOfDataNodes=" + this.numberOfDataNodes + ", activeShards=" + this.activeShards + ", relocatingShards=" + this.relocatingShards + ", activePrimaryShards=" + this.activePrimaryShards + ", initializingShards=" + this.initializingShards + ", unassignedShards=" + this.unassignedShards + ", activeShardsPercent=" + this.activeShardsPercent + ", numberOfPendingTasks=" + this.numberOfPendingTasks + ", timedOut=" + this.timedOut + ", numberOfInFlightFetch=" + this.numberOfInFlightFetch + ", delayedUnassignedShards=" + this.delayedUnassignedShards + ", taskMaxWaitingTimeMillis=" + this.taskMaxWaitingTimeMillis + "}";
    }

    public static ClusterHealthBuilder builder() {
        return new ClusterHealthBuilder();
    }

    public static final class ClusterHealthBuilder {
        private String clusterName = "";
        private String status = "";
        private int numberOfNodes;
        private int numberOfDataNodes;
        private int activeShards;
        private int relocatingShards;
        private int activePrimaryShards;
        private int initializingShards;
        private int unassignedShards;
        private double activeShardsPercent;
        private int numberOfPendingTasks;
        private boolean timedOut;
        private int numberOfInFlightFetch;
        private int delayedUnassignedShards;
        private long taskMaxWaitingTimeMillis;

        private ClusterHealthBuilder() {
        }

        public ClusterHealthBuilder withClusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public ClusterHealthBuilder withStatus(String status) {
            this.status = status.toUpperCase();
            return this;
        }

        public ClusterHealthBuilder withNumberOfNodes(int numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public ClusterHealthBuilder withNumberOfDataNodes(int numberOfDataNodes) {
            this.numberOfDataNodes = numberOfDataNodes;
            return this;
        }

        public ClusterHealthBuilder withActiveShards(int activeShards) {
            this.activeShards = activeShards;
            return this;
        }

        public ClusterHealthBuilder withRelocatingShards(int relocatingShards) {
            this.relocatingShards = relocatingShards;
            return this;
        }

        public ClusterHealthBuilder withActivePrimaryShards(int activePrimaryShards) {
            this.activePrimaryShards = activePrimaryShards;
            return this;
        }

        public ClusterHealthBuilder withInitializingShards(int initializingShards) {
            this.initializingShards = initializingShards;
            return this;
        }

        public ClusterHealthBuilder withUnassignedShards(int unassignedShards) {
            this.unassignedShards = unassignedShards;
            return this;
        }

        public ClusterHealthBuilder withActiveShardsPercent(double activeShardsPercent) {
            this.activeShardsPercent = activeShardsPercent;
            return this;
        }

        public ClusterHealthBuilder withNumberOfPendingTasks(int numberOfPendingTasks) {
            this.numberOfPendingTasks = numberOfPendingTasks;
            return this;
        }

        public ClusterHealthBuilder withTimedOut(boolean timedOut) {
            this.timedOut = timedOut;
            return this;
        }

        public ClusterHealthBuilder withNumberOfInFlightFetch(int numberOfInFlightFetch) {
            this.numberOfInFlightFetch = numberOfInFlightFetch;
            return this;
        }

        public ClusterHealthBuilder withDelayedUnassignedShards(int delayedUnassignedShards) {
            this.delayedUnassignedShards = delayedUnassignedShards;
            return this;
        }

        public ClusterHealthBuilder withTaskMaxWaitingTimeMillis(long taskMaxWaitingTimeMillis) {
            this.taskMaxWaitingTimeMillis = taskMaxWaitingTimeMillis;
            return this;
        }

        public ClusterHealth build() {
            return new ClusterHealth(this.clusterName, this.status, this.numberOfNodes, this.numberOfDataNodes, this.activeShards, this.relocatingShards, this.activePrimaryShards, this.initializingShards, this.unassignedShards, this.activeShardsPercent, this.numberOfPendingTasks, this.timedOut, this.numberOfInFlightFetch, this.delayedUnassignedShards, this.taskMaxWaitingTimeMillis);
        }
    }
}

